/*
 * Decompiled with CFR 0.152.
 */
package eu.nets.sis.eident.demoapp;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import javax.net.ServerSocketFactory;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.web.servlet.error.ErrorMvcAutoConfiguration;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.event.EventListener;

/*
 * Exception performing whole class analysis ignored.
 */
@SpringBootApplication(exclude={ErrorMvcAutoConfiguration.class})
@PropertySource(value={"classpath:application.properties"})
public class MainApplication {
    private static final Logger logger = Logger.getLogger(MainApplication.class);
    private static final int PORT = 8080;
    @Value(value="${base.url}")
    private String baseUrl;
    @Value(value="#{systemProperties['user.dir']}#{systemProperties['file.separator']}${logging.file}")
    private String loggingPath;

    @EventListener(value={ApplicationReadyEvent.class})
    public void doSomethingAfterStartup() {
        logger.info((Object)"E-Ident demo app started");
        System.out.println("\n\nLog file path: " + this.loggingPath);
        System.out.println("\n\nPlease point your preferred browser to " + this.baseUrl + "/eident");
    }

    public static void main(String[] args) throws UnknownHostException, IOException {
        if (args.length < 2) {
            System.out.println("\n\nERROR: Please provide a valid merchant identifier and a secret code as command line arguments to execute the demo app. If you don't have, please contact Nets support at support.esecurity@nets.eu.\n");
        } else if (MainApplication.isPortAvailable()) {
            SpringApplication.run(MainApplication.class, (String[])args);
        }
    }

    private static boolean isPortAvailable() throws IOException {
        boolean bl;
        block8: {
            ServerSocket serverSocket = ServerSocketFactory.getDefault().createServerSocket(8080, 1, InetAddress.getByName("localhost"));
            try {
                bl = true;
                if (serverSocket == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (serverSocket != null) {
                        try {
                            serverSocket.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (BindException ex) {
                    System.out.println("\n\nThe demo application cannot be started. Port 8080 is already in use.\nMake sure no other applications is configured to use this port and try again.");
                    return false;
                }
            }
            serverSocket.close();
        }
        return bl;
    }
}

