/*
 * Decompiled with CFR 0.152.
 */
package eu.nets.sis.eident.demoapp.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.RSADecrypter;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.http.CommonContentTypes;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.openid.connect.sdk.AuthenticationErrorResponse;
import com.nimbusds.openid.connect.sdk.AuthenticationResponse;
import com.nimbusds.openid.connect.sdk.AuthenticationResponseParser;
import com.nimbusds.openid.connect.sdk.AuthenticationSuccessResponse;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;

public class ClaimsService {
    public static final String DATE_FORMAT = "dd/MM/yyyy";
    private static final String TOKEN_ENDPOINT = "token_endpoint";
    private static final String JWKS_URI = "jwks_uri";
    private static final String ID_TOKEN = "id_token";
    private static final String KEYS = "keys";
    public static final String RSA_ALGORITHM = "RSA";
    public static final String NONCE = "nonce";
    private static Logger logger = Logger.getLogger(ClaimsService.class);
    private String errorDesc;

    public String getErrorDesc() {
        return this.errorDesc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, String> getClaims(String responseURL, String redirectUri, String discoveryUri, String clientID, String secretCode, String storedNonce, String truststorePath, String truststorePassword, String decryptionKeystore, String decryptionKeystorePassword, String decryptionKeyAlias) throws Exception {
        HashMap<String, String> claimsMap = new HashMap<String, String>();
        try {
            Object kid;
            SignedJWT signedJWT;
            AuthenticationResponse authResp = AuthenticationResponseParser.parse((URI)new URI(responseURL));
            if (authResp instanceof AuthenticationErrorResponse) {
                ErrorObject error = ((AuthenticationErrorResponse)authResp).getErrorObject();
                logger.error((Object)("Error code: " + error.getCode()));
                logger.error((Object)("Error description: " + error.getDescription()));
                this.errorDesc = error.getDescription();
                return null;
            }
            AuthenticationSuccessResponse successResponse = (AuthenticationSuccessResponse)authResp;
            String requestedState = new SimpleDateFormat(DATE_FORMAT).format(Calendar.getInstance().getTime());
            String state = null;
            if (null != successResponse.getState()) {
                state = successResponse.getState().getValue();
            }
            if (null != state && !state.equals(requestedState)) {
                logger.error((Object)"Received state does not match with Requested state");
                throw new Exception("state mismatch");
            }
            AuthorizationCode authCode = successResponse.getAuthorizationCode();
            HTTPResponse discoveryHTTPResp = this.getHTTPRequest(discoveryUri, truststorePath, truststorePassword).send();
            JSONObject discoveryJsonObject = discoveryHTTPResp.getContentAsJSONObject();
            String tokenEndPoint = JSONObjectUtils.getString((JSONObject)discoveryJsonObject, (String)TOKEN_ENDPOINT);
            String jwks_uri = JSONObjectUtils.getString((JSONObject)discoveryJsonObject, (String)JWKS_URI);
            logger.debug((Object)("tokenEndPoint=" + tokenEndPoint + " , jwks_uri=" + jwks_uri));
            ClientSecretBasic clientSecretBasic = new ClientSecretBasic(new ClientID(clientID), new Secret(secretCode));
            TokenRequest tokenReq = new TokenRequest(new URI(tokenEndPoint), (ClientAuthentication)clientSecretBasic, (AuthorizationGrant)new AuthorizationCodeGrant(authCode, new URI(redirectUri)));
            HTTPResponse tokenHTTPResp = tokenReq.toHTTPRequest().send();
            if (400 == tokenHTTPResp.getStatusCode()) {
                logger.error((Object)"Invalid response from token endpoint [statuscode=400]. Probably invalid secret code.  Please contact Nets support.");
                throw new Exception("Invalid response from token endpoint [statuscode=400].");
            }
            JSONObject tokenJsonObject = tokenHTTPResp.getContentAsJSONObject();
            String idtoken = JSONObjectUtils.getString((JSONObject)tokenJsonObject, (String)ID_TOKEN);
            JWT jwt = JWTParser.parse((String)idtoken);
            if (jwt instanceof EncryptedJWT) {
                logger.info((Object)"Encrypted IDToken found");
                signedJWT = this.decryptJWT(idtoken, decryptionKeystore, decryptionKeystorePassword, decryptionKeyAlias);
            } else {
                logger.info((Object)"No encryption found in IDToken");
                signedJWT = SignedJWT.parse((String)idtoken);
            }
            HTTPResponse jwksResp = this.getHTTPRequest(jwks_uri, truststorePath, truststorePassword).send();
            JSONObject jwksJsonObject = jwksResp.getContentAsJSONObject();
            JSONArray keys = JSONObjectUtils.getJSONArray((JSONObject)jwksJsonObject, (String)KEYS);
            JSONObject jsonKey = null;
            for (int i = 0; !(i >= keys.size() || null != (kid = (jsonKey = (JSONObject)keys.get(i)).get((Object)"kid")) && kid.toString().equals(signedJWT.getHeader().getKeyID())); ++i) {
                jsonKey = null;
            }
            if (null == jsonKey) {
                logger.error((Object)"No public key is found for IDToken signature verification");
                throw new Exception("No public key is found for IDToken signature verification");
            }
            logger.info((Object)("Verify signature for kid=" + signedJWT.getHeader().getKeyID()));
            PublicKey publicKey = this.buildPublicKey(jsonKey);
            if (null != publicKey) {
                RSASSAVerifier verifier = new RSASSAVerifier((RSAPublicKey)publicKey);
                if (!signedJWT.verify((JWSVerifier)verifier)) {
                    logger.error((Object)"Couldn't verify signature");
                    throw new JOSEException("Signature mismatch");
                }
                logger.info((Object)"Signature is verified");
            }
            JWTClaimsSet jwtClaimsSet = signedJWT.getJWTClaimsSet();
            logger.debug((Object)("claims: " + jwtClaimsSet));
            String nonce = jwtClaimsSet.getStringClaim(NONCE);
            if (null != nonce && !nonce.equals(storedNonce)) {
                logger.error((Object)("Possible replay attack detected! The comparison of the nonce in the returned ID Token to the session nonce failed. Expected [" + storedNonce + "] got [" + nonce + "]"));
                throw new Exception("nonce mismatch");
            }
            claimsMap.put("subjectDN", jwtClaimsSet.getStringClaim("dn"));
            claimsMap.put("ssn", this.getSSN(jwtClaimsSet));
            claimsMap.put("ssn_issuing_country", this.getSsnIssuingCountry(jwtClaimsSet));
            claimsMap.put("pid", this.getPID(jwtClaimsSet));
            if (jwtClaimsSet.getClaim("amr") instanceof String) {
                claimsMap.put("providerID", jwtClaimsSet.getStringClaim("amr"));
            } else {
                claimsMap.put("providerID", jwtClaimsSet.getStringArrayClaim("amr")[0]);
            }
            claimsMap.put("certPolicyOID", jwtClaimsSet.getStringClaim("certpolicyoid"));
            claimsMap.put("dob", jwtClaimsSet.getStringClaim("birthdate"));
            claimsMap.put("authmethod", "OAuth 2.0");
            claimsMap.put("rawClaims", this.prettyPrint((Object)jwtClaimsSet));
            String cert = jwtClaimsSet.getStringClaim("certificate");
            if (null != cert && !cert.isEmpty()) {
                claimsMap.put("cert", cert);
                return claimsMap;
            }
            claimsMap.put("cert", "No. Cert. Here. :-(");
            return claimsMap;
        }
        catch (Exception e) {
            logger.error((Object)"Exception while retrieving claims", (Throwable)e);
            throw e;
        }
    }

    public SignedJWT decryptJWT(String encryptedRequest, String decryptionKeystore, String decryptionKeystorePassword, String decryptionKeyAlias) throws Exception {
        logger.info((Object)"Decrypting IDToken");
        PrivateKey privateKey = this.getPrivateKey(decryptionKeystore, decryptionKeystorePassword, decryptionKeyAlias);
        JWEObject jweData = JWEObject.parse((String)encryptedRequest);
        jweData.decrypt((JWEDecrypter)new RSADecrypter(privateKey));
        SignedJWT signedJWT = jweData.getPayload().toSignedJWT();
        logger.info((Object)"Decryption is done");
        return signedJWT;
    }

    private PrivateKey getPrivateKey(String decryptionKeystore, String decryptionKeystorePassword, String decryptionKeyAlias) throws Exception {
        char[] passphrase = decryptionKeystorePassword.toCharArray();
        KeyStore keystore = KeyStore.getInstance("PKCS12");
        File targetDir = new File(".");
        logger.info((Object)("Target Directory Path=" + targetDir.getAbsolutePath()));
        File file = new File(decryptionKeystore);
        if (file.exists()) {
            logger.info((Object)"Keystore File exists in the current folder or at your provided path!");
            keystore.load(Files.newInputStream(Paths.get(decryptionKeystore, new String[0]), new OpenOption[0]), passphrase);
        } else {
            File file1 = new File("target/" + decryptionKeystore);
            if (file1.exists()) {
                logger.info((Object)"Keystore File exists inside target folder");
                keystore.load(Files.newInputStream(new File("target/" + decryptionKeystore).toPath(), new OpenOption[0]), passphrase);
            } else {
                logger.info((Object)"File not found elsewhere, hence fetching from classpath");
                ClassLoader classLoader = this.getClass().getClassLoader();
                InputStream inputStream = classLoader.getResourceAsStream("/" + decryptionKeystore);
                keystore.load(inputStream, passphrase);
            }
        }
        logger.info((Object)"keystore loaded");
        PrivateKey privateKey = (PrivateKey)keystore.getKey(decryptionKeyAlias, passphrase);
        logger.info((Object)("PrivateKey with alias = " + decryptionKeyAlias + (privateKey == null ? " Not found" : " Found")));
        return privateKey;
    }

    private PublicKey buildPublicKey(JSONObject keyJson) throws com.nimbusds.oauth2.sdk.ParseException, InvalidKeySpecException, NoSuchAlgorithmException {
        if (null == keyJson) {
            return null;
        }
        String kty = JSONObjectUtils.getString((JSONObject)keyJson, (String)"kty");
        if (RSA_ALGORITHM.equals(kty)) {
            return this.buildRSAPublicKey(kty, keyJson);
        }
        return null;
    }

    private PublicKey buildRSAPublicKey(String kty, JSONObject keyJson) throws InvalidKeySpecException, NoSuchAlgorithmException, com.nimbusds.oauth2.sdk.ParseException {
        String n = JSONObjectUtils.getString((JSONObject)keyJson, (String)"n");
        String e = JSONObjectUtils.getString((JSONObject)keyJson, (String)"e");
        Base64 b64 = new Base64();
        BigInteger modulus = new BigInteger(1, b64.decode(n));
        BigInteger publicExponent = new BigInteger(1, b64.decode(e));
        return KeyFactory.getInstance(kty).generatePublic(new RSAPublicKeySpec(modulus, publicExponent));
    }

    private String prettyPrint(Object obj) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        Object json = mapper.readValue(obj.toString(), Object.class);
        return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(json);
    }

    private String getSSN(JWTClaimsSet jwtClaimsSet) throws ParseException {
        String[] ssnArray = new String[]{"ssn", "dk_ssn", "no_ssn", "se_ssn", "fi_ssn", "no_nco_vsuserid"};
        String ssn = null;
        for (String name : ssnArray) {
            ssn = jwtClaimsSet.getStringClaim(name);
            if (null == ssn || ssn.isEmpty()) continue;
            return ssn;
        }
        return ssn;
    }

    private String getSsnIssuingCountry(JWTClaimsSet jwtClaimsSet) throws ParseException {
        String ssnIssuingCountry = jwtClaimsSet.getStringClaim("ssn_issuing_country");
        return ssnIssuingCountry;
    }

    private String getPID(JWTClaimsSet jwtClaimsSet) throws ParseException {
        String[] pidArray = new String[]{"no_bid_pid", "dk_dan_pid", "no_bp_pid", "smartid_pid", "mobileid_pid"};
        String pid = null;
        for (String name : pidArray) {
            pid = jwtClaimsSet.getStringClaim(name);
            if (null == pid || pid.isEmpty()) continue;
            return pid;
        }
        return pid;
    }

    public HTTPRequest getHTTPRequest(String url, String truststorePath, String truststorePassword) throws Exception {
        HTTPRequest request;
        try {
            request = new HTTPRequest(HTTPRequest.Method.GET, new URL(url));
        }
        catch (MalformedURLException ex) {
            logger.error((Object)"Exception while getting HTTPRequest", (Throwable)ex);
            throw new RuntimeException("Exception while getting HTTPRequest");
        }
        request.setContentType(CommonContentTypes.APPLICATION_URLENCODED);
        SSLSocketFactory sf = this.getSSLSocketFactory(truststorePath, truststorePassword);
        if (null != sf) {
            HTTPRequest.setDefaultSSLSocketFactory((SSLSocketFactory)sf);
        }
        return request;
    }

    public SSLSocketFactory getSSLSocketFactory(String truststorePath, String truststorePassword) throws Exception {
        SSLSocketFactory sf;
        if (null == truststorePath || null == truststorePassword) {
            throw new Exception("truststore path or password is null");
        }
        try {
            char[] passphrase = truststorePassword.toCharArray();
            KeyStore keystore = KeyStore.getInstance("JKS");
            File file = new File(truststorePath);
            if (file.exists()) {
                logger.debug((Object)"Truststore File exists in the current folder where you are!");
                keystore.load(Files.newInputStream(Paths.get(truststorePath, new String[0]), new OpenOption[0]), passphrase);
            } else {
                File file1 = new File("target/" + truststorePath);
                if (file1.exists()) {
                    logger.debug((Object)"Truststore File exists inside target folder");
                    keystore.load(Files.newInputStream(Paths.get("target/" + truststorePath, new String[0]), new OpenOption[0]), passphrase);
                } else {
                    logger.debug((Object)"File not found elsewhere, hence fetching from classpath");
                    ClassLoader classLoader = this.getClass().getClassLoader();
                    InputStream inputStream = classLoader.getResourceAsStream(truststorePath);
                    keystore.load(inputStream, passphrase);
                }
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
            tmf.init(keystore);
            SSLContext context = SSLContext.getInstance("TLS");
            TrustManager[] trustManagers = tmf.getTrustManagers();
            context.init(null, trustManagers, null);
            sf = context.getSocketFactory();
        }
        catch (Exception exp) {
            logger.error((Object)"Exception while getting socket factory", (Throwable)exp);
            throw new RuntimeException("Exception while getting SSLSocketFactory");
        }
        return sf;
    }

    public String generateEIdentUrl(String mid, String scope, String itsURL) {
        SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
        String state = df.format(new Date());
        StringBuilder eIdentUrlSb = new StringBuilder();
        try {
            eIdentUrlSb.append(itsURL);
            eIdentUrlSb.append("?client_id=");
            eIdentUrlSb.append(URLEncoder.encode(mid, "UTF-8"));
            eIdentUrlSb.append("&scope=");
            eIdentUrlSb.append(URLEncoder.encode(scope, "UTF-8"));
            eIdentUrlSb.append("&state=");
            eIdentUrlSb.append(URLEncoder.encode(state, "UTF-8"));
            eIdentUrlSb.append("&response_type=code");
        }
        catch (UnsupportedEncodingException exp) {
            logger.error((Object)"Exception while encoding EIdent URL", (Throwable)exp);
            throw new RuntimeException("Exception while encoding EIdent URL");
        }
        return eIdentUrlSb.toString();
    }
}

