document.addEventListener("DOMContentLoaded", function() {
    document.getElementById("open-popup-button").addEventListener("click", openCenteredPopup);
    document.getElementById("open-standalone-button").addEventListener("click", openStandalone);
});

let popup;

window.addEventListener("focus", keepPopupInFocus);
window.addEventListener("click", keepPopupInFocus); // Workaround for Firefox

function keepPopupInFocus() {
  if (popup && !popup.closed) {
    popup.focus();
  }
}

function openCenteredPopup() {
  let width = 650;
  let height = 676;
  let x = window.outerWidth/2 - width/2 + window.screenX;
  let y = window.outerHeight/2 - height/2 + window.screenY;
  openPopup(x, y, width, height);
}

function openPopup(x, y, width, height) {
	let eidentUrl = document.getElementById("open-popup-button").value;
	popup = window.open(eidentUrl, "eident", "width=" + width + ",height=" + height + ",top=" + y + ",left=" + x);
}

function openStandalone(){
	let eIdentUrl = document.getElementById("open-standalone-button").value;
	location.href = eIdentUrl;
}