/*
 * Decompiled with CFR 0.152.
 */
package eu.nets.sis.eident.demoapp.controller;

import eu.nets.sis.eident.demoapp.service.ClaimsService;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@PropertySource(value={"classpath:application.properties"})
public class ApplicationController {
    private static Logger logger = Logger.getLogger(ApplicationController.class);
    private String mid;
    private String nonce;
    @Value(value="${oidc.scope}")
    private String scope;
    @Value(value="${its.url}")
    private String itsURL;
    @Value(value="${oidc.redirecturi}")
    private String oidcRedirectUri;
    @Value(value="${oidc.redirecturipopup}")
    private String oidcRedirectUriPopup;
    @Value(value="${oidc.discoveryuri}")
    private String oidcDiscoveryUri;
    @Value(value="${oidc.truststorepath}")
    private String truststorePath;
    @Value(value="${oidc.truststorepwd}")
    private String truststorePassword;
    @Value(value="${server.port}")
    private String port;
    @Value(value="${idtoken.decrypt.private.keystore}")
    private String decryptionKeystore;
    @Value(value="${idtoken.decrypt.private.keystorepassword}")
    private String decryptionKeystorePassword;
    @Value(value="${idtoken.decrypt.private.keyalias}")
    private String decryptionKeyAlias;
    @Autowired
    private ApplicationArguments applicationArguments;
    private boolean isPopUISelected = false;

    @RequestMapping(value={"/eident"}, method={RequestMethod.GET})
    public String index(ModelMap model) {
        this.mid = this.applicationArguments.getSourceArgs().length > 0 ? this.applicationArguments.getSourceArgs()[0] : "";
        this.nonce = new BigInteger(50, new SecureRandom()).toString(16);
        ClaimsService claimsService = new ClaimsService();
        String eIdentUrl = claimsService.generateEIdentUrl(this.mid, this.scope, this.itsURL);
        model.put((Object)"eIdentUrl", (Object)(eIdentUrl + "&redirect_uri=" + this.oidcRedirectUri));
        model.put((Object)"eIdentUrlForPopup", (Object)(eIdentUrl + "&redirect_uri=" + this.oidcRedirectUriPopup));
        logger.info((Object)"Loading home page");
        return "index";
    }

    @RequestMapping(value={"/eident/popupreturn"}, method={RequestMethod.GET})
    public String closePopupAndGetClaims(HttpServletRequest request, ModelMap model) throws Exception {
        this.isPopUISelected = true;
        model.put((Object)"oidcRedirectUri", (Object)this.oidcRedirectUri);
        return "popupCloser";
    }

    @RequestMapping(value={"/eident/return"}, method={RequestMethod.GET})
    public String claims(HttpServletRequest request, ModelMap model) throws Exception {
        String redirectUri = this.isPopUISelected ? this.oidcRedirectUriPopup : this.oidcRedirectUri;
        this.isPopUISelected = false;
        HashMap claims = new HashMap();
        String responseURL = request.getRequestURI() + "?" + request.getQueryString();
        String secretCode = this.applicationArguments.getSourceArgs().length > 1 ? this.applicationArguments.getSourceArgs()[1] : "";
        this.decryptionKeystore = this.applicationArguments.getSourceArgs().length > 2 ? this.applicationArguments.getSourceArgs()[2] : this.decryptionKeystore;
        this.decryptionKeystorePassword = this.applicationArguments.getSourceArgs().length > 3 ? this.applicationArguments.getSourceArgs()[3] : this.decryptionKeystorePassword;
        this.decryptionKeyAlias = this.applicationArguments.getSourceArgs().length > 4 ? this.applicationArguments.getSourceArgs()[4] : this.decryptionKeyAlias;
        ClaimsService claimsService = new ClaimsService();
        Map result = claimsService.getClaims(responseURL, redirectUri, this.oidcDiscoveryUri, this.mid, secretCode, this.nonce, this.truststorePath, this.truststorePassword, this.decryptionKeystore, this.decryptionKeystorePassword, this.decryptionKeyAlias);
        if (null == result) {
            model.put((Object)"errorDesc", (Object)claimsService.getErrorDesc());
            return "canceltimeout";
        }
        if (!result.isEmpty()) {
            claims.putAll(result);
        }
        model.put((Object)"oidc", claims);
        logger.info((Object)"Identification is completed");
        return "status";
    }

    @RequestMapping(value={"/error"}, method={RequestMethod.GET})
    @ExceptionHandler(value={Exception.class})
    public String defaultErrorHandler() {
        logger.info((Object)"Moving to error page");
        return "error";
    }

    @ModelAttribute(value="homeUrl")
    public String getHomeUrl() {
        return String.format("http://localhost:%s/eident", this.port);
    }
}

