/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.trustsign.tsm.xml.messages.containers;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Organization {
    private String localOrganizationRef;
    private String organizationNumber;
    private boolean attachBusinessCertificate = false;
    private String country;

    public Organization() {
    }

    public Organization(Element element) {
        NodeList nl = element.getElementsByTagName("LocalOrganizationRef");
        if (nl.getLength() > 0 && nl.item(0).getFirstChild() != null) {
            this.setLocalOrganizationRef(nl.item(0).getFirstChild().getNodeValue());
        }
        if ((nl = element.getElementsByTagName("OrganizationNumber")).getLength() > 0 && nl.item(0).getFirstChild() != null) {
            this.setOrganizationNumber(nl.item(0).getFirstChild().getNodeValue());
        }
        if ((nl = element.getElementsByTagName("AttachBusinessCertificateToSDO")).getLength() > 0 && nl.item(0).getFirstChild() != null) {
            String attachBusinessCertificate = nl.item(0).getFirstChild().getNodeValue();
            this.setAttachBusinessCertificate("true".equalsIgnoreCase(attachBusinessCertificate));
        }
        if ((nl = element.getElementsByTagName("Country")).getLength() > 0 && nl.item(0).getFirstChild() != null) {
            this.setCountry(nl.item(0).getFirstChild().getNodeValue());
        }
    }

    public Element toXML(Document doc) {
        Element childElement;
        Element root = doc.createElement("Organization");
        if (null != this.getLocalOrganizationRef()) {
            childElement = doc.createElement("LocalOrganizationRef");
            childElement.appendChild(doc.createTextNode(this.getLocalOrganizationRef()));
            root.appendChild(childElement);
        }
        if (null != this.getOrganizationNumber()) {
            childElement = doc.createElement("OrganizationNumber");
            childElement.appendChild(doc.createTextNode(this.getOrganizationNumber()));
            root.appendChild(childElement);
        }
        Element childBc = doc.createElement("AttachBusinessCertificateToSDO");
        if (this.attachBusinessCertificate) {
            childBc.appendChild(doc.createTextNode("true"));
        } else {
            childBc.appendChild(doc.createTextNode("false"));
        }
        root.appendChild(childBc);
        if (null != this.getCountry()) {
            Element childElement2 = doc.createElement("Country");
            childElement2.appendChild(doc.createTextNode(this.getCountry()));
            root.appendChild(childElement2);
        }
        doc.getFirstChild().appendChild(root);
        return root;
    }

    public String getLocalOrganizationRef() {
        return this.localOrganizationRef;
    }

    public void setLocalOrganizationRef(String localOrganizationRef) {
        this.localOrganizationRef = localOrganizationRef;
    }

    public String getOrganizationNumber() {
        return this.organizationNumber;
    }

    public void setOrganizationNumber(String organizationNumber) {
        this.organizationNumber = organizationNumber;
    }

    public boolean isAttachBusinessCertificate() {
        return this.attachBusinessCertificate;
    }

    public void setAttachBusinessCertificate(boolean attachBusinessCertificate) {
        this.attachBusinessCertificate = attachBusinessCertificate;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getCountry() {
        return this.country;
    }
}

