/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.trustsign.tsm.xml.messages.containers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import no.bbs.tt.trustsign.tsm.xml.messages.containers.SigningProcessDetails;
import no.bbs.tt.trustsign.tsm.xml.util.DateUtility;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class StepDetails
implements Serializable {
    private static final long serialVersionUID = -5375274886001079437L;
    private int stepNumber = -1;
    private Date stepDeadline = null;
    private ArrayList<SigningProcessDetails> signingProcessesDetails = null;
    private String stepStatus = null;

    public StepDetails() {
    }

    public StepDetails(Element element) {
        NodeList nl = element.getElementsByTagName("StepNumber");
        if (nl.getLength() > 0 && nl.item(0).getFirstChild() != null) {
            this.setStepNumber(Integer.parseInt(nl.item(0).getFirstChild().getNodeValue()));
        }
        if ((nl = element.getElementsByTagName("StepDeadline")).getLength() > 0 && nl.item(0).getFirstChild() != null) {
            this.setStepDeadline(DateUtility.XMLToDate(nl.item(0).getFirstChild().getNodeValue()));
        }
        if ((nl = element.getElementsByTagName("Status")).getLength() > 0 && nl.item(0).getFirstChild() != null) {
            this.setStepStatus(nl.item(0).getFirstChild().getNodeValue());
        }
        if ((nl = element.getElementsByTagName("SigningProcessDetails")).getLength() > 0) {
            this.signingProcessesDetails = new ArrayList();
            for (int i = 0; i < nl.getLength(); ++i) {
                Element currSP = (Element)nl.item(i);
                this.signingProcessesDetails.add(new SigningProcessDetails(currSP));
            }
        }
    }

    public Element toXML(Document doc) {
        Element childElement;
        Element root = doc.createElement("StepDetails");
        Element stepNumberElem = doc.createElement("StepNumber");
        stepNumberElem.appendChild(doc.createTextNode("" + this.getStepNumber()));
        root.appendChild(stepNumberElem);
        if (null != this.getStepDeadline()) {
            childElement = doc.createElement("StepDeadline");
            childElement.appendChild(doc.createTextNode(DateUtility.DateToXML(this.getStepDeadline())));
            root.appendChild(childElement);
        }
        if (null != this.getStepStatus()) {
            childElement = doc.createElement("Status");
            childElement.appendChild(doc.createTextNode(this.getStepStatus()));
            root.appendChild(childElement);
        }
        if (null != this.getSigningProcessDetails() && !this.getSigningProcessDetails().isEmpty()) {
            for (int i = 0; i < this.getSigningProcessDetails().size(); ++i) {
                SigningProcessDetails curSP = this.getSigningProcessDetails().get(i);
                root.appendChild(curSP.toXML(doc));
            }
        }
        doc.getFirstChild().appendChild(root);
        return root;
    }

    public String getStepStatus() {
        return this.stepStatus;
    }

    public void setStepStatus(String stepStatus) {
        this.stepStatus = stepStatus;
    }

    public int getStepNumber() {
        return this.stepNumber;
    }

    public void setStepNumber(int stepNumber) {
        this.stepNumber = stepNumber;
    }

    public Date getStepDeadline() {
        return this.stepDeadline;
    }

    public void setStepDeadline(Date stepDeadline) {
        this.stepDeadline = stepDeadline;
    }

    public ArrayList<SigningProcessDetails> getSigningProcessDetails() {
        return this.signingProcessesDetails;
    }

    public void setSigningProcessDetails(ArrayList<SigningProcessDetails> signingProcessesDetails) {
        this.signingProcessesDetails = signingProcessesDetails;
    }

    public void addSigningProcessDetails(SigningProcessDetails sp) {
        if (null == this.signingProcessesDetails) {
            this.signingProcessesDetails = new ArrayList();
        }
        this.signingProcessesDetails.add(sp);
    }
}

