/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.trustsign.tsm.xml.util;

import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import no.bbs.tt.trustsign.tsm.xml.error.TSMException;
import no.bbs.tt.trustsign.tsm.xml.errorhandler.TSMDefaultErrorHandler;
import no.bbs.tt.trustsign.tsm.xml.statics.SchemaTags;
import no.bbs.tt.trustsign.tsm.xml.statics.XSDs;
import no.bbs.tt.trustsign.tsm.xml.util.SecureDocumentBuilderFactory;
import no.bbs.tt.trustsign.tsm.xml.util.XMLUtil;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class XMLSchemaValidator {
    public static Document validateXML(String xml, String[] schemas) throws TSMException {
        try {
            DocumentBuilderFactory dbf = SecureDocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setValidating(true);
            dbf.setAttribute(SchemaTags.SCHEMA_LANGUAGE, "http://www.w3.org/2001/XMLSchema");
            if (null != schemas && schemas[0] != null) {
                dbf.setAttribute(SchemaTags.SCHEMA_SOURCE, schemas);
            } else {
                String schemaLocation = XMLUtil.getSchemalocationAttr(xml);
                String[] supportedXsds = XSDs.supportedXsds;
                boolean schemalocationValueSupported = false;
                for (int i = 0; i < supportedXsds.length; ++i) {
                    if (!supportedXsds[i].equals(schemaLocation)) continue;
                    schemalocationValueSupported = true;
                }
                if (!schemalocationValueSupported) {
                    throw new TSMException("The input schemalocation [" + schemaLocation + "] is not supported");
                }
            }
            DocumentBuilder docBuidler = dbf.newDocumentBuilder();
            docBuidler.setErrorHandler(new TSMDefaultErrorHandler());
            Document doc = docBuidler.parse(new InputSource(new StringReader(xml)));
            return doc;
        }
        catch (TSMException tsme2) {
            tsme2.printStackTrace();
            String errmsg = "Failed to validate XML according to schema. Reason: " + tsme2.getMessage();
            Object tsme2 = null;
            throw new TSMException(errmsg);
        }
        catch (Throwable t2) {
            String errmsg = "Failed to validate XML according to schema. Reason: " + t2.getMessage();
            Object t2 = null;
            throw new TSMException(errmsg);
        }
    }
}

