/*
 * Decompiled with CFR 0.152.
 */
package eu.nets.sis.esign.demoapp.service;

import eu.nets.sis.esign.demoapp.DemoAppProperties;
import java.io.InputStream;
import java.security.Security;
import java.util.ArrayList;
import java.util.Date;
import no.bbs.trust.esignclientapi.exception.ESignClientException;
import no.bbs.trust.esignclientapi.impl.ESigningFacade;
import no.bbs.trust.esignclientapi.impl.ESigningFactory;
import no.bbs.trust.esignclientapi.impl.MerchantContext;
import no.bbs.trust.esignclientapi.statics.Environment;
import no.bbs.trust.esignclientapi.statics.KeyStoreType;
import no.bbs.tt.trustsign.tsm.xml.messages.GetSigningProcessesRequest;
import no.bbs.tt.trustsign.tsm.xml.messages.GetSigningProcessesResponse;
import no.bbs.tt.trustsign.tsm.xml.messages.InsertOrderRequest;
import no.bbs.tt.trustsign.tsm.xml.messages.InsertOrderResponse;
import no.bbs.tt.trustsign.tsm.xml.messages.containers.BankID;
import no.bbs.tt.trustsign.tsm.xml.messages.containers.BankID_SE;
import no.bbs.tt.trustsign.tsm.xml.messages.containers.Doc;
import no.bbs.tt.trustsign.tsm.xml.messages.containers.ExecutionDetails;
import no.bbs.tt.trustsign.tsm.xml.messages.containers.IPKI;
import no.bbs.tt.trustsign.tsm.xml.messages.containers.MitID;
import no.bbs.tt.trustsign.tsm.xml.messages.containers.PDF;
import no.bbs.tt.trustsign.tsm.xml.messages.containers.Signer;
import no.bbs.tt.trustsign.tsm.xml.messages.containers.SigningProcess;
import no.bbs.tt.trustsign.tsm.xml.messages.containers.SigningProcessResult;
import no.bbs.tt.trustsign.tsm.xml.messages.containers.Step;
import no.bbs.tt.trustsign.tsm.xml.messages.containers.Text;
import no.bbs.tt.trustsign.tsm.xml.messages.containers.Tupas;
import no.bbs.tt.trustsign.tsm.xml.messages.containers.WebContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class DemoAppService {
    private static final Logger LOGGER = LogManager.getLogger(DemoAppService.class);
    private static final String DOC1 = "doc1";
    private static final String USER1 = "user1";
    private static final String GUI1 = "gui1";
    public static boolean isPopUISelected = false;

    public static void registerMerchantContext(String keyStorePath, String keyStorePwd) {
        Security.addProvider(new BouncyCastleProvider());
        try {
            MerchantContext merchantContext = new MerchantContext();
            ClassLoader classLoader = DemoAppService.class.getClassLoader();
            InputStream inputStream = classLoader.getResourceAsStream(DemoAppProperties.clientTrustStore);
            merchantContext.setTruststore(inputStream);
            merchantContext.setSslKeystorePath(keyStorePath);
            merchantContext.setSslKeystorePwd(keyStorePwd);
            merchantContext.setSigningKeystorePath(keyStorePath);
            merchantContext.setSigningKeystorePwd(keyStorePwd);
            merchantContext.setTruststorePath(null);
            merchantContext.setTruststorePwd(DemoAppProperties.clientTrustStorePwd);
            merchantContext.setTruststoreType(KeyStoreType.JKS);
            merchantContext.setCommTimeout(10000);
            merchantContext.setEnv(Environment.PRE_PRODUCTION);
            merchantContext.setMerchantId(DemoAppProperties.merchantId);
            merchantContext.setMerchantName(DemoAppProperties.merchantName);
            ESigningFactory.INSTANCE.registerMerchantContext(merchantContext);
        }
        catch (ESignClientException e) {
            LOGGER.error("E-Sign client api setup has failed", (Throwable)e);
            System.out.println("\n\n<<<<<<<<<<ERROR>>>>>>>>>>\n\nE-Sign client api setup has failed.\n\nErrorMessage=" + e.getMessage() + ".\n\n");
            System.exit(0);
        }
    }

    public String getSigningURL(String docType) {
        String url = null;
        try {
            InsertOrderResponse insertOrderResponse = this.insertOrder(docType);
            url = this.getSignUrlFromSigningProcess(insertOrderResponse);
        }
        catch (Exception e) {
            LOGGER.error("Got Exception during get Signurl from IN Groupe ", (Throwable)e);
        }
        return url;
    }

    private String getSignUrlFromSigningProcess(InsertOrderResponse insertOrderResponse) {
        String signUrl = null;
        try {
            LOGGER.info("Retrieving SignURL");
            ESigningFacade facade = ESigningFactory.INSTANCE.getESigningFacade(DemoAppProperties.merchantName);
            GetSigningProcessesRequest req = new GetSigningProcessesRequest();
            req.setOrderID(insertOrderResponse.getOrderID());
            req.setMerchantID(insertOrderResponse.getMerchantID());
            req.setMessageID(insertOrderResponse.getMessageID());
            req.setTime(new Date());
            req.setLocalSignerReference(USER1);
            GetSigningProcessesResponse response = facade.getSigningProcesses(req);
            ArrayList<SigningProcessResult> signinprocesses = response.getSigningProcessResults();
            if (null != signinprocesses) {
                for (SigningProcessResult sp : signinprocesses) {
                    signUrl = sp.getSignURL();
                }
            }
            return signUrl;
        }
        catch (ESignClientException t) {
            LOGGER.error("Got ESignClientException during getSignurl ", (Throwable)t);
        }
        catch (Throwable t) {
            LOGGER.error("Got exception during getSignurl ", t);
        }
        return signUrl;
    }

    private ArrayList<Doc> getDocument(String docType) {
        Doc doc = new Doc();
        if ("PDF".equals(docType)) {
            PDF pdf = new PDF();
            pdf.setB64DocumentBytesAsString(DemoAppProperties.pdfBase64String);
            doc.setDocType(pdf);
        } else if ("TXT".equals(docType)) {
            Text txt = new Text();
            txt.setB64DocumentBytesAsString(DemoAppProperties.txtBase64String);
            doc.setDocType(txt);
        }
        doc.setDesc(DemoAppProperties.description);
        doc.setLocalDocRef(DOC1);
        doc.setTitle(DemoAppProperties.title);
        doc.setRequiresAuthentication(false);
        ArrayList<Doc> documents = new ArrayList<Doc>();
        documents.add(doc);
        return documents;
    }

    private InsertOrderResponse insertOrder(String docType) throws ESignClientException {
        ESigningFacade facade = ESigningFactory.INSTANCE.getESigningFacade(DemoAppProperties.merchantName);
        InsertOrderRequest request = new InsertOrderRequest();
        request.setMerchantID(Long.parseLong(DemoAppProperties.merchantId));
        request.setMessageID("esignclientapi-test-1");
        request.setTime(new Date());
        request.setAdditionalInfo(DemoAppProperties.additionalInfo);
        request.setOrderID(DemoAppProperties.merchantId + "-esc-" + System.currentTimeMillis());
        request.setDocuments(this.getDocument(docType));
        LOGGER.info(String.format("OrderID=%s, MerchantID=%s", request.getOrderID(), request.getMerchantID()));
        ArrayList<IPKI> acceptedPKIs = new ArrayList<IPKI>();
        acceptedPKIs.add(new BankID());
        acceptedPKIs.add(new Tupas());
        acceptedPKIs.add(new BankID_SE());
        acceptedPKIs.add(new MitID());
        Signer signer = new Signer();
        signer.setLocalSignerRef(USER1);
        signer.setName(DemoAppProperties.enduserSigner);
        signer.setAcceptedPKIs(acceptedPKIs);
        ArrayList<Signer> signers = new ArrayList<Signer>();
        signers.add(signer);
        request.setSigners(signers);
        ExecutionDetails executionDetails = new ExecutionDetails();
        executionDetails.setOrderDeadline(new Date(System.currentTimeMillis() + 86400000L));
        executionDetails.setDisplayProcessInfo("NameStatusTime");
        Step step1 = new Step();
        step1.setStepNumber(1);
        SigningProcess signingProcess = new SigningProcess();
        signingProcess.setLocalDocumentReferance(DOC1);
        signingProcess.setLocalSignerReferance(USER1);
        signingProcess.setLocalWebContextRef(GUI1);
        step1.addSigningProcess(signingProcess);
        executionDetails.addStep(step1);
        WebContext webContext = new WebContext();
        webContext.setExitURL(DemoAppProperties.baseUrl + DemoAppProperties.contextPath + "?status=completed");
        webContext.setAbortURL(DemoAppProperties.baseUrl + DemoAppProperties.contextPath + "?status=canceled");
        webContext.setLocalWebContextRef(GUI1);
        webContext.setSignURLBase(DemoAppProperties.signUrlBase);
        webContext.setErrorURLBase(DemoAppProperties.baseUrl + DemoAppProperties.contextPath + "?status=error");
        webContext.setStyleURL(DemoAppProperties.styleUrl);
        request.setExecutionDetails(executionDetails);
        ArrayList<WebContext> webContexts = new ArrayList<WebContext>();
        webContexts.add(webContext);
        request.setWebContexts(webContexts);
        LOGGER.info("Sending an InsertOrder request");
        return facade.insertOrder(request);
    }
}

