/*
 * Decompiled with CFR 0.152.
 */
package eu.nets.sis.esign.demoapp.util;

import eu.nets.sis.esign.demoapp.SigningStatuses;
import eu.nets.sis.esign.demoapp.service.DemoAppService;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PageUIUtil {
    private static final Logger LOGGER = LogManager.getLogger(PageUIUtil.class);
    private static Configuration freemarkerConfig;

    public static void streamPage(Map<String, String> data, String templateName, PrintWriter out) {
        PageUIUtil.initializeFreemarker();
        try {
            Template temp = freemarkerConfig.getTemplate(templateName);
            temp.process(data, out);
        }
        catch (TemplateException | IOException e) {
            LOGGER.error("Got exception while loading page.", (Throwable)e);
        }
    }

    private static synchronized void initializeFreemarker() {
        if (freemarkerConfig != null) {
            return;
        }
        freemarkerConfig = new Configuration(Configuration.VERSION_2_3_30);
        freemarkerConfig.setDefaultEncoding("UTF-8");
        freemarkerConfig.setClassForTemplateLoading(PageUIUtil.class, "/");
        freemarkerConfig.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
    }

    public static String getTemplateName(String status) {
        if (SigningStatuses.COMPLETED.status.equals(status) || SigningStatuses.CANCELED.status.equals(status)) {
            if (DemoAppService.isPopUISelected) {
                DemoAppService.isPopUISelected = false;
                return "popupCloser.ftl";
            }
            LOGGER.info("Signing " + status);
            return "status.ftl";
        }
        return "error.ftl";
    }
}

