/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.trust.esignclientapi.util;

import java.io.FileInputStream;
import java.security.KeyStore;
import no.bbs.trust.esignclientapi.comm.DHCConfiguration;
import no.bbs.trust.esignclientapi.exception.InvalidConfigurationException;
import no.bbs.trust.esignclientapi.impl.MerchantContext;
import no.bbs.trust.esignclientapi.p12.PKCS12Keystore;
import no.bbs.trust.esignclientapi.statics.Environment;

public class ConfigUtil {
    public void validateMerchantContext(MerchantContext mCtx) throws InvalidConfigurationException {
        if (null == mCtx.getEnv()) {
            mCtx.setEnv(Environment.DEVELOPMENT);
        }
        if (this.isNullOrEmpty(mCtx.getMerchantId())) {
            throw new InvalidConfigurationException("Invalid MerchantContext config. MerchantId cannot be null or empty [" + mCtx.getMerchantId() + "]");
        }
        if (this.isNullOrEmpty(mCtx.getMerchantName())) {
            throw new InvalidConfigurationException("Invalid MerchantContext config. MerchantName cannot be null or empty [" + mCtx.getMerchantName() + "]");
        }
        if (this.isNullOrEmpty(mCtx.getSigningKeystorePwd())) {
            throw new InvalidConfigurationException("Invalid MerchantContext config. SigningKeystorePwd cannot be null or empty");
        }
        try {
            if (mCtx.getSigningKeystorePath() != null) {
                mCtx.setSigningKeystore(new FileInputStream(mCtx.getSigningKeystorePath()));
            }
            PKCS12Keystore signingKeyStore = new PKCS12Keystore(mCtx.getSigningKeystore(), mCtx.getSigningKeystorePwd(), false);
            mCtx.setSigningPKCS12Keystore(signingKeyStore);
            if (mCtx.getSigningKeystorePath() != null) {
                mCtx.getSigningKeystore().close();
            }
        }
        catch (Throwable t) {
            throw new InvalidConfigurationException("Invalid MerchantContext config. Failed to load SigningKeystore (" + mCtx.getSigningKeystorePath() + "). Reason: " + t.getMessage());
        }
        try {
            if (mCtx.getSslKeystorePath() != null) {
                mCtx.setSslKeystore(new FileInputStream(mCtx.getSslKeystorePath()));
            }
            PKCS12Keystore sslKeyStore = new PKCS12Keystore(mCtx.getSslKeystore(), mCtx.getSslKeystorePwd(), false);
            mCtx.setSslPKCS12Keystore(sslKeyStore);
            if (mCtx.getSslKeystorePath() != null) {
                mCtx.getSslKeystore().close();
            }
        }
        catch (Throwable t) {
            throw new InvalidConfigurationException("Invalid MerchantContext config. Failed to load SslKeystore (" + mCtx.getSslKeystorePath() + "). Reason: " + t.getMessage());
        }
        if ((mCtx.getEnv() == Environment.PRE_PRODUCTION || mCtx.getEnv() == Environment.PRODUCTION) && this.isNullOrEmpty(mCtx.getSslKeystorePwd())) {
            throw new InvalidConfigurationException("Invalid MerchantContext config. SslKeystorePwd cannot be null or empty");
        }
        if (!this.isNullOrEmpty(mCtx.getHttpProxyHost())) {
            if (!this.isInteger(mCtx.getHttpProxyPort())) {
                throw new InvalidConfigurationException("Invalid MerchantContext config. HttpProxyPort cannot be null or empty when HttpProxyHost is set");
            }
            if (!this.isNullOrEmpty(mCtx.getHttpProxyUsername()) && this.isNullOrEmpty(mCtx.getHttpProxyPassword())) {
                throw new InvalidConfigurationException("Invalid MerchantContext config. HttpProxyPassword cannot be null or empty when HttpProxyUsername is set");
            }
        }
        if (this.isNullOrEmpty(mCtx.getTruststorePwd())) {
            throw new InvalidConfigurationException("Invalid MerchantContext config. TruststorePwd cannot be null or empty");
        }
        if (null == mCtx.getTruststoreType()) {
            throw new InvalidConfigurationException("Invalid MerchantContext config. TruststoreType cannot be null");
        }
        try {
            if (mCtx.getTruststorePath() != null) {
                mCtx.setTruststore(new FileInputStream(mCtx.getTruststorePath()));
            }
            String truststorepwd = mCtx.getTruststorePwd();
            char[] pwdChars = new char[truststorepwd.length()];
            truststorepwd.getChars(0, truststorepwd.length(), pwdChars, 0);
            KeyStore truststore = KeyStore.getInstance(mCtx.getTruststoreType().getType());
            truststore.load(mCtx.getTruststore(), pwdChars);
            mCtx.setTruststoreKeystore(truststore);
            if (mCtx.getTruststorePath() != null) {
                mCtx.getTruststore().close();
            }
        }
        catch (Throwable t) {
            String errmsg = "Invalid MerchantContext config. Unable to access the configured TrustStore. Reason: " + t.getMessage();
            if (null != t.getCause()) {
                errmsg = errmsg + ". Cause: " + t.getCause().getMessage();
            }
            throw new InvalidConfigurationException(errmsg);
        }
        DHCConfiguration dhcconfig = new DHCConfiguration();
        dhcconfig.setConnectRetryCount(0);
        dhcconfig.setKeyStore(mCtx.getSslPKCS12Keystore().getKeyStore());
        dhcconfig.setKeyStorePwd(mCtx.getSslKeystorePwd());
        dhcconfig.setKeyStoreType("PKCS12");
        dhcconfig.setProxyHost(mCtx.getHttpProxyHost());
        dhcconfig.setProxyPort(mCtx.getHttpProxyPort());
        dhcconfig.setProxyPwd(mCtx.getHttpProxyPassword());
        dhcconfig.setProxyUser(mCtx.getHttpProxyUsername());
        if (mCtx.getCommTimeout() > 0) {
            dhcconfig.setSocketTimeoutOverride(mCtx.getCommTimeout());
        }
        dhcconfig.setTrustStore(mCtx.getTruststoreKeystore());
        dhcconfig.setTrustStorePwd(mCtx.getTruststorePwd());
        dhcconfig.setTrustStoreType(mCtx.getTruststoreType().getType());
        dhcconfig.setUrl(mCtx.getEnv().getUrl());
        mCtx.setDhcConfig(dhcconfig);
    }

    private boolean isNullOrEmpty(String config) {
        return null == config || "".equals(config);
    }

    private boolean isInteger(String config) {
        if (null == config || "".equals(config)) {
            return true;
        }
        try {
            Integer.parseInt(config);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }
}

