/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.trustsign.tsm.xml.messages.containers;

import java.io.Serializable;
import java.util.Date;
import no.bbs.tt.trustsign.tsm.xml.util.DateUtility;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class NotificationRecord
implements Serializable {
    private static final long serialVersionUID = 2619230614446131953L;
    private String channelType = null;
    private String endpoint = null;
    private String trigger = null;
    private String notificationStatus = null;
    private Date notificationSentTime = null;
    private int stepNumber = -1;
    private String localDocumentReference = null;
    private long merchantIDRef = -1L;
    private String localSignerReference = null;

    public NotificationRecord() {
    }

    public NotificationRecord(Element element) {
        Element presentationELem;
        NodeList nl = element.getElementsByTagName("Recipient");
        if (nl.getLength() > 0 && nl.item(0).getFirstChild() != null) {
            presentationELem = (Element)nl.item(0);
            if ((nl = presentationELem.getElementsByTagName("MerchantIDRef")).getLength() > 0 && nl.item(0).getFirstChild() != null) {
                this.setMerchantIDRef(Long.parseLong(nl.item(0).getFirstChild().getNodeValue()));
            }
            if ((nl = presentationELem.getElementsByTagName("LocalSignerReference")).getLength() > 0 && nl.item(0).getFirstChild() != null) {
                this.setLocalSignerReference(nl.item(0).getFirstChild().getNodeValue());
            }
        }
        if ((nl = element.getElementsByTagName("Channel")).getLength() > 0 && nl.item(0).getFirstChild() != null) {
            presentationELem = (Element)nl.item(0);
            if ((nl = presentationELem.getElementsByTagName("ChannelType")).getLength() > 0 && nl.item(0).getFirstChild() != null) {
                this.setChannelType(nl.item(0).getFirstChild().getNodeValue());
            }
            if ((nl = presentationELem.getElementsByTagName("EndPoint")).getLength() > 0 && nl.item(0).getFirstChild() != null) {
                this.setEndpoint(nl.item(0).getFirstChild().getNodeValue());
            }
        }
        if ((nl = element.getElementsByTagName("Trigger")).getLength() > 0 && nl.item(0).getFirstChild() != null) {
            this.setTrigger(nl.item(0).getFirstChild().getNodeValue());
        }
        if ((nl = element.getElementsByTagName("NotificationStatus")).getLength() > 0 && nl.item(0).getFirstChild() != null) {
            this.setNotificationStatus(nl.item(0).getFirstChild().getNodeValue());
        }
        if ((nl = element.getElementsByTagName("NotificationSentTime")).getLength() > 0 && nl.item(0).getFirstChild() != null) {
            this.setNotificationSentTime(DateUtility.XMLToDate(nl.item(0).getFirstChild().getNodeValue()));
        }
        if ((nl = element.getElementsByTagName("StepNumber")).getLength() > 0 && nl.item(0).getFirstChild() != null) {
            this.setStepNumber(Integer.parseInt(nl.item(0).getFirstChild().getNodeValue()));
        }
        if ((nl = element.getElementsByTagName("LocalDocumentReference")).getLength() > 0 && nl.item(0).getFirstChild() != null) {
            this.setLocalDocumentReference(nl.item(0).getFirstChild().getNodeValue());
        }
    }

    public Element toXML(Document doc) {
        Element childElement;
        Element root = doc.createElement("NotificationRecord");
        if (this.getMerchantIDRef() > -1L || null != this.getLocalSignerReference()) {
            Element recepientElement = doc.createElement("Recipient");
            if (this.getMerchantIDRef() > -1L) {
                Element merchantIDRefElem = doc.createElement("MerchantIDRef");
                merchantIDRefElem.appendChild(doc.createTextNode("" + this.getMerchantIDRef()));
                recepientElement.appendChild(merchantIDRefElem);
            }
            if (null != this.getLocalSignerReference()) {
                Element localSignRefElem = doc.createElement("LocalSignerReference");
                localSignRefElem.appendChild(doc.createTextNode(this.getLocalSignerReference()));
                recepientElement.appendChild(localSignRefElem);
            }
            root.appendChild(recepientElement);
        }
        if (null != this.getChannelType()) {
            Element presentationElement = doc.createElement("Channel");
            Element titleElem = doc.createElement("ChannelType");
            titleElem.appendChild(doc.createTextNode(this.getChannelType()));
            presentationElement.appendChild(titleElem);
            if (null != this.getEndpoint()) {
                Element descElem = doc.createElement("EndPoint");
                descElem.appendChild(doc.createTextNode(this.getEndpoint()));
                presentationElement.appendChild(descElem);
            }
            root.appendChild(presentationElement);
        }
        if (null != this.getTrigger()) {
            Element docTypeElement = doc.createElement("Trigger");
            docTypeElement.appendChild(doc.createTextNode(this.getTrigger()));
            root.appendChild(docTypeElement);
        }
        if (null != this.getNotificationStatus()) {
            childElement = doc.createElement("NotificationStatus");
            childElement.appendChild(doc.createTextNode(this.getNotificationStatus()));
            root.appendChild(childElement);
        }
        if (null != this.getNotificationSentTime()) {
            childElement = doc.createElement("NotificationSentTime");
            childElement.appendChild(doc.createTextNode(DateUtility.DateToXML(this.getNotificationSentTime())));
            root.appendChild(childElement);
        }
        if (this.getStepNumber() > 0) {
            childElement = doc.createElement("StepNumber");
            childElement.appendChild(doc.createTextNode("" + this.getStepNumber()));
            root.appendChild(childElement);
        }
        if (null != this.getLocalDocumentReference()) {
            childElement = doc.createElement("LocalDocumentReference");
            childElement.appendChild(doc.createTextNode(this.getLocalDocumentReference()));
            root.appendChild(childElement);
        }
        doc.getFirstChild().appendChild(root);
        return root;
    }

    public String getChannelType() {
        return this.channelType;
    }

    public void setChannelType(String channelType) {
        this.channelType = channelType;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getTrigger() {
        return this.trigger;
    }

    public void setTrigger(String trigger) {
        this.trigger = trigger;
    }

    public String getNotificationStatus() {
        return this.notificationStatus;
    }

    public void setNotificationStatus(String notificationStatus) {
        this.notificationStatus = notificationStatus;
    }

    public Date getNotificationSentTime() {
        return this.notificationSentTime;
    }

    public void setNotificationSentTime(Date notificationSentTime) {
        this.notificationSentTime = notificationSentTime;
    }

    public int getStepNumber() {
        return this.stepNumber;
    }

    public void setStepNumber(int stepNumber) {
        this.stepNumber = stepNumber;
    }

    public String getLocalDocumentReference() {
        return this.localDocumentReference;
    }

    public void setLocalDocumentReference(String localDocumentReference) {
        this.localDocumentReference = localDocumentReference;
    }

    public long getMerchantIDRef() {
        return this.merchantIDRef;
    }

    public void setMerchantIDRef(long merchantIDRef) {
        this.merchantIDRef = merchantIDRef;
    }

    public String getLocalSignerReference() {
        return this.localSignerReference;
    }

    public void setLocalSignerReference(String localSignerReference) {
        this.localSignerReference = localSignerReference;
    }
}

