/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.trustsign.tsm.xml.util;

public final class Sort {
    private static final int CUTOFF = 10;

    public static void insertionSort(Comparable[] a) {
        for (int p = 1; p < a.length; ++p) {
            Comparable tmp = a[p];
            for (int j = p; j > 0 && tmp.compareTo(a[j - 1]) < 0; --j) {
                a[j] = a[j - 1];
            }
            a[j] = tmp;
        }
    }

    public static void shellsort(Comparable[] a) {
        int gap = a.length / 2;
        while (gap > 0) {
            for (int i = gap; i < a.length; ++i) {
                Comparable tmp = a[i];
                for (int j = i; j >= gap && tmp.compareTo(a[j - gap]) < 0; j -= gap) {
                    a[j] = a[j - gap];
                }
                a[j] = tmp;
            }
            gap = gap == 2 ? 1 : (int)((double)gap / 2.2);
        }
    }

    public static void heapsort(Comparable[] a) {
        int i;
        for (i = a.length / 2; i >= 0; --i) {
            Sort.percDown(a, i, a.length);
        }
        for (i = a.length - 1; i > 0; --i) {
            Sort.swapReferences(a, 0, i);
            Sort.percDown(a, 0, i);
        }
    }

    private static int leftChild(int i) {
        return 2 * i + 1;
    }

    private static void percDown(Comparable[] a, int i, int n) {
        Comparable tmp = a[i];
        while (Sort.leftChild(i) < n) {
            int child = Sort.leftChild(i);
            if (child != n - 1 && a[child].compareTo(a[child + 1]) < 0) {
                ++child;
            }
            if (tmp.compareTo(a[child]) >= 0) break;
            a[i] = a[child];
            i = child;
        }
        a[i] = tmp;
    }

    public static void mergeSort(Comparable[] a) {
        Comparable[] tmpArray = new Comparable[a.length];
        Sort.mergeSort(a, tmpArray, 0, a.length - 1);
    }

    private static void mergeSort(Comparable[] a, Comparable[] tmpArray, int left, int right) {
        if (left < right) {
            int center = (left + right) / 2;
            Sort.mergeSort(a, tmpArray, left, center);
            Sort.mergeSort(a, tmpArray, center + 1, right);
            Sort.merge(a, tmpArray, left, center + 1, right);
        }
    }

    private static void merge(Comparable[] a, Comparable[] tmpArray, int leftPos, int rightPos, int rightEnd) {
        int leftEnd = rightPos - 1;
        int tmpPos = leftPos;
        int numElements = rightEnd - leftPos + 1;
        while (leftPos <= leftEnd && rightPos <= rightEnd) {
            if (a[leftPos].compareTo(a[rightPos]) <= 0) {
                tmpArray[tmpPos++] = a[leftPos++];
                continue;
            }
            tmpArray[tmpPos++] = a[rightPos++];
        }
        while (leftPos <= leftEnd) {
            tmpArray[tmpPos++] = a[leftPos++];
        }
        while (rightPos <= rightEnd) {
            tmpArray[tmpPos++] = a[rightPos++];
        }
        int i = 0;
        while (i < numElements) {
            a[rightEnd] = tmpArray[rightEnd];
            ++i;
            --rightEnd;
        }
    }

    public static void quicksort(Comparable[] a) {
        Sort.quicksort(a, 0, a.length - 1);
    }

    public static final void swapReferences(Object[] a, int index1, int index2) {
        Object tmp = a[index1];
        a[index1] = a[index2];
        a[index2] = tmp;
    }

    private static void quicksort(Comparable[] a, int low, int high) {
        if (low + 10 > high) {
            Sort.insertionSort(a, low, high);
        } else {
            int middle = (low + high) / 2;
            if (a[middle].compareTo(a[low]) < 0) {
                Sort.swapReferences(a, low, middle);
            }
            if (a[high].compareTo(a[low]) < 0) {
                Sort.swapReferences(a, low, high);
            }
            if (a[high].compareTo(a[middle]) < 0) {
                Sort.swapReferences(a, middle, high);
            }
            Sort.swapReferences(a, middle, high - 1);
            Comparable pivot = a[high - 1];
            int i = low;
            int j = high - 1;
            while (true) {
                if (a[++i].compareTo(pivot) < 0) {
                    continue;
                }
                while (pivot.compareTo(a[--j]) < 0) {
                }
                if (i >= j) break;
                Sort.swapReferences(a, i, j);
            }
            Sort.swapReferences(a, i, high - 1);
            Sort.quicksort(a, low, i - 1);
            Sort.quicksort(a, i + 1, high);
        }
    }

    private static void insertionSort(Comparable[] a, int low, int high) {
        for (int p = low + 1; p <= high; ++p) {
            Comparable tmp = a[p];
            for (int j = p; j > low && tmp.compareTo(a[j - 1]) < 0; --j) {
                a[j] = a[j - 1];
            }
            a[j] = tmp;
        }
    }

    public static void quickSelect(Comparable[] a, int k) {
        Sort.quickSelect(a, 0, a.length - 1, k);
    }

    private static void quickSelect(Comparable[] a, int low, int high, int k) {
        if (low + 10 > high) {
            Sort.insertionSort(a, low, high);
        } else {
            int middle = (low + high) / 2;
            if (a[middle].compareTo(a[low]) < 0) {
                Sort.swapReferences(a, low, middle);
            }
            if (a[high].compareTo(a[low]) < 0) {
                Sort.swapReferences(a, low, high);
            }
            if (a[high].compareTo(a[middle]) < 0) {
                Sort.swapReferences(a, middle, high);
            }
            Sort.swapReferences(a, middle, high - 1);
            Comparable pivot = a[high - 1];
            int i = low;
            int j = high - 1;
            while (true) {
                if (a[++i].compareTo(pivot) < 0) {
                    continue;
                }
                while (pivot.compareTo(a[--j]) < 0) {
                }
                if (i >= j) break;
                Sort.swapReferences(a, i, j);
            }
            Sort.swapReferences(a, i, high - 1);
            if (k <= i) {
                Sort.quickSelect(a, low, i - 1, k);
            } else if (k > i + 1) {
                Sort.quickSelect(a, i + 1, high, k);
            }
        }
    }
}

