package eu.nets.sis.esign.demoapp;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DemoAppProperties {
	
	private static final Logger LOGGER = LogManager.getLogger(DemoAppProperties.class);
	
	public static String clientTrustStore;
	public static String clientTrustStorePwd;
	public static String merchantId;
	public static String description;
	public static String additionalInfo;
	public static String enduserSigner;
	public static String title;
	public static String merchantName;
	public static String signUrlBase;
	public static String pdfBase64String;
	public static String txtBase64String;
	public static String styleUrl;
	public static int port;
	public static String baseUrl;
	public static String contextPath;

	static {
		try (InputStream input = DemoAppProperties.class.getClassLoader().getResourceAsStream("application.properties")) {
			Properties prop = new Properties();
            prop.load(input);
            clientTrustStore = prop.getProperty("clienttruststore");
            clientTrustStorePwd = prop.getProperty("clienttruststorepwd");
            merchantId = prop.getProperty("merchantid");
            merchantName = prop.getProperty("merchantname");
            pdfBase64String = prop.getProperty("pdf.doc.bytes");
            txtBase64String = prop.getProperty("text.doc.bytes");
            description = prop.getProperty("document.description");
            title = prop.getProperty("title");
            additionalInfo = prop.getProperty("additionalinfo");
            enduserSigner = prop.getProperty("endusersigner");
            baseUrl = prop.getProperty("base.url");
            styleUrl = prop.getProperty("styleurl");
            port = Integer.parseInt(prop.getProperty("port"));
            signUrlBase = prop.getProperty("signurlbase");
            contextPath = prop.getProperty("context.path");
			
		} catch (IOException e) {
            System.out.println("\n\n<<<<<<<<<<ERROR>>>>>>>>>>\n\nE-Signn Demo App properties loading has failed.\n\nErrorMessage=" + e.getMessage() + ".\n\n");
            LOGGER.error("E-Sign Demo App properties loading has failed", e);
            System.exit(0);
        }
	}
}
