<!DOCTYPE html>
<html lang="en">
<head>
	<title>E-Sign developer pages</title>
	<meta charset="UTF-8">
	<meta name="viewport" content="user-scalable=yes, initial-scale=1.0, width=device-width">
	<link rel="SHORTCUT ICON" href="/images/in-groupe-favicon.png">
	<link rel="stylesheet" type="text/css" href="/css/global.css">
	<script type="text/javascript" src="/js/demo.js"></script>
</head>
<body>
	<#include "header.ftl">
	
	<div class="wrapper">
		<h1>IN Groupe E-Signing Demo App</h1>
		
		<p class="paragraphs">
			<span>E-Signing is a complete signing solution which gives customers the ability to get documents digitally signed by their users.</span>
			<span>All commonly used eIDs in the Nordics are supported.
				<a class="link" href="https://doc.ingroupe.com/developer/eids-for-e-signing" target="_blank">
					Read more for the complete overview of supported eIDs
					<img class="new-tab-icon" src="/images/open-new-tab.svg" alt="New tab icon">
				</a>
			</span>
			<span>E-Signing is hosted at IN Groupe and offered to customers as a service. The service offers three different user experience options. Pop-up and Standalone UI are shown here.</span>
		</p>
		
		<div class="formdiv">
			<form id="esign_form" name="esign_form">
				<div class="radio_grp">
					<input type="radio" name="doctype" value="PDF" checked/><label> PDF</label>
					<input type="radio" name="doctype" value="TXT"/><label> TEXT</label>
				</div>
				
				<div class="button-holder">
					<button type="button" id="open-popup-button" class="button">Pop-up UI</button>
					<button type="button" id="open-standalone-button" class="button">Standalone UI</button>
				</div>
			</form>
		</div>
		
		<div class="otherpage">
			<p> <span class="othersources">Other resources:</span></p>
			<a class="link" href="https://doc.ingroupe.com/developer/" target="_blank">
				View developer site
				<img class="new-tab-icon" src="/images/open-new-tab.svg" alt="New tab icon">
			</a>
		</div>
	</div>
	
	<#include "footer.ftl">
</body>
</html>
