/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.trust.esignclientapi.p12;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.crypto.Cipher;
import no.bbs.trust.esignclientapi.p12.InvalidCertificateChainException;
import no.bbs.trust.esignclientapi.p12.KSException;
import no.bbs.trust.esignclientapi.util.BCCryptoLoader;

public class PKCS12Keystore {
    protected PrivateKey privateKey = null;
    protected X509Certificate[] certificateChain = null;
    protected X509Certificate leafCertificate = null;
    protected X509Certificate rootCertificate = null;
    protected KeyStore keyStore = null;

    public PKCS12Keystore(InputStream pkcs12, String pwd, boolean requiresWholeChain) throws KSException {
        BCCryptoLoader.registerBCProvider();
        this.loadKeystore(pkcs12, pwd, requiresWholeChain);
    }

    private void loadKeystore(InputStream pkcs12, String pwd, boolean requiresWholeChain) throws KSException {
        try {
            char[] pwdChars = new char[pwd.length()];
            pwd.getChars(0, pwd.length(), pwdChars, 0);
            this.keyStore = KeyStore.getInstance("PKCS12");
            this.keyStore.load(pkcs12, pwdChars);
            Enumeration<String> ksAliases = this.keyStore.aliases();
            String keyAlias = null;
            while (ksAliases.hasMoreElements()) {
                String currAlias = ksAliases.nextElement();
                if (!this.keyStore.isKeyEntry(currAlias)) continue;
                keyAlias = currAlias;
                this.privateKey = (PrivateKey)this.keyStore.getKey(currAlias, pwdChars);
                break;
            }
            if (null == this.privateKey) {
                throw new KSException("Unable to locate PrivateKey in KeyStore");
            }
            Certificate[] certChain = this.keyStore.getCertificateChain(keyAlias);
            if (null == certChain) {
                throw new KSException("Unable to locate CertificateChain in KeyStore");
            }
            this.certificateChain = this.convertToX509CertificateChain(certChain);
            this.linkChain("RSA", this.certificateChain, this.privateKey, requiresWholeChain);
            this.leafCertificate = this.certificateChain[0];
            if (null == this.leafCertificate) {
                throw new Exception("Failed to locate Signer certificate (leaf cert)");
            }
        }
        catch (Exception e) {
            throw new KSException("Failed to load keystore: " + e.getMessage());
        }
    }

    public KeyStore loadKeyStore(String provider, InputStream keyStoreStream, String storeType, char[] keyStorePassword) throws KSException {
        String sType = storeType;
        try {
            if (sType == null) {
                sType = "PKCS12";
            }
            KeyStore keyStore = sType.equals("JKS") ? KeyStore.getInstance(sType, "SUN") : (sType.equals("JCEKS") ? KeyStore.getInstance(sType, "SunJCE") : KeyStore.getInstance(sType, provider));
            if (keyStoreStream == null) {
                throw new KSException("Keystore must be specified.");
            }
            keyStore.load(keyStoreStream, keyStorePassword);
            return keyStore;
        }
        catch (KeyStoreException e) {
            throw new KSException("Problem loading keystore: " + e);
        }
        catch (NoSuchProviderException e) {
            throw new KSException("The specified provider is not available.");
        }
        catch (CertificateException ce) {
            throw new KSException("Could not open keystore: " + ce);
        }
        catch (IOException ioe) {
            throw new KSException("Could not export key: " + ioe);
        }
        catch (NoSuchAlgorithmException nse) {
            throw new KSException("Could not open keystore with the installed JCE providers: " + nse);
        }
    }

    protected boolean isMatchingKey(String algorithm, PublicKey pubKey, PrivateKey privKey) {
        try {
            String controlString = "asdf";
            Cipher cipher = Cipher.getInstance(algorithm);
            cipher.init(1, pubKey);
            byte[] encryptedData = cipher.doFinal(controlString.getBytes("UTF-8"));
            cipher.init(2, privKey);
            byte[] decryptedData = cipher.doFinal(encryptedData);
            if (controlString.equals(new String(decryptedData, "UTF-8"))) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public X509Certificate[] linkChain(String keyAlgorithm, X509Certificate[] untestedCerts, PrivateKey privKey, boolean requiresWholeChain) throws InvalidCertificateChainException {
        int i;
        ArrayList<X509Certificate> replyCerts = new ArrayList<X509Certificate>();
        for (i = 0; untestedCerts.length > i; ++i) {
            try {
                untestedCerts[i].checkValidity();
            }
            catch (Exception e) {
                throw new InvalidCertificateChainException("Invalid CertificateChain. The Certificate with SubjectDN [" + untestedCerts[i].getSubjectDN().getName() + "] is not valid: " + e.getMessage());
            }
            if (!this.isMatchingKey(keyAlgorithm, untestedCerts[i].getPublicKey(), privKey)) continue;
            replyCerts.add(untestedCerts[i]);
        }
        if (replyCerts.size() < 1) {
            throw new InvalidCertificateChainException("No certificate in chain that matches specified private key");
        }
        if (replyCerts.size() > 1) {
            throw new InvalidCertificateChainException("More than one certificate in chain that matches specified private key");
        }
        this.walkChain(untestedCerts, replyCerts, requiresWholeChain);
        for (i = 0; i < replyCerts.size() - 1; ++i) {
            PublicKey pubKey = replyCerts.get(i + 1).getPublicKey();
            try {
                replyCerts.get(i).verify(pubKey);
                continue;
            }
            catch (Exception e) {
                throw new InvalidCertificateChainException("Certificate chain cannot be verified: " + e.getMessage());
            }
        }
        return replyCerts.toArray(new X509Certificate[0]);
    }

    protected void walkChain(X509Certificate[] chainSource, ArrayList<X509Certificate> chainDest, boolean requiresWholeChain) throws InvalidCertificateChainException {
        X509Certificate currentCert = chainDest.get(chainDest.size() - 1);
        if (currentCert.getSubjectDN().equals(currentCert.getIssuerDN())) {
            this.rootCertificate = currentCert;
            return;
        }
        for (int i = 0; chainSource.length > i; ++i) {
            if (!currentCert.getIssuerDN().equals(chainSource[i].getSubjectDN())) continue;
            chainDest.add(chainSource[i]);
            this.walkChain(chainSource, chainDest, requiresWholeChain);
            return;
        }
        if (requiresWholeChain) {
            throw new InvalidCertificateChainException("Incomplete certificate chain.");
        }
    }

    protected X509Certificate[] convertToX509CertificateChain(Certificate[] certs) throws CertificateException {
        X509Certificate[] rcerts = new X509Certificate[certs.length];
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        for (int i = 0; i < certs.length; ++i) {
            X509Certificate c;
            rcerts[i] = c = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certs[i].getEncoded()));
        }
        return rcerts;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public X509Certificate getLeafCertificate() {
        if (null == this.certificateChain) {
            return null;
        }
        return this.leafCertificate;
    }

    public X509Certificate[] getCertificateChain() {
        return this.certificateChain;
    }

    public X509Certificate getRootCertificate() {
        return this.rootCertificate;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }
}

