/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.trustsign.tsm.xml.messages.containers;

import java.io.Serializable;
import java.util.ArrayList;
import no.bbs.tt.trustsign.tsm.xml.messages.containers.Index;
import no.bbs.tt.trustsign.tsm.xml.messages.containers.Metadata;
import no.bbs.tt.trustsign.tsm.xml.messages.containers.ObjectRef;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Archive
implements Serializable {
    private static final long serialVersionUID = -8028237572324827113L;
    private String archivename = null;
    private ObjectRef objectRef = null;
    private ArrayList<Index> indexes = null;
    private ArrayList<Metadata> metadataList = null;

    public Archive() {
    }

    public Archive(Element element) {
        NodeList metadataElems;
        int i;
        Element archiveDataElem;
        NodeList indexElems;
        NodeList nl = element.getElementsByTagName("ArchiveName");
        if (nl.getLength() > 0 && nl.item(0).getFirstChild() != null) {
            this.setArchivename(nl.item(0).getFirstChild().getNodeValue());
        }
        if (null != (nl = element.getElementsByTagName("ObjectRef")) && nl.getLength() > 0) {
            Element childElem = (Element)nl.item(0);
            this.setObjectRef(new ObjectRef(childElem));
        }
        if (null != (nl = element.getElementsByTagName("ArchiveData")) && nl.getLength() > 0 && null != (indexElems = (archiveDataElem = (Element)nl.item(0)).getElementsByTagName("Index")) && indexElems.getLength() > 0) {
            this.indexes = new ArrayList();
            for (i = 0; i < indexElems.getLength(); ++i) {
                this.indexes.add(new Index((Element)indexElems.item(i)));
            }
        }
        if (null != (nl = element.getElementsByTagName("MetaDataList")) && nl.getLength() > 0 && null != (metadataElems = (archiveDataElem = (Element)nl.item(0)).getElementsByTagName("MetaData")) && metadataElems.getLength() > 0) {
            this.metadataList = new ArrayList();
            for (i = 0; i < metadataElems.getLength(); ++i) {
                this.metadataList.add(new Metadata((Element)metadataElems.item(i)));
            }
        }
    }

    public Element toXML(Document doc) {
        Serializable item;
        int i;
        Element root = doc.createElement("Archive");
        Element childElement = null;
        if (this.getArchivename() != null) {
            childElement = doc.createElement("ArchiveName");
            childElement.appendChild(doc.createTextNode(this.getArchivename()));
            root.appendChild(childElement);
        }
        if (null != this.getObjectRef()) {
            root.appendChild(this.getObjectRef().toXML(doc));
        }
        if (null != this.indexes && !this.indexes.isEmpty()) {
            Element achiveDataElem = doc.createElement("ArchiveData");
            for (i = 0; i < this.indexes.size(); ++i) {
                item = this.indexes.get(i);
                achiveDataElem.appendChild(((Index)item).toXML(doc));
            }
            root.appendChild(achiveDataElem);
        }
        if (null != this.metadataList && !this.metadataList.isEmpty()) {
            Element metadataElem = doc.createElement("MetaDataList");
            for (i = 0; i < this.metadataList.size(); ++i) {
                item = this.metadataList.get(i);
                metadataElem.appendChild(((Metadata)item).toXML(doc));
            }
            root.appendChild(metadataElem);
        }
        doc.getFirstChild().appendChild(root);
        return root;
    }

    public String getArchivename() {
        return this.archivename;
    }

    public void setArchivename(String string) {
        this.archivename = string;
    }

    public ArrayList<Index> getIndexes() {
        return this.indexes;
    }

    public void setIndexes(ArrayList<Index> list) {
        this.indexes = list;
    }

    public void addIndex(String key, String value) {
        if (null == this.indexes) {
            this.indexes = new ArrayList();
        }
        if (null != key && null != value) {
            this.indexes.add(new Index(key, value));
        }
    }

    public void addIndex(Index i) {
        if (null == this.indexes) {
            this.indexes = new ArrayList();
        }
        if (null != i) {
            this.indexes.add(i);
        }
    }

    public ArrayList<Metadata> getMetadataList() {
        return this.metadataList;
    }

    public void setMetadataList(ArrayList<Metadata> metadataList) {
        this.metadataList = metadataList;
    }

    public void addMetadata(Metadata i) {
        if (null == this.metadataList) {
            this.metadataList = new ArrayList();
        }
        if (null != i) {
            this.metadataList.add(i);
        }
    }

    public void addMetadata(String key, String value) {
        if (null == this.metadataList) {
            this.metadataList = new ArrayList();
        }
        if (null != key && null != value) {
            this.metadataList.add(new Metadata(key, value));
        }
    }

    public ObjectRef getObjectRef() {
        return this.objectRef;
    }

    public void setObjectRef(ObjectRef objectRef) {
        this.objectRef = objectRef;
    }
}

