/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.trustsign.tsm.xml.messages.containers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import no.bbs.tt.trustsign.tsm.xml.messages.containers.StepDetails;
import no.bbs.tt.trustsign.tsm.xml.statics.DisplayProcessInfo;
import no.bbs.tt.trustsign.tsm.xml.util.DateUtility;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SODExecutionDetails
implements Serializable {
    private static final long serialVersionUID = 6754956239595344302L;
    private Date orderDeadline = null;
    private String displayProcessInfo = DisplayProcessInfo.NO;
    private boolean generateOneTimeURLs = false;
    private ArrayList<StepDetails> stepDetails = null;
    private String outputFormat = null;

    public SODExecutionDetails() {
    }

    public SODExecutionDetails(Element element) {
        Element stepsELem;
        NodeList stepElements;
        String generateOTU;
        NodeList nl = element.getElementsByTagName("OrderDeadline");
        if (nl.getLength() > 0 && nl.item(0).getFirstChild() != null) {
            this.setOrderDeadline(DateUtility.XMLToDate(nl.item(0).getFirstChild().getNodeValue()));
        }
        if ((nl = element.getElementsByTagName("DisplayProcessInfo")).getLength() > 0 && nl.item(0).getFirstChild() != null) {
            this.setDisplayProcessInfo(nl.item(0).getFirstChild().getNodeValue());
        }
        if ((nl = element.getElementsByTagName("GenerateOneTimeURLs")).getLength() > 0 && nl.item(0).getFirstChild() != null && "true".equalsIgnoreCase(generateOTU = nl.item(0).getFirstChild().getNodeValue())) {
            this.setGenerateOneTimeURLs(true);
        }
        if ((nl = element.getElementsByTagName("Steps")).getLength() > 0 && (stepElements = (stepsELem = (Element)nl.item(0)).getElementsByTagName("StepDetails")).getLength() > 0) {
            this.stepDetails = new ArrayList();
            for (int i = 0; i < stepElements.getLength(); ++i) {
                Element currStep = (Element)stepElements.item(i);
                this.stepDetails.add(new StepDetails(currStep));
            }
        }
        if ((nl = element.getElementsByTagName("OutputFormat")).getLength() > 0 && nl.item(0).getFirstChild() != null) {
            this.setOutputFormat(nl.item(0).getFirstChild().getNodeValue());
        }
    }

    public Element toXML(Document doc) {
        Element childElement;
        Element root = doc.createElement("ExecutionDetails");
        if (null != this.getOrderDeadline()) {
            childElement = doc.createElement("OrderDeadline");
            childElement.appendChild(doc.createTextNode(DateUtility.DateToXML(this.getOrderDeadline())));
            root.appendChild(childElement);
        }
        if (null != this.getDisplayProcessInfo()) {
            childElement = doc.createElement("DisplayProcessInfo");
            childElement.appendChild(doc.createTextNode(this.getDisplayProcessInfo()));
            root.appendChild(childElement);
        }
        if (this.generateOneTimeURLs()) {
            Element gotuElement = doc.createElement("GenerateOneTimeURLs");
            gotuElement.appendChild(doc.createTextNode("true"));
            root.appendChild(gotuElement);
        }
        if (null != this.getStepDetails() && !this.getStepDetails().isEmpty()) {
            Element stepsElement = doc.createElement("Steps");
            for (int i = 0; i < this.getStepDetails().size(); ++i) {
                StepDetails curStep = this.getStepDetails().get(i);
                stepsElement.appendChild(curStep.toXML(doc));
            }
            root.appendChild(stepsElement);
        }
        if (null != this.getOutputFormat()) {
            Element outputFormatElement = doc.createElement("OutputFormat");
            outputFormatElement.appendChild(doc.createTextNode(this.getOutputFormat()));
            root.appendChild(outputFormatElement);
        }
        doc.getFirstChild().appendChild(root);
        return root;
    }

    public Date getOrderDeadline() {
        return this.orderDeadline;
    }

    public void setOrderDeadline(Date orderDeadline) {
        this.orderDeadline = orderDeadline;
    }

    public String getDisplayProcessInfo() {
        return this.displayProcessInfo;
    }

    public void setDisplayProcessInfo(String displayProcessInfo) {
        this.displayProcessInfo = displayProcessInfo;
    }

    public boolean generateOneTimeURLs() {
        return this.generateOneTimeURLs;
    }

    public void setGenerateOneTimeURLs(boolean generateOneTimeURLs) {
        this.generateOneTimeURLs = generateOneTimeURLs;
    }

    public ArrayList<StepDetails> getStepDetails() {
        return this.stepDetails;
    }

    public void setStepDetails(ArrayList<StepDetails> steps) {
        this.stepDetails = steps;
    }

    public void addStepDetails(StepDetails s) {
        if (null == this.stepDetails) {
            this.stepDetails = new ArrayList();
        }
        this.stepDetails.add(s);
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }
}

