/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.jce.PrincipalUtil;
import org.bouncycastle.mail.smime.SMIMEException;
import org.bouncycastle.mail.smime.util.CRLFOutputStream;
import org.bouncycastle.mail.smime.util.FileBackedMimeBodyPart;

public class SMIMEUtil {
    private static final int BUF_SIZE = 32760;

    static boolean isCanonicalisationRequired(MimeBodyPart mimeBodyPart, String string) throws MessagingException {
        String[] stringArray = mimeBodyPart.getHeader("Content-Transfer-Encoding");
        String string2 = stringArray == null ? string : stringArray[0];
        return !string2.equalsIgnoreCase("binary");
    }

    static void outputPreamble(LineOutputStream lineOutputStream, MimeBodyPart mimeBodyPart, String string) throws MessagingException, IOException {
        String string2;
        InputStream inputStream;
        try {
            inputStream = mimeBodyPart.getRawInputStream();
        }
        catch (MessagingException messagingException) {
            return;
        }
        while ((string2 = SMIMEUtil.readLine(inputStream)) != null && !string2.equals(string)) {
            lineOutputStream.writeln(string2);
        }
        inputStream.close();
        if (string2 == null) {
            throw new MessagingException("no boundary found");
        }
    }

    private static String readLine(InputStream inputStream) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = inputStream.read()) >= 0 && n != 10) {
            if (n == 13) continue;
            stringBuffer.append((char)n);
        }
        if (n < 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    static void outputBodyPart(OutputStream outputStream, BodyPart bodyPart, String string) throws MessagingException, IOException {
        if (bodyPart instanceof MimeBodyPart) {
            int n;
            Object object;
            MimeBodyPart mimeBodyPart = (MimeBodyPart)bodyPart;
            String[] stringArray = mimeBodyPart.getHeader("Content-Transfer-Encoding");
            if (mimeBodyPart.getContent() instanceof MimeMultipart) {
                MimeMultipart mimeMultipart = (MimeMultipart)bodyPart.getContent();
                ContentType contentType = new ContentType(mimeMultipart.getContentType());
                String string2 = "--" + contentType.getParameter("boundary");
                LineOutputStream lineOutputStream = new LineOutputStream(outputStream);
                Enumeration enumeration = mimeBodyPart.getAllHeaderLines();
                while (enumeration.hasMoreElements()) {
                    String string3 = (String)enumeration.nextElement();
                    lineOutputStream.writeln(string3);
                }
                lineOutputStream.writeln();
                SMIMEUtil.outputPreamble(lineOutputStream, mimeBodyPart, string2);
                for (int i = 0; i < mimeMultipart.getCount(); ++i) {
                    lineOutputStream.writeln(string2);
                    BodyPart bodyPart2 = mimeMultipart.getBodyPart(i);
                    SMIMEUtil.outputBodyPart(outputStream, bodyPart2, string);
                    if (bodyPart2.getContent() instanceof MimeMultipart) continue;
                    lineOutputStream.writeln();
                }
                lineOutputStream.writeln(string2 + "--");
                return;
            }
            String string4 = stringArray == null ? string : stringArray[0];
            if (!string4.equalsIgnoreCase("base64") && !string4.equalsIgnoreCase("quoted-printable")) {
                if (!string4.equalsIgnoreCase("binary")) {
                    outputStream = new CRLFOutputStream(outputStream);
                }
                bodyPart.writeTo(outputStream);
                outputStream.flush();
                return;
            }
            LineOutputStream lineOutputStream = new LineOutputStream(outputStream);
            Object object2 = mimeBodyPart.getAllHeaderLines();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                lineOutputStream.writeln((String)object);
            }
            lineOutputStream.writeln();
            lineOutputStream.flush();
            object2 = mimeBodyPart.getRawInputStream();
            object = new CRLFOutputStream(outputStream);
            byte[] byArray = new byte[32760];
            while ((n = ((InputStream)object2).read(byArray, 0, byArray.length)) > 0) {
                ((CRLFOutputStream)object).write(byArray, 0, n);
            }
            ((FilterOutputStream)object).flush();
        } else {
            if (!string.equalsIgnoreCase("binary")) {
                outputStream = new CRLFOutputStream(outputStream);
            }
            bodyPart.writeTo(outputStream);
            outputStream.flush();
        }
    }

    public static MimeBodyPart toMimeBodyPart(byte[] byArray) throws SMIMEException {
        return SMIMEUtil.toMimeBodyPart(new ByteArrayInputStream(byArray));
    }

    public static MimeBodyPart toMimeBodyPart(InputStream inputStream) throws SMIMEException {
        try {
            return new MimeBodyPart(inputStream);
        }
        catch (MessagingException messagingException) {
            throw new SMIMEException("exception creating body part.", (Exception)((Object)messagingException));
        }
    }

    static FileBackedMimeBodyPart toWriteOnceBodyPart(CMSTypedStream cMSTypedStream) throws SMIMEException {
        try {
            return new WriteOnceFileBackedMimeBodyPart(cMSTypedStream.getContentStream(), File.createTempFile("bcMail", ".mime"));
        }
        catch (IOException iOException) {
            throw new SMIMEException("IOException creating tmp file:" + iOException.getMessage(), iOException);
        }
        catch (MessagingException messagingException) {
            throw new SMIMEException("can't create part: " + (Object)((Object)messagingException), (Exception)((Object)messagingException));
        }
    }

    public static FileBackedMimeBodyPart toMimeBodyPart(CMSTypedStream cMSTypedStream) throws SMIMEException {
        try {
            return SMIMEUtil.toMimeBodyPart(cMSTypedStream, File.createTempFile("bcMail", ".mime"));
        }
        catch (IOException iOException) {
            throw new SMIMEException("IOException creating tmp file:" + iOException.getMessage(), iOException);
        }
    }

    public static FileBackedMimeBodyPart toMimeBodyPart(CMSTypedStream cMSTypedStream, File file) throws SMIMEException {
        try {
            return new FileBackedMimeBodyPart(cMSTypedStream.getContentStream(), file);
        }
        catch (IOException iOException) {
            throw new SMIMEException("can't save content to file: " + iOException, iOException);
        }
        catch (MessagingException messagingException) {
            throw new SMIMEException("can't create part: " + (Object)((Object)messagingException), (Exception)((Object)messagingException));
        }
    }

    public static IssuerAndSerialNumber createIssuerAndSerialNumberFor(X509Certificate x509Certificate) throws CertificateParsingException {
        try {
            return new IssuerAndSerialNumber((X509Name)PrincipalUtil.getIssuerX509Principal((X509Certificate)x509Certificate), x509Certificate.getSerialNumber());
        }
        catch (Exception exception) {
            throw new CertificateParsingException("exception extracting issuer and serial number: " + exception);
        }
    }

    private static class WriteOnceFileBackedMimeBodyPart
    extends FileBackedMimeBodyPart {
        public WriteOnceFileBackedMimeBodyPart(InputStream inputStream, File file) throws MessagingException, IOException {
            super(inputStream, file);
        }

        @Override
        public void writeTo(OutputStream outputStream) throws MessagingException, IOException {
            super.writeTo(outputStream);
            this.dispose();
        }
    }

    static class LineOutputStream
    extends FilterOutputStream {
        private static byte[] newline = new byte[2];

        public LineOutputStream(OutputStream outputStream) {
            super(outputStream);
        }

        public void writeln(String string) throws MessagingException {
            try {
                byte[] byArray = LineOutputStream.getBytes(string);
                this.out.write(byArray);
                this.out.write(newline);
            }
            catch (Exception exception) {
                throw new MessagingException("IOException", exception);
            }
        }

        public void writeln() throws MessagingException {
            try {
                this.out.write(newline);
            }
            catch (Exception exception) {
                throw new MessagingException("IOException", exception);
            }
        }

        private static byte[] getBytes(String string) {
            char[] cArray = string.toCharArray();
            int n = cArray.length;
            byte[] byArray = new byte[n];
            int n2 = 0;
            while (n2 < n) {
                byArray[n2] = (byte)cArray[n2++];
            }
            return byArray;
        }

        static {
            LineOutputStream.newline[0] = 13;
            LineOutputStream.newline[1] = 10;
        }
    }
}

