/*
 * Decompiled with CFR 0.152.
 */
package eu.nets.sis.idrights.clientapi.p12;

import eu.nets.sis.idrights.clientapi.p12.ISingleKeystore;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class PKCS12Keystore
implements ISingleKeystore {
    private KeyStore ks;
    private PrivateKey key;
    private X509Certificate[] chain;
    private String alias;
    private String filepath = null;
    private String filename = null;

    public PKCS12Keystore() {
    }

    public PKCS12Keystore(String path, char[] pwd) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, UnrecoverableKeyException, IOException {
        this.ks = KeyStore.getInstance("pkcs12");
        this.ks.load(new FileInputStream(path), pwd);
        this.alias = this.ks.aliases().nextElement();
        this.key = (PrivateKey)this.ks.getKey(this.alias, pwd);
        this.chain = PKCS12Keystore.convertToX509Chain(this.ks.getCertificateChain(this.alias));
        this.filepath = path;
    }

    public PKCS12Keystore(InputStream file, char[] pwd) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, UnrecoverableKeyException, IOException {
        this.ks = KeyStore.getInstance("pkcs12");
        this.ks.load(file, pwd);
        this.alias = this.ks.aliases().nextElement();
        this.key = (PrivateKey)this.ks.getKey(this.alias, pwd);
        this.chain = PKCS12Keystore.convertToX509Chain(this.ks.getCertificateChain(this.alias));
    }

    public String getTokenType() {
        return "PKCS#12File";
    }

    @Override
    public String getName() {
        return this.alias;
    }

    @Override
    public PrivateKey getPrivateKey() {
        return this.key;
    }

    @Override
    public X509Certificate getLeafCertificate() {
        return this.chain[0];
    }

    @Override
    public X509Certificate[] getCertificateChain() {
        return this.chain;
    }

    public static final X509Certificate[] convertToX509Chain(Certificate[] certs) throws CertificateException {
        X509Certificate[] rcerts = new X509Certificate[certs.length];
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        for (int y = 0; y < certs.length; ++y) {
            X509Certificate c;
            rcerts[y] = c = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certs[y].getEncoded()));
        }
        return rcerts;
    }

    public String getFileName() {
        return this.filename;
    }

    public void setFileName(String fileName) {
        this.filename = fileName;
    }

    public String getFilepath() {
        return this.filepath;
    }

    public void setFilepath(String filepath) {
        this.filepath = filepath;
    }
}

