/*
 * Decompiled with CFR 0.152.
 */
package eu.nets.sis.idrights.clientapi.sign;

import eu.nets.sis.idrights.clientapi.p12.ISingleKeystore;
import eu.nets.sis.idrights.clientapi.util.SecureDocumentBuilderFactory;
import eu.nets.sis.idrights.clientapi.util.String2Document;
import java.io.ByteArrayOutputStream;
import java.security.cert.X509Certificate;
import java.util.Collections;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XMLSigner {
    private XMLSignatureFactory fac = null;
    private KeyInfoFactory kif = null;
    private KeyInfo ki;
    private Reference ref;
    private ISingleKeystore sks = null;

    public XMLSigner(ISingleKeystore sks) throws Exception {
        if (null == sks.getPrivateKey()) {
            throw new Exception("Signer [" + sks + "] must expose the private key.");
        }
        this.sks = sks;
        this.fac = XMLSignatureFactory.getInstance("DOM");
        this.kif = this.fac.getKeyInfoFactory();
    }

    public X509Certificate getSignerCertificate() {
        return this.sks.getLeafCertificate();
    }

    public String signXML(String xmlAsString) throws Exception {
        try {
            X509Certificate cert = this.getSignerCertificate();
            X509Data x5 = this.kif.newX509Data(Collections.nCopies(1, cert));
            this.ki = this.kif.newKeyInfo(Collections.nCopies(1, x5));
            this.ref = this.fac.newReference("#object", this.fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null));
            DocumentBuilderFactory dbf = SecureDocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            Document doc = null;
            String2Document s2d = new String2Document();
            try {
                doc = s2d.createDocumentFromString(xmlAsString);
            }
            catch (Exception e) {
                throw new Exception("signXML failed. Could not create an XML Document from input signature bytes", e);
            }
            if (null == doc.getDocumentElement()) {
                throw new Exception("signXML. Input XML Document is empty.");
            }
            DOMStructure content = new DOMStructure(doc.getFirstChild());
            return this.signXML(content);
        }
        catch (Throwable t) {
            throw new Exception(t.getMessage());
        }
    }

    public String signXML(XMLStructure content) throws Exception {
        XMLObject obj = this.fac.newXMLObject(Collections.nCopies(1, content), "object", null, null);
        SignedInfo si = this.fac.newSignedInfo(this.fac.newCanonicalizationMethod("http://www.w3.org/2001/10/xml-exc-c14n#", (C14NMethodParameterSpec)null), this.fac.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null), Collections.nCopies(1, this.ref));
        XMLSignature signature = this.fac.newXMLSignature(si, this.ki, Collections.nCopies(1, obj), null, null);
        DocumentBuilderFactory dbf = SecureDocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        Document doc = dbf.newDocumentBuilder().newDocument();
        DOMSignContext dsc = new DOMSignContext(this.sks.getPrivateKey(), (Node)doc);
        signature.sign(dsc);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer trans = tf.newTransformer();
        trans.transform(new DOMSource(doc), new StreamResult(os));
        os.flush();
        String res = new String(os.toByteArray(), "UTF-8");
        os.close();
        return res;
    }
}

