/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.trust.common.basics.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;

public class RequestReader {
    public static byte[] readRequestBytes(InputStream in) throws IOException {
        byte[] responseBytes;
        LinkedList<Pair> bufferList = new LinkedList<Pair>();
        byte[] readBytes = new byte[in.available()];
        int avail = in.read(readBytes);
        while (avail > -1) {
            bufferList.add(new Pair(readBytes, avail));
            readBytes = new byte[Math.max(1024, in.available())];
            avail = in.read(readBytes);
        }
        if (bufferList.size() == 1) {
            responseBytes = ((Pair)bufferList.getFirst()).buffer;
        } else {
            int size = 0;
            for (Pair p : bufferList) {
                size += p.bufSize;
            }
            responseBytes = new byte[size];
            int append = 0;
            for (Pair p : bufferList) {
                System.arraycopy(p.buffer, 0, responseBytes, append, p.bufSize);
                append += p.bufSize;
            }
        }
        return responseBytes;
    }

    private static String readRequest(InputStream in, String encoding) throws IOException {
        byte[] responseBytes = RequestReader.readRequestBytes(in);
        return new String(responseBytes, encoding);
    }

    public static String readRequest(InputStream in) throws IOException {
        return RequestReader.readRequest(in, "UTF-8");
    }

    private static final class Pair {
        public final byte[] buffer;
        public final int bufSize;

        Pair(byte[] ll, int size) {
            this.buffer = ll;
            this.bufSize = size;
        }
    }
}

