/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.trust.common.basics.utils;

import java.util.StringTokenizer;

public final class StringUtils {
    private StringUtils() {
    }

    public static String replace(String source, String search, String replace) {
        if (null == source) {
            return "";
        }
        if (null != search && search.length() > 0 && null != replace) {
            int start = source.indexOf(search);
            if (start == -1) {
                return source;
            }
            int lf = search.length();
            char[] targetChars = source.toCharArray();
            StringBuilder buffer = new StringBuilder();
            int copyFrom = 0;
            while (start != -1) {
                buffer.append(targetChars, copyFrom, start - copyFrom);
                buffer.append(replace);
                copyFrom = start + lf;
                start = source.indexOf(search, copyFrom);
            }
            buffer.append(targetChars, copyFrom, targetChars.length - copyFrom);
            return buffer.toString();
        }
        return source;
    }

    public static String stripWhitespaces(String i) {
        if (i != null) {
            StringTokenizer st = new StringTokenizer(i, "\r\n\t ", false);
            StringBuilder sb = new StringBuilder();
            while (st.hasMoreTokens()) {
                sb.append(st.nextToken().trim());
            }
            return sb.toString();
        }
        return "";
    }

    public static boolean isNull(String string) {
        return null == string;
    }

    public static boolean isNullorEmpty(String string) {
        if (null == string) {
            return true;
        }
        return string.trim().length() == 0;
    }

    public static long toLong(String string, long defaultLong) {
        if (!StringUtils.isNullorEmpty(string)) {
            try {
                return Long.parseLong(string);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return defaultLong;
    }
}

