/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.trust.common.basics.utils;

import java.io.UnsupportedEncodingException;

public final class UrlUtil {
    static final String digits = "0123456789ABCDEF";

    public static final String appendQueryDelimiter(String url) {
        if (null == url) {
            url = "";
        }
        url = url.indexOf("?") > 0 ? url + "&" : url + "?";
        return url;
    }

    public static String encode(String string, String encoding) throws UnsupportedEncodingException {
        if (null == string || null == encoding) {
            throw new NullPointerException();
        }
        "".getBytes(encoding);
        StringBuffer sb = new StringBuffer(string.length() + 16);
        int start = -1;
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || " .-*_".indexOf(ch) > -1) {
                if (start >= 0) {
                    UrlUtil.convert(string.substring(start, i), sb, encoding);
                    start = -1;
                }
                if (ch != ' ') {
                    sb.append(ch);
                    continue;
                }
                sb.append('+');
                continue;
            }
            if (start >= 0) continue;
            start = i;
        }
        if (start >= 0) {
            UrlUtil.convert(string.substring(start, string.length()), sb, encoding);
        }
        return sb.toString();
    }

    private static void convert(String string, StringBuffer sb, String encoding) throws UnsupportedEncodingException {
        byte[] bytes = string.getBytes(encoding);
        for (int j = 0; j < bytes.length; ++j) {
            sb.append('%');
            sb.append(digits.charAt((bytes[j] & 0xF0) >> 4));
            sb.append(digits.charAt(bytes[j] & 0xF));
        }
    }

    private UrlUtil() {
    }
}

