/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.bouncycastle.asn1.cms.EnvelopedData;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSEnvelopedGenerator;
import org.bouncycastle.cms.CMSEnvelopedHelper;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;

public class CMSEnvelopedDataGenerator
extends CMSEnvelopedGenerator {
    public CMSEnvelopedDataGenerator() {
    }

    public CMSEnvelopedDataGenerator(SecureRandom secureRandom) {
        super(secureRandom);
    }

    private CMSEnvelopedData generate(CMSProcessable cMSProcessable, String string, KeyGenerator keyGenerator, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        BERConstructedOctetString bERConstructedOctetString;
        Object object;
        AlgorithmIdentifier algorithmIdentifier;
        Object object22;
        SecretKey secretKey;
        String string3 = keyGenerator.getProvider().getName();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        try {
            Cipher cipher = CMSEnvelopedHelper.INSTANCE.getSymmetricCipher(string, string3);
            secretKey = keyGenerator.generateKey();
            object22 = this.generateParameters(string, secretKey, string3);
            cipher.init(1, (Key)secretKey, (AlgorithmParameters)object22, this.rand);
            if (object22 == null) {
                object22 = cipher.getParameters();
            }
            algorithmIdentifier = this.getAlgorithmIdentifier(string, (AlgorithmParameters)object22);
            object = new ByteArrayOutputStream();
            CipherOutputStream cipherOutputStream = new CipherOutputStream((OutputStream)object, cipher);
            cMSProcessable.write(cipherOutputStream);
            cipherOutputStream.close();
            bERConstructedOctetString = new BERConstructedOctetString(((ByteArrayOutputStream)object).toByteArray());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("key invalid in message.", invalidKeyException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new CMSException("required padding not supported.", noSuchPaddingException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new CMSException("algorithm parameters invalid.", invalidAlgorithmParameterException);
        }
        catch (IOException iOException) {
            throw new CMSException("exception decoding algorithm parameters.", iOException);
        }
        for (Object object22 : this.recipientInfs) {
            try {
                aSN1EncodableVector.add(((CMSEnvelopedGenerator.RecipientInf)object22).toRecipientInfo(secretKey, this.rand, string2));
            }
            catch (IOException iOException) {
                throw new CMSException("encoding error.", iOException);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new CMSException("key inappropriate for algorithm.", invalidKeyException);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new CMSException("error making encrypted content.", generalSecurityException);
            }
        }
        object22 = new EncryptedContentInfo(PKCSObjectIdentifiers.data, algorithmIdentifier, bERConstructedOctetString);
        object = new ContentInfo(PKCSObjectIdentifiers.envelopedData, new EnvelopedData(null, new DERSet(aSN1EncodableVector), (EncryptedContentInfo)object22, null));
        return new CMSEnvelopedData((ContentInfo)object);
    }

    public CMSEnvelopedData generate(CMSProcessable cMSProcessable, String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        KeyGenerator keyGenerator = CMSEnvelopedHelper.INSTANCE.createSymmetricKeyGenerator(string, string2);
        keyGenerator.init(this.rand);
        return this.generate(cMSProcessable, string, keyGenerator, string2);
    }

    public CMSEnvelopedData generate(CMSProcessable cMSProcessable, String string, int n, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        KeyGenerator keyGenerator = CMSEnvelopedHelper.INSTANCE.createSymmetricKeyGenerator(string, string2);
        keyGenerator.init(n, this.rand);
        return this.generate(cMSProcessable, string, keyGenerator, string2);
    }
}

