/*
 * Decompiled with CFR 0.152.
 */
package eu.nets.sis.idrights.clientapi.impl;

import eu.nets.sis.idrights.clientapi.config.IDRightsError;
import eu.nets.sis.idrights.clientapi.config.IDRightsNamespace;
import eu.nets.sis.idrights.clientapi.config.MerchantContext;
import eu.nets.sis.idrights.clientapi.errorhandler.TTXmlErrorHandler;
import eu.nets.sis.idrights.clientapi.exception.IDRightsClientException;
import eu.nets.sis.idrights.clientapi.sign.XMLSigner;
import eu.nets.sis.idrights.clientapi.util.DateUtility;
import eu.nets.sis.idrights.clientapi.util.FileUtil;
import eu.nets.sis.idrights.clientapi.util.SecureDocumentBuilderFactory;
import eu.nets.sis.idrights.clientapi.util.String2Document;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import no.bbs.trust.b2b.xmlapi.message.Marshaller;
import no.bbs.trust.b2b.xmlapi.message.Unmarshaller;
import no.bbs.trust.b2b.xmlapi.message.domain.B2BMessage;
import no.bbs.trust.dhc.DHCConfiguration;
import no.bbs.trust.dhc.DHCHTTPClient;
import no.bbs.trust.dhc.DHCHTTPResponse;
import no.bbs.trust.dhc.types.NameObjectPair;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class IDRightsFacade {
    private MerchantContext context = null;

    public IDRightsFacade(MerchantContext ctx) {
        this.context = ctx;
    }

    public B2BMessage addShadowRegRecord(B2BMessage request) throws IDRightsClientException {
        IDRightsError errorEvent = IDRightsError.ADDSHADOWREGRECORD_FAILED;
        String requestName = "AddShadowRegRecord";
        if (null == request) {
            ArrayList<String> errparams = new ArrayList<String>();
            errparams.add("Input " + requestName + " cannot be null.");
            throw new IDRightsClientException(errorEvent, errparams);
        }
        if (null == request.getTrustB2BMessage().getAddShadowRegRecord()) {
            ArrayList<String> errparams = new ArrayList<String>();
            errparams.add("Input is not a " + requestName + " message.");
            throw new IDRightsClientException(errorEvent, errparams);
        }
        B2BMessage message = this.getB2BMessageResponse(requestName, request, errorEvent);
        return message;
    }

    public B2BMessage getBusinessCertificate(B2BMessage request) throws IDRightsClientException {
        IDRightsError errorEvent = IDRightsError.GETBUSINESSCERTIFICATE_FAILED;
        String requestName = "GetBusinessCertificate";
        if (null == request) {
            ArrayList<String> errparams = new ArrayList<String>();
            errparams.add("Input " + requestName + " cannot be null.");
            throw new IDRightsClientException(errorEvent, errparams);
        }
        if (null == request.getTrustB2BMessage().getGetBusinessCertificate()) {
            ArrayList<String> errparams = new ArrayList<String>();
            errparams.add("Input is not a " + requestName + " message.");
            throw new IDRightsClientException(errorEvent, errparams);
        }
        B2BMessage message = this.getB2BMessageResponse(requestName, request, errorEvent);
        return message;
    }

    public B2BMessage getBusinessPositionCodes(B2BMessage request) throws IDRightsClientException {
        IDRightsError errorEvent = IDRightsError.GETBUSINESSPOSITIONCODES_FAILED;
        String requestName = "GetBusinessPositionCodes";
        if (null == request) {
            ArrayList<String> errparams = new ArrayList<String>();
            errparams.add("Input " + requestName + " cannot be null.");
            throw new IDRightsClientException(errorEvent, errparams);
        }
        if (null == request.getTrustB2BMessage().getGetBusinessPositionCodes()) {
            ArrayList<String> errparams = new ArrayList<String>();
            errparams.add("Input is not a " + requestName + " message.");
            throw new IDRightsClientException(errorEvent, errparams);
        }
        B2BMessage message = this.getB2BMessageResponse(requestName, request, errorEvent);
        return message;
    }

    public B2BMessage getBusinessInterests(B2BMessage request) throws IDRightsClientException {
        IDRightsError errorEvent = IDRightsError.GETBUSINESSINTERESTS_FAILED;
        String requestName = "GetBusinessInterests";
        if (null == request) {
            ArrayList<String> errparams = new ArrayList<String>();
            errparams.add("Input " + requestName + " cannot be null.");
            throw new IDRightsClientException(errorEvent, errparams);
        }
        if (null == request.getTrustB2BMessage().getGetBusinessInterests()) {
            ArrayList<String> errparams = new ArrayList<String>();
            errparams.add("Input is not a " + requestName + " message.");
            throw new IDRightsClientException(errorEvent, errparams);
        }
        B2BMessage message = this.getB2BMessageResponse(requestName, request, errorEvent);
        return message;
    }

    public B2BMessage getHistoricalResponse(B2BMessage request) throws IDRightsClientException {
        IDRightsError errorEvent = IDRightsError.GETHISTORICALRESPONSE_FAILED;
        String requestName = "GetHistoricalResponse";
        if (null == request) {
            ArrayList<String> errparams = new ArrayList<String>();
            errparams.add("Input " + requestName + " cannot be null.");
            throw new IDRightsClientException(errorEvent, errparams);
        }
        if (null == request.getTrustB2BMessage().getGetHistoricalResponse()) {
            ArrayList<String> errparams = new ArrayList<String>();
            errparams.add("Input is not a " + requestName + " message.");
            throw new IDRightsClientException(errorEvent, errparams);
        }
        B2BMessage message = this.getB2BMessageResponse(requestName, request, errorEvent);
        return message;
    }

    public B2BMessage getHistoricalResponseID(B2BMessage request) throws IDRightsClientException {
        IDRightsError errorEvent = IDRightsError.GETHISTORICALRESPONSEID_FAILED;
        String requestName = "GetHistoricalResponseID";
        if (null == request) {
            ArrayList<String> errparams = new ArrayList<String>();
            errparams.add("Input " + requestName + " cannot be null.");
            throw new IDRightsClientException(errorEvent, errparams);
        }
        if (null == request.getTrustB2BMessage().getGetHistoricalResponseID()) {
            ArrayList<String> errparams = new ArrayList<String>();
            errparams.add("Input is not a " + requestName + " message.");
            throw new IDRightsClientException(errorEvent, errparams);
        }
        B2BMessage message = this.getB2BMessageResponse(requestName, request, errorEvent);
        return message;
    }

    public B2BMessage getOrgInfo(B2BMessage request) throws IDRightsClientException {
        IDRightsError errorEvent = IDRightsError.GETORGINFO_FAILED;
        String requestName = "GetOrgInfo";
        if (null == request) {
            ArrayList<String> errparams = new ArrayList<String>();
            errparams.add("Input " + requestName + " cannot be null.");
            throw new IDRightsClientException(errorEvent, errparams);
        }
        if (null == request.getTrustB2BMessage().getGetOrgInfo()) {
            ArrayList<String> errparams = new ArrayList<String>();
            errparams.add("Input is not a " + requestName + " message.");
            throw new IDRightsClientException(errorEvent, errparams);
        }
        B2BMessage message = this.getB2BMessageResponse(requestName, request, errorEvent);
        return message;
    }

    public B2BMessage getOriginalSPText(B2BMessage request) throws IDRightsClientException {
        IDRightsError errorEvent = IDRightsError.GETORIGINALSPTEXT_FAILED;
        String requestName = "GetOriginalSPText";
        if (null == request) {
            ArrayList<String> errparams = new ArrayList<String>();
            errparams.add("Input " + requestName + " cannot be null.");
            throw new IDRightsClientException(errorEvent, errparams);
        }
        if (null == request.getTrustB2BMessage().getGetOriginalSPText()) {
            ArrayList<String> errparams = new ArrayList<String>();
            errparams.add("Input is not a " + requestName + " message.");
            throw new IDRightsClientException(errorEvent, errparams);
        }
        B2BMessage message = this.getB2BMessageResponse(requestName, request, errorEvent);
        return message;
    }

    public B2BMessage getPersonInfo(B2BMessage request) throws IDRightsClientException {
        IDRightsError errorEvent = IDRightsError.GETPERSONINFO_FAILED;
        String requestName = "GetPersonInfo";
        if (null == request) {
            ArrayList<String> errparams = new ArrayList<String>();
            errparams.add("Input " + requestName + " cannot be null.");
            throw new IDRightsClientException(errorEvent, errparams);
        }
        if (null == request.getTrustB2BMessage().getGetPersonInfo()) {
            ArrayList<String> errparams = new ArrayList<String>();
            errparams.add("Input is not a " + requestName + " message.");
            throw new IDRightsClientException(errorEvent, errparams);
        }
        B2BMessage message = this.getB2BMessageResponse(requestName, request, errorEvent);
        return message;
    }

    public B2BMessage getSPInfoByPersonAndOrg(B2BMessage request) throws IDRightsClientException {
        IDRightsError errorEvent = IDRightsError.GETSPINFOBYPERSONANDORG_FAILED;
        String requestName = "GetSPInfoByPersonAndOrg";
        if (null == request) {
            ArrayList<String> errparams = new ArrayList<String>();
            errparams.add("Input " + requestName + " cannot be null.");
            throw new IDRightsClientException(errorEvent, errparams);
        }
        if (null == request.getTrustB2BMessage().getGetSPInfoByPersonAndOrg()) {
            ArrayList<String> errparams = new ArrayList<String>();
            errparams.add("Input is not a " + requestName + " message.");
            throw new IDRightsClientException(errorEvent, errparams);
        }
        B2BMessage message = this.getB2BMessageResponse(requestName, request, errorEvent);
        return message;
    }

    public B2BMessage getSPInfoByOrg(B2BMessage request) throws IDRightsClientException {
        IDRightsError errorEvent = IDRightsError.GETSPINFOBYORG_FAILED;
        String requestName = "GetSPInfoByOrg";
        if (null == request) {
            ArrayList<String> errparams = new ArrayList<String>();
            errparams.add("Input " + requestName + " cannot be null.");
            throw new IDRightsClientException(errorEvent, errparams);
        }
        if (null == request.getTrustB2BMessage().getGetSPInfoByOrg()) {
            ArrayList<String> errparams = new ArrayList<String>();
            errparams.add("Input is not a " + requestName + " message.");
            throw new IDRightsClientException(errorEvent, errparams);
        }
        B2BMessage message = this.getB2BMessageResponse(requestName, request, errorEvent);
        return message;
    }

    public B2BMessage getShadowRegRecords(B2BMessage request) throws IDRightsClientException {
        IDRightsError errorEvent = IDRightsError.GETSHADOWREGRECORDS_FAILED;
        String requestName = "GetShadowRegRecords";
        if (null == request) {
            ArrayList<String> errparams = new ArrayList<String>();
            errparams.add("Input " + requestName + " cannot be null.");
            throw new IDRightsClientException(errorEvent, errparams);
        }
        if (null == request.getTrustB2BMessage().getGetShadowRegRecords()) {
            ArrayList<String> errparams = new ArrayList<String>();
            errparams.add("Input is not a " + requestName + " message.");
            throw new IDRightsClientException(errorEvent, errparams);
        }
        B2BMessage message = this.getB2BMessageResponse(requestName, request, errorEvent);
        return message;
    }

    public B2BMessage removeShadowRegRecord(B2BMessage request) throws IDRightsClientException {
        IDRightsError errorEvent = IDRightsError.REMOVESHADOWREGRECORD_FAILED;
        String requestName = "RemoveShadowRegRecord";
        if (null == request) {
            ArrayList<String> errparams = new ArrayList<String>();
            errparams.add("Input " + requestName + " cannot be null.");
            throw new IDRightsClientException(errorEvent, errparams);
        }
        if (null == request.getTrustB2BMessage().getRemoveShadowRegRecord()) {
            ArrayList<String> errparams = new ArrayList<String>();
            errparams.add("Input is not a " + requestName + " message.");
            throw new IDRightsClientException(errorEvent, errparams);
        }
        B2BMessage message = this.getB2BMessageResponse(requestName, request, errorEvent);
        return message;
    }

    public B2BMessage verifySignatureAndProcuration(B2BMessage request) throws IDRightsClientException {
        IDRightsError errorEvent = IDRightsError.VERIFYSIGNATUREANDPROCURATION_FAILED;
        String requestName = "VerifySignatureAndProcuration";
        if (null == request) {
            ArrayList<String> errparams = new ArrayList<String>();
            errparams.add("Input " + requestName + " cannot be null.");
            throw new IDRightsClientException(errorEvent, errparams);
        }
        if (null == request.getTrustB2BMessage().getVerifySignatureAndProcuration()) {
            ArrayList<String> errparams = new ArrayList<String>();
            errparams.add("Input is not a " + requestName + " message.");
            throw new IDRightsClientException(errorEvent, errparams);
        }
        B2BMessage message = this.getB2BMessageResponse(requestName, request, errorEvent);
        return message;
    }

    private B2BMessage getB2BMessageResponse(String requestName, B2BMessage request, IDRightsError errorEvent) throws IDRightsClientException {
        String responseXml;
        String xml;
        String xmlrequest = null;
        try {
            xmlrequest = Marshaller.instance.marshall(request);
        }
        catch (JAXBException e) {
            ArrayList<String> errparams = new ArrayList<String>();
            errparams.add("Error while converting " + requestName + " object to XML.");
            throw new IDRightsClientException(errorEvent, errparams);
        }
        try {
            xmlrequest = this.modifyXML(xmlrequest);
        }
        catch (Throwable t) {
            ArrayList<String> errparams = new ArrayList<String>();
            errparams.add("Failed to get XML from input " + requestName + ". " + t.getMessage());
            throw new IDRightsClientException(errorEvent, errparams);
        }
        try {
            this.verifyXML(xmlrequest);
        }
        catch (Throwable t) {
            ArrayList<String> errparams = new ArrayList<String>();
            errparams.add("Failed to verify " + requestName + " xml representation. " + t.getMessage());
            throw new IDRightsClientException(errorEvent, errparams);
        }
        if (this.context.isSignRequest()) {
            try {
                XMLSigner signer = new XMLSigner(this.context.getClientSSLkeystore());
                xml = signer.signXML(xmlrequest);
            }
            catch (Throwable t) {
                ArrayList<String> errparams = new ArrayList<String>();
                errparams.add("Failed to sign " + requestName + " XML. " + t.getMessage());
                throw new IDRightsClientException(errorEvent, errparams);
            }
        } else {
            xml = xmlrequest;
        }
        try {
            DHCHTTPResponse response = this.getDHCResponse(xml, this.context.getDhcConfig());
            if (response.getStatus() > 200) {
                ArrayList<String> errparams = new ArrayList<String>();
                errparams.add("Failed to communicate to ID-Rights server. Error returned: " + response.getContent() + " - " + response.getStatus() + " - " + response.getStatusText());
                throw new IDRightsClientException(errorEvent, errparams);
            }
            responseXml = response.getContent();
        }
        catch (Throwable t) {
            ArrayList<String> errparams = new ArrayList<String>();
            errparams.add("An unexpected error occured communicating with the IDRights infrastructure: " + t.getMessage());
            throw new IDRightsClientException(errorEvent, errparams);
        }
        try {
            this.verifyXML(responseXml);
        }
        catch (Throwable t) {
            ArrayList<String> errparams = new ArrayList<String>();
            errparams.add("Failed to verify xml response. " + t.getMessage());
            throw new IDRightsClientException(errorEvent, errparams);
        }
        try {
            this.validateIfErrorResponse(responseXml);
        }
        catch (Throwable t) {
            ArrayList<String> errparams = new ArrayList<String>();
            errparams.add(t.getMessage());
            throw new IDRightsClientException(errorEvent, errparams);
        }
        Unmarshaller um = Unmarshaller.instance;
        B2BMessage message = null;
        try {
            message = um.unmarshallB2BMessage(responseXml);
        }
        catch (JAXBException e) {
            ArrayList<String> errparams = new ArrayList<String>();
            errparams.add("Error while converting XML to " + requestName + " object. " + e.getMessage());
            throw new IDRightsClientException(errorEvent, errparams);
        }
        return message;
    }

    private String modifyXML(String xml) {
        Date now = this.getCurrentTime();
        String timedate = DateUtility.DateToXML(now);
        xml = this.hackSig(xml, "Time", timedate);
        return xml;
    }

    private Date getCurrentTime() {
        Calendar cal = Calendar.getInstance();
        Date date = new Date(cal.getTimeInMillis());
        return date;
    }

    private String hackSig(String xmldsig, String element, String value) {
        String elemstart = "<" + element + ">";
        String elemend = "</" + element + ">";
        if (xmldsig.indexOf(elemstart) <= 0) {
            return xmldsig;
        }
        if (xmldsig.indexOf(elemend) <= 0) {
            return xmldsig;
        }
        String subst1 = xmldsig.substring(0, xmldsig.indexOf(elemstart) + elemstart.length());
        String subst2 = xmldsig.substring(xmldsig.indexOf(elemend), xmldsig.length());
        xmldsig = subst1 + value + subst2;
        return xmldsig;
    }

    private Document verifyXML(String xml) throws Exception {
        String2Document s2d = new String2Document();
        Document responseDoc = s2d.createDocumentFromString(xml);
        String xmlns = responseDoc.getDocumentElement().getAttribute("xmlns");
        if (null == xmlns) {
            throw new Exception("Invalid IDRights Message. XML cannot be verified. Missing xml namespace (xmlns) attribute.");
        }
        IDRightsNamespace ns = IDRightsNamespace.getByNS(xmlns);
        if (null == ns) {
            throw new Exception("Invalid IDRights Message. XML cannot be verified. Xml namespace (" + (Object)((Object)ns) + ") is not supported.");
        }
        String schemaFile = ns.getXsd();
        InputStream is = FileUtil.getResourceFromStream(schemaFile);
        if (null == is) {
            throw new Exception("Invalid IDRights Message. XML cannot be verified. Xsd (" + schemaFile + ") is not in classpath.");
        }
        DocumentBuilderFactory dbf = SecureDocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setValidating(true);
        dbf.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        dbf.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", is);
        DocumentBuilder docBuidler = dbf.newDocumentBuilder();
        docBuidler.setErrorHandler(new TTXmlErrorHandler());
        docBuidler.parse(new InputSource(new StringReader(xml)));
        return responseDoc;
    }

    private DHCHTTPResponse getDHCResponse(String xmlmod, DHCConfiguration dhcConf) throws UnsupportedEncodingException {
        DHCHTTPClient client = new DHCHTTPClient();
        ArrayList<NameObjectPair> headers = new ArrayList<NameObjectPair>();
        headers.add(new NameObjectPair("Content-Type", "application/xml;charset=utf-8"));
        DHCHTTPResponse dhcResponse = client.post(dhcConf, xmlmod.getBytes("UTF-8"), headers);
        return dhcResponse;
    }

    private void validateIfErrorResponse(String xmlrequest) throws IDRightsClientException, Exception {
        if (xmlrequest.contains("ErrorResponse")) {
            String2Document s2d = new String2Document();
            Document responseDoc = s2d.createDocumentFromString(xmlrequest);
            Element rootElement = responseDoc.getDocumentElement();
            String errorCode = this.getNodeValue("ErrorCode", rootElement);
            String description = this.getNodeValue("Description", rootElement);
            throw new IDRightsClientException("Error in IDRights XML response. [ErrorCode=" + errorCode + "] [Description=" + description + "]");
        }
    }

    private String getNodeValue(String tagName, Element element) {
        NodeList subList;
        NodeList list = element.getElementsByTagName(tagName);
        if (list != null && list.getLength() > 0 && (subList = list.item(0).getChildNodes()) != null && subList.getLength() > 0) {
            return subList.item(0).getNodeValue();
        }
        return null;
    }

    public B2BMessage getBeneficialOwners(B2BMessage request) throws IDRightsClientException {
        IDRightsError errorEvent = IDRightsError.GETBENEFICIALOWNERS_FAILED;
        String requestName = "GetBeneficialOwners";
        if (null == request) {
            ArrayList<String> errparams = new ArrayList<String>();
            errparams.add("Input " + requestName + " cannot be null.");
            throw new IDRightsClientException(errorEvent, errparams);
        }
        if (null == request.getTrustB2BMessage().getBeneficialOwnersTypeDef()) {
            ArrayList<String> errparams = new ArrayList<String>();
            errparams.add("Input is not a " + requestName + " message.");
            throw new IDRightsClientException(errorEvent, errparams);
        }
        B2BMessage message = this.getB2BMessageResponse(requestName, request, errorEvent);
        return message;
    }

    public B2BMessage getPersonInfoBySSN(B2BMessage request) throws IDRightsClientException {
        IDRightsError errorEvent = IDRightsError.GETPERSONINFOBYSSN_FAILED;
        String requestName = "GetPersonInfoBySSN";
        if (null == request) {
            ArrayList<String> errparams = new ArrayList<String>();
            errparams.add("Input " + requestName + " cannot be null.");
            throw new IDRightsClientException(errorEvent, errparams);
        }
        if (null == request.getTrustB2BMessage().getGetPersonInfoBySSN()) {
            ArrayList<String> errparams = new ArrayList<String>();
            errparams.add("Input is not a " + requestName + " message.");
            throw new IDRightsClientException(errorEvent, errparams);
        }
        B2BMessage message = this.getB2BMessageResponse(requestName, request, errorEvent);
        return message;
    }

    public B2BMessage getSolitarySR(B2BMessage request) throws IDRightsClientException {
        IDRightsError errorEvent = IDRightsError.GETSOLITARYSR_FAILED;
        String requestName = "GetSolitarySR";
        if (null == request) {
            ArrayList<String> errparams = new ArrayList<String>();
            errparams.add("Input " + requestName + " cannot be null.");
            throw new IDRightsClientException(errorEvent, errparams);
        }
        if (null == request.getTrustB2BMessage().getGetSolitarySR()) {
            ArrayList<String> errparams = new ArrayList<String>();
            errparams.add("Input is not a " + requestName + " message.");
            throw new IDRightsClientException(errorEvent, errparams);
        }
        B2BMessage message = this.getB2BMessageResponse(requestName, request, errorEvent);
        return message;
    }
}

