/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.trust.common.basics.exceptions;

import no.bbs.trust.common.basics.events.ActionEvent;
import no.bbs.trust.common.basics.events.actionevents.CommonActionEvent;

public class StatusCodeException
extends Exception {
    private static final long serialVersionUID = 3797144022861577108L;
    private ActionEvent code = null;
    private String caller = null;
    private String message = null;

    public StatusCodeException(ActionEvent ae) {
        StackTraceElement ste = new Throwable().fillInStackTrace().getStackTrace()[1];
        this.caller = ste.getClassName() + "." + ste.getMethodName() + "[" + ste.getLineNumber() + "]";
        if (null != ae) {
            this.code = ae;
        } else {
            this.code = CommonActionEvent.UNHANDLED_REQUEST;
            this.message = "Caller has not provided a valid ActionEvent. This MUST be rectified!";
        }
    }

    public StatusCodeException(ActionEvent ae, String eventMessage) {
        StackTraceElement ste = new Throwable().fillInStackTrace().getStackTrace()[1];
        this.caller = ste.getClassName() + "." + ste.getMethodName() + "[" + ste.getLineNumber() + "]";
        this.message = eventMessage;
        if (null != ae) {
            this.code = ae;
        } else {
            this.code = CommonActionEvent.UNHANDLED_REQUEST;
            this.message = "Caller has not provided a valid ActionEvent. This MUST be rectified! [" + this.message + "]";
        }
    }

    public String getStatusCode() {
        return this.code.getCode();
    }

    public ActionEvent getActionEvent() {
        return this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public String getCaller() {
        return this.caller;
    }

    @Override
    public String toString() {
        return "Status[" + this.getStatusCode() + ", " + this.code.toString() + ", " + this.caller + (null != this.message ? ", " + this.message : "") + "]";
    }
}

