/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.trust.dhc;

import java.net.URL;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;

public class DHCConfiguration {
    private String url = null;
    private String proxyHost = null;
    private String proxyPort = null;
    private String proxyUser = null;
    private String proxyPwd = null;
    private String keyStorePath = null;
    private String keyStorePwd = null;
    private String keyStoreType = null;
    private String trustStore = null;
    private String trustStorePwd = null;
    private String trustStoreType = null;
    private int socketTimeoutOverride = 0;
    private int connectRetryCount = 0;
    private boolean configureSSL = false;
    private String httpBasicAuthUser = null;
    private String httpBasicAuthPwd = null;
    private boolean useExpectContinue = false;

    public boolean useHttpBasicAuthentication() {
        return null != this.httpBasicAuthUser && null != this.httpBasicAuthPwd;
    }

    public boolean useExpectContinue() {
        return this.useExpectContinue;
    }

    public void setUseExpectContinue(boolean useExpectContinue) {
        this.useExpectContinue = useExpectContinue;
    }

    public String getHttpBasicAuthUser() {
        return this.httpBasicAuthUser;
    }

    public void setHttpBasicAuthUser(String httpBasicAuthUser) {
        this.httpBasicAuthUser = httpBasicAuthUser;
    }

    public String getHttpBasicAuthPwd() {
        return this.httpBasicAuthPwd;
    }

    public void setHttpBasicAuthPwd(String httpBasicAuthPwd) {
        this.httpBasicAuthPwd = httpBasicAuthPwd;
    }

    public boolean configureSSL() {
        return this.configureSSL;
    }

    public boolean requiresProxyTunneling() {
        return null != this.proxyHost && null != this.proxyPort;
    }

    public Credentials getProxyCredentials() {
        if (null != this.proxyUser && null != this.proxyPwd) {
            return new UsernamePasswordCredentials(this.proxyUser, this.proxyPwd);
        }
        return null;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        if (null == url) {
            throw new IllegalArgumentException("DHCConfiguration.setUrl failed. Input url is null");
        }
        try {
            URL u = new URL(url);
            if ("https".equalsIgnoreCase(u.getProtocol())) {
                this.configureSSL = true;
            }
        }
        catch (Exception mue) {
            throw new IllegalArgumentException("DHCConfiguration.setUrl failed. URL is malformed: " + mue.getMessage());
        }
        this.url = url;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = null != proxyHost && proxyHost.trim().length() > 0 ? proxyHost : null;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = null != this.proxyHost && this.proxyHost.trim().length() > 0 ? proxyPort : null;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public void setKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
    }

    public String getKeyStorePwd() {
        return this.keyStorePwd;
    }

    public void setKeyStorePwd(String keyStorePwd) {
        this.keyStorePwd = keyStorePwd;
    }

    public String getTrustStore() {
        return this.trustStore;
    }

    public void setTrustStore(String trustStore) {
        this.trustStore = trustStore;
    }

    public String getTrustStorePwd() {
        return this.trustStorePwd;
    }

    public void setTrustStorePwd(String trustStorePwd) {
        this.trustStorePwd = trustStorePwd;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    public String getProxyPwd() {
        return this.proxyPwd;
    }

    public void setProxyPwd(String proxyPwd) {
        this.proxyPwd = proxyPwd;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    public int getSocketTimeoutOverride() {
        return this.socketTimeoutOverride;
    }

    public void setSocketTimeoutOverride(int socketTimeoutOverride) {
        this.socketTimeoutOverride = socketTimeoutOverride;
    }

    public int getConnectRetryCount() {
        return this.connectRetryCount;
    }

    public void setConnectRetryCount(int connectRetryCount) {
        this.connectRetryCount = connectRetryCount;
    }
}

