/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.trust.dhc;

import java.util.ArrayList;
import no.bbs.trust.dhc.types.NameObjectPair;

public class DHCHTTPResponse {
    public static final int STATUSCODE_GENERALEXECPTION = 700;
    public static final int STATUSCODE_UNKNOWNPROTOCOL = 701;
    public static final int STATUSCODE_UNKNOWNHOST = 702;
    public static final int STATUSCODE_MALFORMEDURL = 703;
    public static final int STATUSCODE_UNEXPECTEDENCODING = 704;
    public static final int STATUSCODE_BADIO = 600;
    public static final int STATUSCODE_SOCKETTIMEOUT = 601;
    public static final int STATUSCODE_SSLEXCEPTION = 602;
    private int status = 0;
    private String statusReason = "";
    private byte[] content = null;
    private ArrayList<NameObjectPair> headers = null;

    public DHCHTTPResponse(int responseCode, String responseReason, ArrayList<NameObjectPair> responseHeaders, byte[] responseData) {
        this.headers = responseHeaders;
        this.content = responseData;
        this.status = responseCode;
        this.statusReason = responseReason;
    }

    public byte[] getContentBytes() {
        if (null == this.content) {
            this.content = new byte[0];
        }
        return this.content;
    }

    public String getContent() {
        return new String(this.getContentBytes());
    }

    public ArrayList<NameObjectPair> getHeaders() {
        if (null == this.headers) {
            this.headers = new ArrayList();
        }
        return this.headers;
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusText() {
        if (null == this.statusReason) {
            this.statusReason = "";
        }
        return this.statusReason;
    }
}

