/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.trust.dhc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import javax.net.ssl.SSLException;
import no.bbs.trust.dhc.DHCConfiguration;
import no.bbs.trust.dhc.DHCHTTPResponse;
import no.bbs.trust.dhc.DHCSSLProtocolSocketFactory;
import no.bbs.trust.dhc.types.NameObjectPair;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.ByteArrayPartSource;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import sun.misc.BASE64Encoder;

public class DHCHTTPClient {
    private static final int DEFAULT_SO_TIMEOUT = 5000;

    private void configureProxy(HttpClient httpclient, DHCConfiguration config) {
        if (config.requiresProxyTunneling()) {
            httpclient.getHostConfiguration().setProxy(config.getProxyHost(), Integer.parseInt(config.getProxyPort()));
            if (null != config.getProxyCredentials()) {
                httpclient.getState().setProxyCredentials(AuthScope.ANY, config.getProxyCredentials());
            }
        }
    }

    private void configureProtocol(HttpClient httpclient, DHCConfiguration config) throws MalformedURLException {
        if (config.configureSSL()) {
            File f;
            URL sslKeystore = null;
            URL sslTruststore = null;
            if (null != config.getKeyStorePath()) {
                f = new File(config.getKeyStorePath());
                sslKeystore = f.toURL();
            }
            if (null != config.getTrustStore()) {
                f = new File(config.getTrustStore());
                sslTruststore = f.toURL();
            }
            DHCSSLProtocolSocketFactory sf = new DHCSSLProtocolSocketFactory(sslKeystore, config.getKeyStorePwd(), config.getKeyStoreType(), sslTruststore, config.getTrustStorePwd(), config.getTrustStoreType(), config.getSocketTimeoutOverride());
            URL targetURL = new URL(config.getUrl());
            int port = targetURL.getPort();
            if (port == -1) {
                port = 443;
            }
            Protocol myhttps = new Protocol("https", (ProtocolSocketFactory)sf, port);
            httpclient.getHostConfiguration().setHost(targetURL.getHost(), port, myhttps);
        } else {
            URL targetURL = new URL(config.getUrl());
            int port = targetURL.getPort();
            if ("http".equalsIgnoreCase(targetURL.getProtocol()) && port == -1) {
                port = 80;
            }
            httpclient.getHostConfiguration().setHost(targetURL.getHost(), port);
        }
    }

    private void configureAuthentication(HttpMethodBase method, DHCConfiguration config) throws UnsupportedEncodingException {
        if (config.useHttpBasicAuthentication()) {
            String creds = config.getHttpBasicAuthUser() + ":" + config.getHttpBasicAuthPwd();
            String authCreds = "Basic " + new BASE64Encoder().encode(creds.getBytes("UTF-8"));
            method.addRequestHeader(new Header("Authorization", authCreds));
        }
    }

    private void configureTransport(HttpMethodBase method, DHCConfiguration config) {
        if (null == method) {
            return;
        }
        method.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(config.getConnectRetryCount(), false));
        if (config.getSocketTimeoutOverride() > 0) {
            method.getParams().setParameter("http.socket.timeout", (Object)config.getSocketTimeoutOverride());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DHCHTTPResponse post(DHCConfiguration config, byte[] data, ArrayList<NameObjectPair> headers) {
        if (null == config) {
            throw new IllegalArgumentException("DHCConfiguration cannot be null");
        }
        if (config.getSocketTimeoutOverride() == 0) {
            config.setSocketTimeoutOverride(5000);
        }
        HttpClient httpclient = new HttpClient();
        PostMethod method = null;
        try {
            DHCHTTPResponse response;
            method = new PostMethod(new URL(config.getUrl()).getPath());
            this.configureProxy(httpclient, config);
            this.configureProtocol(httpclient, config);
            this.configureTransport((HttpMethodBase)method, config);
            this.addHeaders((HttpMethodBase)method, headers);
            this.configureAuthentication((HttpMethodBase)method, config);
            method.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(data));
            int connectionRetryCount = config.getConnectRetryCount();
            method.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(connectionRetryCount, false));
            DHCHTTPResponse dHCHTTPResponse = response = this.getResponse((HttpMethodBase)method, httpclient);
            return dHCHTTPResponse;
        }
        catch (MalformedURLException mue) {
            DHCHTTPResponse dHCHTTPResponse = new DHCHTTPResponse(703, mue.getMessage(), null, null);
            return dHCHTTPResponse;
        }
        catch (UnsupportedEncodingException uee) {
            DHCHTTPResponse dHCHTTPResponse = new DHCHTTPResponse(704, uee.getMessage(), null, null);
            return dHCHTTPResponse;
        }
        finally {
            if (null != method) {
                method.releaseConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DHCHTTPResponse put(DHCConfiguration config, ArrayList<NameObjectPair> parts, ArrayList<NameObjectPair> headers) {
        if (null == config) {
            throw new IllegalArgumentException("DHCConfiguration cannot be null");
        }
        if (null == parts || parts.isEmpty()) {
            throw new IllegalArgumentException("Multipart items can not be null for Put method");
        }
        if (config.getSocketTimeoutOverride() == 0) {
            config.setSocketTimeoutOverride(5000);
        }
        HttpClient httpclient = new HttpClient();
        PutMethod method = null;
        try {
            DHCHTTPResponse response;
            method = new PutMethod(new URL(config.getUrl()).getPath());
            this.configureProxy(httpclient, config);
            this.configureProtocol(httpclient, config);
            this.configureTransport((HttpMethodBase)method, config);
            this.addHeaders((HttpMethodBase)method, headers);
            this.configureAuthentication((HttpMethodBase)method, config);
            method.getParams().setBooleanParameter("http.protocol.expect-continue", config.useExpectContinue());
            this.addParts(method, parts);
            int connectionRetryCount = config.getConnectRetryCount();
            method.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(connectionRetryCount, false));
            DHCHTTPResponse dHCHTTPResponse = response = this.getResponse((HttpMethodBase)method, httpclient);
            return dHCHTTPResponse;
        }
        catch (MalformedURLException mue) {
            DHCHTTPResponse dHCHTTPResponse = new DHCHTTPResponse(703, mue.getMessage(), null, null);
            return dHCHTTPResponse;
        }
        catch (UnsupportedEncodingException uee) {
            DHCHTTPResponse dHCHTTPResponse = new DHCHTTPResponse(704, uee.getMessage(), null, null);
            return dHCHTTPResponse;
        }
        finally {
            if (null != method) {
                method.releaseConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DHCHTTPResponse get(DHCConfiguration config, ArrayList<NameValuePair> params, ArrayList<NameObjectPair> headers) {
        if (null == config) {
            throw new IllegalArgumentException("DHCConfiguration cannot be null");
        }
        if (config.getSocketTimeoutOverride() == 0) {
            config.setSocketTimeoutOverride(5000);
        }
        HttpClient httpclient = new HttpClient();
        GetMethod method = null;
        try {
            DHCHTTPResponse response;
            method = new GetMethod(new URL(config.getUrl()).getPath());
            this.configureProxy(httpclient, config);
            this.configureProtocol(httpclient, config);
            this.configureTransport((HttpMethodBase)method, config);
            this.addHeaders((HttpMethodBase)method, headers);
            this.addParams((HttpMethodBase)method, params);
            int connectionRetryCount = config.getConnectRetryCount();
            method.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(connectionRetryCount, false));
            DHCHTTPResponse dHCHTTPResponse = response = this.getResponse((HttpMethodBase)method, httpclient);
            return dHCHTTPResponse;
        }
        catch (MalformedURLException mue) {
            DHCHTTPResponse dHCHTTPResponse = new DHCHTTPResponse(703, mue.getMessage(), null, null);
            return dHCHTTPResponse;
        }
        finally {
            if (null != method) {
                method.releaseConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DHCHTTPResponse getResponse(HttpMethodBase method, HttpClient httpclient) {
        DHCHTTPResponse response = null;
        InputStream in = null;
        try {
            int statusCode = httpclient.executeMethod((HttpMethod)method);
            ArrayList<NameObjectPair> headers = new ArrayList<NameObjectPair>();
            Header[] responseHeaders = method.getResponseHeaders();
            for (int i = 0; i < responseHeaders.length; ++i) {
                NameObjectPair nvp = new NameObjectPair(responseHeaders[i].getName().toLowerCase(), responseHeaders[i].getValue());
                headers.add(nvp);
            }
            in = method.getResponseBodyAsStream();
            byte[] responseData = new byte[]{};
            byte[] readBytes = new byte[5000];
            int avail = in.read(readBytes);
            while (avail > 0) {
                byte[] tempBytes = new byte[responseData.length + avail];
                System.arraycopy(responseData, 0, tempBytes, 0, responseData.length);
                System.arraycopy(readBytes, 0, tempBytes, responseData.length, avail);
                responseData = tempBytes;
                avail = in.read(readBytes);
            }
            response = new DHCHTTPResponse(statusCode, null, headers, responseData);
        }
        catch (UnknownHostException uhe) {
            String responseContent = "Host[" + httpclient.getHostConfiguration().getHost() + "] unknown";
            response = new DHCHTTPResponse(702, uhe.getMessage(), null, responseContent.getBytes());
        }
        catch (SocketTimeoutException ste) {
            String responseContent = "Socket timeout[" + method.getParams().getParameter("http.socket.timeout") + "ms] exceeded for URL[" + httpclient.getHostConfiguration().getHostURL() + "]";
            response = new DHCHTTPResponse(601, ste.getMessage(), null, responseContent.getBytes());
        }
        catch (SSLException se) {
            String responseContent = "Host protocol does not match URL scheme[" + httpclient.getHostConfiguration().getProtocol().getScheme() + "] for URL[" + httpclient.getHostConfiguration().getHostURL() + "]";
            response = new DHCHTTPResponse(602, se.getMessage(), null, responseContent.getBytes());
        }
        catch (IOException e) {
            response = new DHCHTTPResponse(600, e.getMessage(), null, null);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException uhe) {}
            }
        }
        return response;
    }

    private void addHeaders(HttpMethodBase method, ArrayList<NameObjectPair> headers) {
        if (null != headers) {
            for (NameObjectPair nvp : headers) {
                method.addRequestHeader(nvp.getName(), (String)nvp.getValue());
            }
        }
    }

    private void addParams(HttpMethodBase method, ArrayList<NameValuePair> params) {
        if (null != params) {
            NameValuePair[] nvp = new NameValuePair[params.size()];
            for (int i = 0; i < params.size(); ++i) {
                nvp[i] = new NameValuePair(params.get(i).getName(), params.get(i).getValue());
            }
            method.setQueryString(nvp);
        }
    }

    private void addParts(PutMethod method, ArrayList<NameObjectPair> parts) {
        if (null != parts) {
            Part[] multiparts = new Part[parts.size()];
            int i = 0;
            for (NameObjectPair nop : parts) {
                String name;
                String pname = name = nop.getName();
                String ctype = "text/plain";
                String chset = null;
                String[] tokens = name.split(":");
                pname = tokens[0];
                if (tokens.length > 1) {
                    ctype = tokens[1].trim();
                }
                if (tokens.length > 2) {
                    chset = tokens[2].trim();
                }
                if (nop.getValue() instanceof String) {
                    StringPart sp = new StringPart(pname, (String)nop.getValue());
                    sp.setContentType(ctype);
                    if (null != chset) {
                        sp.setCharSet(chset);
                    }
                    multiparts[i] = sp;
                } else if (nop.getValue() instanceof byte[]) {
                    FilePart fp = new FilePart(pname, (PartSource)new ByteArrayPartSource(pname + i, (byte[])nop.getValue()));
                    fp.setContentType(ctype);
                    if (null != chset) {
                        fp.setCharSet(chset);
                    } else {
                        fp.setCharSet(null);
                    }
                    multiparts[i] = fp;
                } else {
                    multiparts[i] = new StringPart("undefined" + i, "undefined");
                }
                ++i;
            }
            method.setRequestEntity((RequestEntity)new MultipartRequestEntity(multiparts, method.getParams()));
        }
    }
}

