package eu.nets.sis.idrights.demoapp;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;

import javax.net.ServerSocketFactory;

import eu.nets.sis.idrights.demoapp.service.IDRightsService;
import eu.nets.sis.idrights.demoapp.startup.ServerSetup;

/**
 * Entry class, starts the SpringBoot application
 *
 */

public class MainApplication {
	/**
	 * Entry point to access ID-Rights demo application.
	 * Port number can be changed in applications.properties.
	 * 
	 * @param args Command line arguments
	 * @throws IOException 
	 * @throws UnknownHostException 
	 */
	public static void main(String[] args) throws IOException {
		if (args.length < 2 || !args[0].toLowerCase().endsWith("p12")) {
			System.out.println(
					"\n\nERROR: Please provide a valid keystore (PKCS12) path and a password as command line arguments to execute the demo app. "
							+ "Contact IN Groupe support at trustservices@ingroupe.com for details.\n");
		} else {
			if (ServerSetup.isPortAvailable()) {
				IDRightsService.registerMerchantContext(args[0], args[1]);
				new ServerSetup().start();
			} else {
				System.out.println("\n\nThe demo application cannot be started. Port " + DemoAppProperties.port + " is already in use.\nMake sure no other applications is configured to use this port and try again.");
			}
		}
	}
}
