package eu.nets.sis.idrights.demoapp;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DemoAppProperties {
	
	private static final Logger LOGGER = LogManager.getLogger(DemoAppProperties.class);
	
	public static String baseUrl;
	public static String contextPath;
	public static int port;
	public static String merchantId;
	public static String idRightsUrlBase;
	public static String clientTrustStoreType;
	public static String clientTrustStore;
	public static String clientTrustStorePwd;
	public static String keyStoreType;

	static {
		try (InputStream input = DemoAppProperties.class.getClassLoader().getResourceAsStream("application.properties")) {
			Properties prop = new Properties();
            prop.load(input);
            baseUrl = prop.getProperty("base.url");
            contextPath = prop.getProperty("context.path");
            port = Integer.parseInt(prop.getProperty("port"));
            merchantId = prop.getProperty("merchantid");
            idRightsUrlBase = prop.getProperty("idrightsurl");
            clientTrustStoreType = prop.getProperty("clienttruststoretype");
            clientTrustStore = prop.getProperty("clienttruststore");
            clientTrustStorePwd = prop.getProperty("clienttruststorepwd");
            keyStoreType = prop.getProperty("keystoretype");
		} catch (IOException e) {
            System.out.println("\n\n<<<<<<<<<<ERROR>>>>>>>>>>\n\nId-Rights Demo App properties loading has failed.\n\nErrorMessage=" + e.getMessage() + ".\n\n");
            LOGGER.error("Id-Rights Demo App properties loading has failed", e);
            System.exit(0);
        }
	}
}
