/*
 * Decompiled with CFR 0.152.
 */
package eu.nets.sis.common.dhc;

import eu.nets.sis.common.dhc.types.NameValuePair;
import java.util.ArrayList;

public class DHCResponse {
    private int status = 0;
    private String statusText = "";
    private byte[] content = null;
    private ArrayList<NameValuePair> headers = null;

    public DHCResponse(int responseCode, ArrayList<NameValuePair> responseHeaders, byte[] responseData) {
        this.status = responseCode;
        this.headers = responseHeaders;
        this.content = responseData;
    }

    public DHCResponse(int responseCode, String responseText) {
        this.status = responseCode;
        this.statusText = responseText;
    }

    public byte[] getContentBytes() {
        if (null == this.content) {
            this.content = new byte[0];
        }
        return this.content;
    }

    public String getContent() {
        return new String(this.getContentBytes());
    }

    public ArrayList<NameValuePair> getHeaders() {
        if (null == this.headers) {
            this.headers = new ArrayList();
        }
        return this.headers;
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusText() {
        if (null == this.statusText) {
            this.statusText = "";
        }
        return this.statusText;
    }
}

