/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.bc.cryptlib.ds;

import java.security.KeyException;
import java.security.PublicKey;
import java.util.List;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import no.bbs.tt.bc.cryptlib.ds.SimpleKeySelectorResult;

public class BCKeyValueKeySelector
extends KeySelector {
    @Override
    public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod method, XMLCryptoContext context) throws KeySelectorException {
        if (keyInfo == null) {
            throw new KeySelectorException("Null KeyInfo object!");
        }
        SignatureMethod sm = (SignatureMethod)method;
        List<XMLStructure> list = keyInfo.getContent();
        for (int i = 0; i < list.size(); ++i) {
            XMLStructure xmlStructure = list.get(i);
            if (!(xmlStructure instanceof KeyValue)) continue;
            PublicKey pk = null;
            try {
                pk = ((KeyValue)xmlStructure).getPublicKey();
            }
            catch (KeyException ke) {
                throw new KeySelectorException(ke);
            }
            if (!BCKeyValueKeySelector.algEquals(sm.getAlgorithm(), pk.getAlgorithm())) continue;
            return new SimpleKeySelectorResult(pk);
        }
        throw new KeySelectorException("No KeyValue element found!");
    }

    static boolean algEquals(String algURI, String algName) {
        if (algName.equalsIgnoreCase("DSA") && algURI.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#dsa-sha1")) {
            return true;
        }
        return algName.equalsIgnoreCase("RSA") && algURI.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
    }
}

