/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.bc.cryptlib.ds;

import java.io.ByteArrayInputStream;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.parsers.DocumentBuilderFactory;
import no.bbs.tt.bc.cryptlib.ds.BCCryptoKeySelector;
import no.bbs.tt.bc.cryptlib.ds.XMLDSIGContent;
import no.bbs.tt.bc.cryptlib.ds.XMLDSParseException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class XMLDSIGParser {
    public XMLDSIGContent parseXMLDSig(byte[] signatureBytes, boolean validateIfX509IsExpired) throws XMLDSParseException {
        if (null == signatureBytes || signatureBytes.length <= 0) {
            throw new XMLDSParseException("XMLDSIGParser failed. Input signatureBytes is null or empty");
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        Document doc = null;
        try {
            doc = dbf.newDocumentBuilder().parse(new ByteArrayInputStream(signatureBytes));
        }
        catch (Throwable t) {
            throw new XMLDSParseException("XMLDSIGParser failed. Unable to build DOM Document based on input signatureBytes: " + t.getMessage());
        }
        NodeList nl = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (nl.getLength() == 0) {
            throw new XMLDSParseException("XMLDSIGParser failed. Invalid input signatureBytes. Cannot find Signature element");
        }
        XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");
        DOMValidateContext valContext = null;
        NodeList keyValueNL = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "KeyValue");
        BCCryptoKeySelector keySelector = null;
        XMLDSIGContent content = new XMLDSIGContent();
        if (null == keyValueNL || keyValueNL.getLength() == 0) {
            keySelector = new BCCryptoKeySelector(validateIfX509IsExpired);
            valContext = new DOMValidateContext(keySelector, nl.item(0));
            XMLSignature signature = null;
            try {
                signature = fac.unmarshalXMLSignature(valContext);
                KeyInfo ki = signature.getKeyInfo();
                keySelector.select(ki, KeySelector.Purpose.SIGN, signature.getSignedInfo().getSignatureMethod(), valContext);
                content.setSignerCertificate(keySelector.getSignerCertificate());
                content.setCertificateChain(keySelector.getCertificates());
            }
            catch (Throwable t) {
                throw new XMLDSParseException("XMLDSIGParser failed. Failed to unmarshal the XMLSignature: " + t.getMessage());
            }
        }
        content.setCustomPropertySignature(this.isCustomPropertySignature(doc));
        return content;
    }

    public boolean isCustomPropertySignature(Document doc) {
        NodeList nList = doc.getElementsByTagNameNS("http://www.nets.eu/e-signing/additional-signature-properties", "AdditionalSignatureProperties");
        return nList.getLength() > 0;
    }
}

