/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.bc.cryptlib.ds;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.List;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureProperties;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.TransformService;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import no.bbs.tt.bc.cryptlib.ds.BCCryptoKeySelector;
import no.bbs.tt.bc.cryptlib.ds.BCKeyValueKeySelector;
import no.bbs.tt.bc.cryptlib.ds.SignedObject;
import no.bbs.tt.bc.cryptlib.ds.XMLDSIGContent;
import no.bbs.tt.bc.cryptlib.ds.XMLDSValidationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLDSIGValidator {
    boolean validateIfX509IsExpired = true;

    public void setValidateX509Expiry(boolean isValidatingX509Expiry) {
        this.validateIfX509IsExpired = isValidatingX509Expiry;
    }

    public XMLDSIGContent validateXMLDSig(byte[] signatureBytes) throws XMLDSValidationException {
        if (null == signatureBytes || signatureBytes.length <= 0) {
            throw new XMLDSValidationException("XMLDSIGValidator failed. Input signatureBytes is null or empty");
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        Document doc = null;
        try {
            doc = dbf.newDocumentBuilder().parse(new ByteArrayInputStream(signatureBytes));
        }
        catch (Throwable t) {
            throw new XMLDSValidationException("XMLDSIGValidator failed. Unable to build DOM Document based on input signatureBytes: " + t.getMessage());
        }
        NodeList nl = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (nl.getLength() == 0) {
            throw new XMLDSValidationException("XMLDSIGValidator failed. Invalid input signatureBytes. Cannot find Signature element");
        }
        XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");
        DOMValidateContext valContext = null;
        NodeList keyValueNL = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "KeyValue");
        BCCryptoKeySelector keySelector = null;
        if (null == keyValueNL || keyValueNL.getLength() == 0) {
            keySelector = new BCCryptoKeySelector(this.validateIfX509IsExpired);
            valContext = new DOMValidateContext(keySelector, nl.item(0));
        } else {
            valContext = new DOMValidateContext(new BCKeyValueKeySelector(), nl.item(0));
        }
        XMLSignature signature = null;
        try {
            signature = fac.unmarshalXMLSignature(valContext);
        }
        catch (Throwable t) {
            throw new XMLDSValidationException("XMLDSIGValidator failed. Failed to unmarshal the XMLSignature: " + t.getMessage());
        }
        NodeList bankIdSignedDataList = doc.getElementsByTagNameNS("http://www.bankid.com/signature/v1.0.0/types", "bankIdSignedData");
        for (int i = 0; i < bankIdSignedDataList.getLength(); ++i) {
            Node node = bankIdSignedDataList.item(i);
            if (node.getNodeType() != 1) continue;
            Element bankIdSignedDataNode = (Element)node;
            valContext.setIdAttributeNS(bankIdSignedDataNode, null, "Id");
        }
        boolean coreValidity = false;
        try {
            coreValidity = signature.validate(valContext);
        }
        catch (Throwable t) {
            throw new XMLDSValidationException("XMLDSIGValidator failed. Unable to validate the XMLSignature: " + t.getMessage());
        }
        if (!coreValidity) {
            try {
                boolean sv = signature.getSignatureValue().validate(valContext);
                Iterator<Reference> i = signature.getSignedInfo().getReferences().iterator();
                StringBuffer b = new StringBuffer();
                int j = 0;
                while (i.hasNext()) {
                    boolean refValid = i.next().validate(valContext);
                    b.append("ref[" + j + "] validity status: " + refValid + " ");
                    ++j;
                }
                throw new XMLDSValidationException("XMLDSIGValidator failed. XMLSignature did not pass core validation. IsSignatureValue valid[" + sv + "] Reason: " + b.toString());
            }
            catch (XMLDSValidationException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new XMLDSValidationException("XMLDSIGValidator failed. XMLSignature did not pass core validation.");
            }
        }
        XMLDSIGContent content = new XMLDSIGContent();
        SignedInfo signedinfo = signature.getSignedInfo();
        Iterator<Reference> references = signedinfo.getReferences().iterator();
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = null;
        String xpathExpression = null;
        int z = 0;
        while (references.hasNext()) {
            block39: {
                Reference currRef = references.next();
                content.addReference(currRef);
                String currRefURI = currRef.getURI();
                String refURIId = currRefURI.substring(1);
                xpathExpression = "//*[@Id='" + refURIId + "']";
                xPath = factory.newXPath();
                try {
                    InputSource xmlInputSource = new InputSource(new ByteArrayInputStream(signatureBytes));
                    Node node = (Node)xPath.evaluate(xpathExpression, xmlInputSource, XPathConstants.NODE);
                    if (null != node) {
                        if (node instanceof Element) {
                            Element elem = (Element)node;
                            SignedObject signedObject = new SignedObject();
                            signedObject.setObjectId(refURIId);
                            if ("Object".equals(elem.getLocalName())) {
                                List<XMLObject> signatureObjects = signature.getObjects();
                                XMLObject xmlobject = null;
                                for (int i = 0; i < signatureObjects.size(); ++i) {
                                    if (!signatureObjects.get(i).getId().equals(refURIId)) continue;
                                    xmlobject = signatureObjects.get(i);
                                    break;
                                }
                                signedObject.setMimeType(xmlobject.getMimeType());
                                signedObject.setEncoding(xmlobject.getEncoding());
                                List<XMLStructure> xmlStructures = xmlobject.getContent();
                                if (null == xmlStructures) {
                                    throw new XMLDSValidationException("XMLDSIGValidator failed. Signed Object [" + xmlobject.getId() + "] content is empty");
                                }
                                XMLStructure struct = xmlStructures.get(0);
                                if (null == struct) {
                                    throw new XMLDSValidationException("XMLDSIGValidator failed. Signed Object [" + xmlobject.getId() + "] XMLStructure content is empty");
                                }
                                if (struct instanceof SignatureProperties) {
                                    SignatureProperties sp = (SignatureProperties)struct;
                                    signedObject.setDataInObjectSignatureProperties(true);
                                    signedObject.setSignatureProperties(sp);
                                    content.addSignedObject(signedObject);
                                    break block39;
                                }
                                if (struct instanceof DOMStructure) {
                                    DOMStructure domStruct = (DOMStructure)struct;
                                    if (null == domStruct.getNode()) {
                                        throw new XMLDSValidationException("XMLDSIGValidator failed. Signed Object DOMStructure content is empty");
                                    }
                                    Node orgNode = domStruct.getNode();
                                    if (orgNode instanceof Element) {
                                        try {
                                            ByteArrayOutputStream os = new ByteArrayOutputStream();
                                            TransformerFactory tf = TransformerFactory.newInstance();
                                            Transformer trans = tf.newTransformer();
                                            trans.transform(new DOMSource(orgNode), new StreamResult(os));
                                            os.flush();
                                            byte[] b = os.toByteArray();
                                            os.close();
                                            String signedXml = new String(b, "UTF-8");
                                            signedObject.setDataInObjectXml(true);
                                            signedObject.setDataAsBytes(b);
                                            signedObject.setDataAsString(signedXml);
                                            content.addSignedObject(signedObject);
                                            break block39;
                                        }
                                        catch (Throwable t) {
                                            throw new XMLDSValidationException("XMLDSIGValidator failed. Failed to Transform XMLObject->DOMStructure->Element to String value: " + t.getMessage());
                                        }
                                    }
                                    String value = orgNode.getNodeValue();
                                    if (null == value) {
                                        value = orgNode.getTextContent();
                                    }
                                    signedObject.setDataInObjectB64Binary(true);
                                    signedObject.setDataAsString(value);
                                    content.addSignedObject(signedObject);
                                    break block39;
                                }
                                if (struct instanceof TransformService) {
                                    throw new XMLDSValidationException("XMLDSIGValidator failed. Signed Object XMLStructure cannot reference a TransformService. Only evenloping signature are supported");
                                }
                                throw new XMLDSValidationException("XMLDSIGValidator failed. Invalid Signed Object XMLStructure [" + struct.getClass().getName() + "] is not supported");
                            }
                            if ("KeyInfo".equals(elem.getLocalName())) {
                                KeyInfo keyinfo = signature.getKeyInfo();
                                if (refURIId.equals(keyinfo.getId())) {
                                    signedObject.setKeyInfoSigned(true);
                                    signedObject.setKeyInfo(keyinfo);
                                    content.addSignedObject(signedObject);
                                }
                                break block39;
                            }
                            try {
                                ByteArrayOutputStream os = new ByteArrayOutputStream();
                                TransformerFactory tf = TransformerFactory.newInstance();
                                Transformer trans = tf.newTransformer();
                                trans.transform(new DOMSource(elem), new StreamResult(os));
                                os.flush();
                                byte[] b = os.toByteArray();
                                os.close();
                                String signedXml = new String(b, "UTF-8");
                                signedObject.setDataInObjectXml(true);
                                signedObject.setDataAsBytes(b);
                                signedObject.setDataAsString(signedXml);
                                content.addSignedObject(signedObject);
                                break block39;
                            }
                            catch (Throwable t) {
                                throw new XMLDSValidationException("XMLDSIGValidator failed. Failed to Transform XMLObject->DOMStructure->Element to String value: " + t.getMessage());
                            }
                        }
                        throw new XMLDSValidationException("XMLDSIGValidator failed. Reference URI [" + currRefURI + "] does not point to an Element in Signature");
                    }
                    throw new XMLDSValidationException("XMLDSIGValidator failed. Failed to located Referenced Element with URI [" + currRefURI + "]");
                }
                catch (XPathExpressionException xee) {
                    throw new XMLDSValidationException("XMLDSIGValidator failed. Failed to located Referenced Element with URI [" + currRefURI + "]. XPath Expression [" + xpathExpression + "] did not validate");
                }
            }
            ++z;
        }
        if (null != keySelector) {
            List<X509Certificate> certs = keySelector.getCertificates();
            if (null == certs) {
                throw new XMLDSValidationException("XMLDSIGValidator failed. Signature does not contain any X509Certificates");
            }
            content.setCertificateChain(certs);
            content.setSignerCertificate(keySelector.getSignerCertificate());
        }
        return content;
    }
}

