/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.bc.cryptlib.ocsp;

import eu.nets.sis.common.dhc.DHCClient;
import eu.nets.sis.common.dhc.DHCConfig;
import eu.nets.sis.common.dhc.DHCResponse;
import eu.nets.sis.common.dhc.types.DHCException;
import eu.nets.sis.common.dhc.types.NameValuePair;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import no.bbs.tt.bc.cryptlib.ocsp.CertificateStatusException;
import no.bbs.tt.bc.cryptlib.ocsp.OCSPData;
import no.bbs.tt.bc.cryptlib.util.ASN1Util;
import no.bbs.tt.bc.cryptlib.util.BCCryptoLoader;
import no.bbs.tt.bc.cryptlib.util.HashUtil;
import no.bbs.tt.bc.cryptlib.util.SecureRandomGenerator;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import org.bouncycastle.asn1.ocsp.CertID;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPReqBuilder;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.RevokedStatus;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.cert.ocsp.UnknownStatus;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OCSPRequestor {
    protected static final Logger logger = LoggerFactory.getLogger((String)"mainLogger");
    private boolean signOCSPRequest = false;

    public OCSPRequestor() {
        BCCryptoLoader.registerBCProvider();
    }

    public OCSPData getCertificateStatus(X509Certificate[] requestorCerts, PrivateKey requestorPK, X509Certificate certToCheck, X509Certificate issuerCert, String vaURL, String proxyHost, String proxyPort, String proxyUser, String proxyPwd, long timoutInMills, List extensions, String trustStorePath, String trustStorePwd) throws CertificateStatusException {
        return this.getCertificateStatus(requestorCerts, requestorPK, certToCheck, issuerCert, vaURL, proxyHost, proxyPort, proxyUser, proxyPwd, timoutInMills, extensions, trustStorePath, trustStorePwd, true);
    }

    public OCSPData getCertificateStatus(X509Certificate[] requestorCerts, PrivateKey requestorPK, X509Certificate certToCheck, X509Certificate issuerCert, String vaURL, String proxyHost, String proxyPort, String proxyUser, String proxyPwd, long timoutInMills, List extensions, String trustStorePath, String trustStorePwd, boolean useNonce) throws CertificateStatusException {
        logger.debug("inside getCertificateStatus for [vaURL=" + vaURL + "], [useNonce=" + useNonce + "]");
        if (null != requestorCerts && null != requestorPK) {
            this.signOCSPRequest = true;
        }
        if ((null == vaURL || "".equals(vaURL)) && (vaURL = this.getOcspAccessMethod(certToCheck)) == null) {
            throw new CertificateStatusException("Failed to getCertificateStatus. Input vaURL [" + vaURL + "] is invalid.");
        }
        try {
            new URL(vaURL);
        }
        catch (MalformedURLException mue) {
            throw new CertificateStatusException("Failed to getCertificateStatus. Input vaURL is malformed.");
        }
        if (null == certToCheck) {
            throw new CertificateStatusException("Failed to getCertificateStatus. Input X509Certificate certToCheck is null.");
        }
        byte[] nonceval = null;
        if (useNonce) {
            nonceval = SecureRandomGenerator.getSecureRandom();
        }
        byte[] ocspResponse = null;
        try {
            DHCConfig dhcConfig = new DHCConfig();
            dhcConfig.setProxyHost(proxyHost);
            dhcConfig.setProxyPort(proxyPort);
            dhcConfig.setTrustStoreType("JKS");
            dhcConfig.setTrustStorePath(trustStorePath);
            dhcConfig.setTrustStorePass(trustStorePwd);
            dhcConfig.setUrl(vaURL);
            dhcConfig.setSocketTimeout((int)timoutInMills);
            dhcConfig.setProxyUser(proxyUser);
            dhcConfig.setProxyPass(proxyPwd);
            ArrayList<NameValuePair> headers = new ArrayList<NameValuePair>();
            headers.add(new NameValuePair("Content-Type", "application/ocsp-request"));
            headers.add(new NameValuePair("Accept", "application/ocsp-response"));
            OCSPReq ocspRequest = this.createOCSPRequest(requestorCerts, requestorPK, certToCheck, issuerCert, nonceval, extensions);
            DHCClient dhc = new DHCClient();
            DHCResponse dhcResponse = dhc.post(dhcConfig, ocspRequest.getEncoded(), headers);
            if (dhcResponse.getStatus() >= 400) {
                throw new CertificateStatusException(dhcResponse.getStatus() + ": " + dhcResponse.getStatusText() + ": " + dhcResponse.getContent());
            }
            ocspResponse = dhcResponse.getContentBytes();
        }
        catch (DHCException | IOException e) {
            throw new CertificateStatusException("Failed to getCertificateStatus. Communication to [" + vaURL + "] failed. Reason: " + e.getMessage());
        }
        return this.parseAndVerifyOCSPResponse(ocspResponse, nonceval, certToCheck, extensions);
    }

    public void verifyBasicOCSPResponse(byte[] bOcso, X509Certificate certToCheck, List extensions, OCSPData responseData) throws CertificateStatusException {
        SingleResp[] singleResponses;
        BasicOCSPResp br = null;
        X509CertificateHolder[] certs = null;
        try {
            BasicOCSPResponse b = BasicOCSPResponse.getInstance((Object)ASN1Util.byteArrayToDer(bOcso));
            br = new BasicOCSPResp(b);
        }
        catch (Exception e) {
            throw new CertificateStatusException("verifyBasicOCSPResponse failed. Failed to parse BasicOCSPResponse: " + e.getMessage());
        }
        try {
            certs = br.getCerts();
        }
        catch (Exception e) {
            throw new CertificateStatusException("verifyBasicOCSPResponse failed. Failed to get Certs from BasicOCSPResponse: " + e.getMessage());
        }
        X509Certificate vacert = null;
        if (null != certs) {
            try {
                JcaX509CertificateConverter jcaX509CertificateConverter = new JcaX509CertificateConverter();
                jcaX509CertificateConverter.setProvider("BC");
                for (int i = 0; i < certs.length; ++i) {
                    vacert = jcaX509CertificateConverter.getCertificate(certs[i]);
                }
                if (null != vacert) {
                    JcaContentVerifierProviderBuilder verifierProviderBuilder = new JcaContentVerifierProviderBuilder();
                    verifierProviderBuilder.setProvider("BC");
                    if (!br.isSignatureValid(verifierProviderBuilder.build(vacert.getPublicKey()))) {
                        throw new CertificateStatusException("verifyBasicOCSPResponse failed. BasicOCSPReponse signature did not verify: ");
                    }
                }
            }
            catch (Exception ee) {
                throw new CertificateStatusException("verifyBasicOCSPResponse failed. BasicOCSPReponse signature did not verify: " + ee.getMessage());
            }
        }
        if (null == (singleResponses = br.getResponses())) {
            throw new CertificateStatusException("Did not get valid response from VA. SingleResponses is null");
        }
        CertificateID certId = singleResponses[0].getCertID();
        if (!certToCheck.getSerialNumber().toString().equals(certId.getSerialNumber().toString())) {
            throw new CertificateStatusException("Failed to get CertificateStatus. Mismatch between X509 serialnumbers.");
        }
        byte[] signerIssuerNH = null;
        try {
            byte[] respIssuerNameHash = certId.getIssuerNameHash();
            signerIssuerNH = this.getNameHash(Certificate.getInstance((Object)ASN1Util.byteArrayToDer(certToCheck.getEncoded())).getIssuer());
            if (!OCSPRequestor.matches(respIssuerNameHash, signerIssuerNH)) {
                throw new CertificateStatusException("Failed to get CertificateStatus. Mismatch in X509 IssuerNamehash between certificate to check and OCSP SingleResponse CertID.");
            }
        }
        catch (CertificateStatusException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new CertificateStatusException("Failed to validate OCSP Response. Failed to parse input X509 certificate to check");
        }
        CertificateStatus cs = singleResponses[0].getCertStatus();
        responseData.setNextUpdate(singleResponses[0].getNextUpdate());
        responseData.setThisUpdate(singleResponses[0].getThisUpdate());
        responseData.setProducedAt(br.getProducedAt());
        if (cs == null) {
            responseData.setCertificateStatus(0);
        } else {
            if (cs instanceof RevokedStatus) {
                RevokedStatus rs = (RevokedStatus)cs;
                responseData.setCertificateStatus(1);
                responseData.setRevokeReason(this.getRevokeReason(rs.getRevocationReason()));
                responseData.setRevocationTime(rs.getRevocationTime());
                return;
            }
            if (cs instanceof UnknownStatus) {
                responseData.setCertificateStatus(2);
                return;
            }
        }
        if (null != extensions && !extensions.isEmpty() && singleResponses[0].hasExtensions()) {
            for (int i = 0; i < extensions.size(); ++i) {
                String extensionoid = (String)extensions.get(i);
                Extension ext = singleResponses[0].getExtension(new ASN1ObjectIdentifier(extensionoid));
                if (ext != null) {
                    try {
                        ASN1Primitive dob = this.makeObj(ext.getExtnValue().getOctets());
                        responseData.addExtension(extensionoid, dob.toString());
                    }
                    catch (Exception e) {
                        responseData.addExtension(extensionoid, "EXTERR:" + e.getMessage());
                    }
                    continue;
                }
                responseData.addExtension(extensionoid, null);
            }
        }
    }

    private ASN1Primitive makeObj(byte[] encoding) throws IOException {
        if (encoding == null) {
            return null;
        }
        ByteArrayInputStream bIn = new ByteArrayInputStream(encoding);
        ASN1InputStream aIn = new ASN1InputStream((InputStream)bIn);
        return aIn.readObject();
    }

    private static boolean matches(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    private byte[] getAuthorityKeyIdentifier(X509Certificate certToCheck, X509Certificate issuer) throws CertificateStatusException {
        if (null != issuer) {
            try {
                PublicKey issuerKey = issuer.getPublicKey();
                ASN1InputStream aIn = new ASN1InputStream(issuerKey.getEncoded());
                SubjectPublicKeyInfo info = SubjectPublicKeyInfo.getInstance((Object)aIn.readObject());
                byte[] subjectPubKeyInfoHash = HashUtil.hash(info.getPublicKeyData().getBytes(), "SHA-1");
                DEROctetString issuerKeyHash = new DEROctetString(subjectPubKeyInfoHash);
                return issuerKeyHash.getOctets();
            }
            catch (Throwable t) {
                throw new CertificateStatusException("Failed to getAuthorityKeyIdentifier. Hashing SubjectPublicKeyInfo PublicKeyData failed: " + t.getMessage());
            }
        }
        Certificate certStruct = null;
        try {
            certStruct = Certificate.getInstance((Object)ASN1Util.byteArrayToDer(certToCheck.getEncoded()));
        }
        catch (Exception e) {
            throw new CertificateStatusException("Failed to getAuthorityKeyIdentifier. Unable to parse X509Certificate to check");
        }
        Extensions exts = certStruct.getTBSCertificate().getExtensions();
        if (null == exts) {
            throw new CertificateStatusException("Unable to get AuthorityKeyIdentifier from Certificate to check. Certificate has no extensions");
        }
        Extension ext = exts.getExtension(Extension.authorityKeyIdentifier);
        if (null == ext) {
            throw new CertificateStatusException("Unable to get AuthorityKeyIdentifier from Certificate to check. AuthorityKeyIdentifier extension not present");
        }
        try {
            ASN1Sequence seq = (ASN1Sequence)ASN1Util.byteArrayToDer(ext.getExtnValue().getOctets());
            AuthorityKeyIdentifier aki = AuthorityKeyIdentifier.getInstance((Object)seq);
            return aki.getKeyIdentifier();
        }
        catch (Exception e) {
            throw new CertificateStatusException("Unable to get AuthorityKeyIdentifier from Certificate to check. Unable to get Extension bytes");
        }
    }

    private String getOcspAccessMethod(X509Certificate certToCheck) throws CertificateStatusException {
        Certificate certStruct = null;
        try {
            certStruct = Certificate.getInstance((Object)((ASN1Sequence)ASN1Util.byteArrayToDer(certToCheck.getEncoded())));
        }
        catch (Exception e) {
            throw new CertificateStatusException("Failed to getOcspAccessMethod. Unable to parse X509Certificate to check");
        }
        Extensions exts = certStruct.getTBSCertificate().getExtensions();
        if (null == exts) {
            throw new CertificateStatusException("Unable to get AuthorityInfoAccess from Certificate to check. Certificate has no extensions");
        }
        Extension ext = exts.getExtension(Extension.authorityInfoAccess);
        if (null == ext) {
            throw new CertificateStatusException("Unable to get AuthorityInfoAccess from Certificate to check. AuthorityInfoAccess extension not present");
        }
        ASN1Sequence seq = null;
        try {
            seq = (ASN1Sequence)ASN1Util.byteArrayToDer(ext.getExtnValue().getOctets());
        }
        catch (Exception e) {
            throw new CertificateStatusException("Unable to get getOcspAccessMethod from Certificate to check. Unable to get Extension bytes");
        }
        AuthorityInformationAccess aia = AuthorityInformationAccess.getInstance((Object)seq);
        AccessDescription[] descs = aia.getAccessDescriptions();
        for (int i = 0; i < descs.length; ++i) {
            DERIA5String ia5Str;
            if (!descs[i].getAccessMethod().equals((Object)X509ObjectIdentifiers.ocspAccessMethod) || descs[i].getAccessLocation().getTagNo() != 6 || null == (ia5Str = (DERIA5String)descs[i].getAccessLocation().getName())) continue;
            return ia5Str.getString();
        }
        return null;
    }

    private OCSPData parseAndVerifyOCSPResponse(byte[] ocspResponseBytes, byte[] nonceVal, X509Certificate certToCheck, List extensions) throws CertificateStatusException {
        OCSPResp resp = null;
        OCSPData responseData = new OCSPData();
        try {
            resp = new OCSPResp(ocspResponseBytes);
        }
        catch (IOException ioe) {
            throw new CertificateStatusException("Failed to parseOCSPResponse. Reason: " + ioe.getMessage());
        }
        byte[] basicocspresp = null;
        if (resp.getStatus() != 0) {
            String reason = this.getFailResponseReason(resp.getStatus());
            throw new CertificateStatusException("OCSPResponse is not valid. Status [" + resp.getStatus() + "]. Reason [" + reason + "]");
        }
        BasicOCSPResp br = null;
        try {
            if (!(resp.getResponseObject() instanceof BasicOCSPResp)) {
                throw new CertificateStatusException("Failed to parse OCSPResponse. OCSPresponse responseObject is not a BasicOCSPResponse as expected");
            }
            br = (BasicOCSPResp)resp.getResponseObject();
            basicocspresp = br.getEncoded();
            responseData.setBasicOCSPResponse(basicocspresp);
            responseData.setProducedAt(br.getProducedAt());
        }
        catch (Exception oe) {
            throw new CertificateStatusException("Failed to parse OCSPResponse. OCSPresponse responseObject does not hold a valid BasicOCSPResponse");
        }
        if (null != nonceVal) {
            logger.debug("nonce is sent in request");
            Extension nonce = br.getExtension(new ASN1ObjectIdentifier("1.3.6.1.5.5.7.48.1.2"));
            if (nonce == null) {
                logger.info("nonce is missing in response for " + certToCheck.getIssuerDN());
            } else {
                byte[] buf = nonce.getExtnValue().getOctets();
                if (!OCSPRequestor.matches(nonceVal, buf)) {
                    logger.debug("nonce is not matched");
                    throw new CertificateStatusException("Failed to parse OCSPResponse. Nonce extesion values do not match");
                }
                logger.debug("nonce is matched");
            }
        } else {
            logger.debug("nonce is NOT sent in request");
        }
        this.verifyBasicOCSPResponse(basicocspresp, certToCheck, extensions, responseData);
        return responseData;
    }

    private String getFailResponseReason(int responseStatus) {
        String reason = "Not Available";
        if (responseStatus == 2) {
            reason = "INTERNAL_ERROR";
        } else if (responseStatus == 1) {
            reason = "MALFORMED_REQUEST";
        } else if (responseStatus == 3) {
            reason = "TRY_LATER";
        } else if (responseStatus == 6) {
            reason = "UNAUTHORIZED";
        } else if (responseStatus == 5) {
            reason = "SIG_REQUIRED";
        }
        return reason;
    }

    private String getRevokeReason(int revokeStatus) {
        String reason = "Not Available";
        if (revokeStatus == 10) {
            reason = "aACompromise";
        } else if (revokeStatus == 3) {
            reason = "affiliationChanged";
        } else if (revokeStatus == 2) {
            reason = "cACompromise";
        } else if (revokeStatus == 6) {
            reason = "certificateHold ";
        } else if (revokeStatus == 5) {
            reason = "cessationOfOperation";
        } else if (revokeStatus == 1) {
            reason = "keyCompromise";
        } else if (revokeStatus == 9) {
            reason = "privilegeWithdrawn";
        } else if (revokeStatus == 8) {
            reason = "removeFromCRL";
        } else if (revokeStatus == 4) {
            reason = "superseded";
        } else if (revokeStatus == 0) {
            reason = "unspecified";
        }
        return reason;
    }

    private boolean isOCSPSignedCertValid(X509Certificate signerCert, BasicOCSPResp ocspRsp) {
        SingleResp singleOCSPResp = ocspRsp.getResponses()[0];
        CertificateID certid = singleOCSPResp.getCertID();
        BigInteger ocspSerial = certid.getSerialNumber();
        return signerCert.getSerialNumber().equals(ocspSerial);
    }

    private OCSPReq createOCSPRequest(X509Certificate[] requestorChain, PrivateKey requestorPK, X509Certificate certToCheck, X509Certificate issuer, byte[] nonceValue, List extensions) throws CertificateStatusException {
        OCSPReq req;
        try {
            int i;
            String m_txtSerial;
            Certificate certStruct;
            try {
                certStruct = Certificate.getInstance((Object)ASN1Util.byteArrayToDer(certToCheck.getEncoded()));
            }
            catch (Exception e) {
                throw new CertificateStatusException("Failed to createOCSPRequest. Unable to parse X509Certificate to check");
            }
            byte[] m_keyHash = this.getAuthorityKeyIdentifier(certToCheck, issuer);
            byte[] m_nameHash = null;
            try {
                m_nameHash = this.getNameHash(certStruct.getIssuer());
            }
            catch (Exception e) {
                throw new CertificateStatusException("Failed to createOCSPRequest. Getting IssuerName hash failed. Reason: " + e.getMessage());
            }
            OCSPReqBuilder gen = new OCSPReqBuilder();
            String sserial = m_txtSerial = certStruct.getSerialNumber().getValue().toString(10);
            int radix = 10;
            if (sserial.startsWith("0x")) {
                sserial = sserial.substring(2);
                radix = 16;
            }
            BigInteger serial = new BigInteger(sserial, radix);
            CertID certId = new CertID(new AlgorithmIdentifier(X509ObjectIdentifiers.id_SHA1), (ASN1OctetString)new DEROctetString(m_nameHash), (ASN1OctetString)new DEROctetString(m_keyHash), new ASN1Integer(serial));
            gen.addRequest(new CertificateID(certId));
            if (null != nonceValue) {
                ASN1EncodableVector extVec = new ASN1EncodableVector();
                extVec.add((ASN1Encodable)this.buildExtension(new ASN1ObjectIdentifier("1.3.6.1.5.5.7.48.1.2"), false, (ASN1OctetString)new DEROctetString(nonceValue)));
                if (null != extensions && !extensions.isEmpty()) {
                    for (i = 0; i < extensions.size(); ++i) {
                        extVec.add((ASN1Encodable)this.buildExtension(new ASN1ObjectIdentifier((String)extensions.get(i)), false, (ASN1OctetString)new DEROctetString((ASN1Encodable)DERNull.INSTANCE)));
                    }
                }
                if (extVec.size() > 0) {
                    DERSequence extSeq = new DERSequence(extVec);
                    Extensions extens = Extensions.getInstance((Object)extSeq);
                    gen.setRequestExtensions(extens);
                }
            }
            if (this.signOCSPRequest) {
                X509CertificateHolder[] certChainHolders = new X509CertificateHolder[requestorChain.length];
                for (i = 0; i < requestorChain.length; ++i) {
                    certChainHolders[i] = new JcaX509CertificateHolder(requestorChain[i]);
                }
                X509Certificate requestorCert = requestorChain[0];
                gen.setRequestorName(new GeneralName(4, requestorCert.getSubjectX500Principal().getName()));
                req = gen.build(new JcaContentSignerBuilder("SHA256withRSA").setProvider("BC").build(requestorPK), certChainHolders);
            } else {
                req = gen.build();
            }
        }
        catch (IOException | IllegalArgumentException | CertificateEncodingException | CertificateStatusException | OCSPException | OperatorCreationException oe) {
            String errmsg = "Failed to generate signed OCSPRequest. Reason: " + oe.getMessage();
            if (!this.signOCSPRequest) {
                errmsg = "Failed to generate OCSPRequest. Reason: " + oe.getMessage();
            }
            throw new CertificateStatusException(errmsg);
        }
        return req;
    }

    private byte[] getNameHash(X500Name subject) throws Exception {
        if (subject == null) {
            throw new Exception("Unable to calculate OCSP name hash, Issuer X509Name is null");
        }
        byte[] nameHash = HashUtil.hash(ASN1Util.derToByteArray(subject.toASN1Primitive()), "SHA-1");
        return nameHash;
    }

    private DERSequence buildExtension(ASN1ObjectIdentifier oid, boolean critical, ASN1OctetString value) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)oid);
        v.add((ASN1Encodable)(critical ? ASN1Boolean.TRUE : ASN1Boolean.FALSE));
        v.add((ASN1Encodable)value);
        return new DERSequence(v);
    }
}

