/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.bc.cryptlib.ocsp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import no.bbs.tt.bc.cryptlib.ocsp.OCSPUtil;
import no.bbs.tt.bc.cryptlib.ocsp.SingleResponseObject;
import no.bbs.tt.bc.cryptlib.util.ASN1Util;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import org.bouncycastle.asn1.ocsp.OCSPResponse;
import org.bouncycastle.asn1.ocsp.OCSPResponseStatus;
import org.bouncycastle.asn1.ocsp.ResponderID;
import org.bouncycastle.asn1.ocsp.ResponseData;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.RespID;

public class OCSPResponseGenerator {
    private List<SingleResponseObject> list = new ArrayList<SingleResponseObject>();
    private Extensions responseExtensions = null;
    private RespID responderID;

    public OCSPResponseGenerator(RespID responderID) {
        this.responderID = responderID;
    }

    public OCSPResponseGenerator(PublicKey key) throws OCSPException {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA1");
            ASN1InputStream aIn = new ASN1InputStream(key.getEncoded());
            SubjectPublicKeyInfo info = SubjectPublicKeyInfo.getInstance((Object)aIn.readObject());
            digest.update(info.getPublicKeyData().getBytes());
            DEROctetString keyHash = new DEROctetString(digest.digest());
            this.responderID = new RespID(new ResponderID((ASN1OctetString)keyHash));
        }
        catch (Exception e) {
            throw new OCSPException("problem creating ID: " + e, (Throwable)e);
        }
    }

    public byte[] generateErrorOCSPResponse(int errorstatus) throws IOException {
        OCSPResp ocsprsp = new OCSPResp(new OCSPResponse(new OCSPResponseStatus(errorstatus), null));
        return ocsprsp.getEncoded();
    }

    public BasicOCSPResp generateResponse(String signatureName, PrivateKey key, X509Certificate[] chain, Date producedAt, String provider, SecureRandom random) throws OCSPException, NoSuchProviderException {
        ASN1ObjectIdentifier signingAlgorithm;
        Iterator<SingleResponseObject> it = this.list.iterator();
        try {
            signingAlgorithm = OCSPUtil.getAlgorithmOID(signatureName);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("unknown signing algorithm specified");
        }
        ASN1EncodableVector responses = new ASN1EncodableVector();
        while (it.hasNext()) {
            try {
                responses.add((ASN1Encodable)it.next().toResponse());
            }
            catch (Exception e) {
                throw new OCSPException("exception creating Request", (Throwable)e);
            }
        }
        ResponseData tbsResp = new ResponseData(ResponderID.getInstance((Object)this.responderID), (ASN1GeneralizedTime)new DERGeneralizedTime(producedAt), (ASN1Sequence)new DERSequence(responses), this.responseExtensions);
        Signature sig = null;
        try {
            sig = Signature.getInstance(signatureName, provider);
            if (random != null) {
                sig.initSign(key, random);
            } else {
                sig.initSign(key);
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new OCSPException("exception creating signature: " + e, (Throwable)e);
        }
        catch (InvalidKeyException e) {
            throw new OCSPException("exception creating signature: " + e, (Throwable)e);
        }
        DERBitString bitSig = null;
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dOut = new DEROutputStream((OutputStream)bOut);
            dOut.writeObject((ASN1Encodable)tbsResp);
            sig.update(bOut.toByteArray());
            bitSig = new DERBitString(sig.sign());
        }
        catch (Exception e) {
            throw new OCSPException("exception processing TBSRequest: " + e, (Throwable)e);
        }
        AlgorithmIdentifier sigAlgId = OCSPUtil.getSigAlgID(signingAlgorithm);
        if (chain != null && chain.length > 0) {
            ASN1EncodableVector v = new ASN1EncodableVector();
            try {
                for (int i = 0; i != chain.length; ++i) {
                    v.add((ASN1Encodable)Certificate.getInstance((Object)((ASN1Sequence)ASN1Util.byteArrayToDer(chain[i].getEncoded()))));
                }
            }
            catch (IOException e) {
                throw new OCSPException("error processing certs", (Throwable)e);
            }
            catch (CertificateEncodingException e) {
                throw new OCSPException("error encoding certs", (Throwable)e);
            }
            return new BasicOCSPResp(new BasicOCSPResponse(tbsResp, sigAlgId, bitSig, (ASN1Sequence)new DERSequence(v)));
        }
        return new BasicOCSPResp(new BasicOCSPResponse(tbsResp, sigAlgId, bitSig, null));
    }

    public void addResponse(CertificateID certID, CertificateStatus certStatus) {
        this.list.add(new SingleResponseObject(certID, certStatus, new Date(), null, null));
    }

    public void addResponse(CertificateID certID, CertificateStatus certStatus, Extensions singleExtensions) {
        this.list.add(new SingleResponseObject(certID, certStatus, new Date(), null, singleExtensions));
    }

    public void addResponse(CertificateID certID, CertificateStatus certStatus, Date nextUpdate, Extensions singleExtensions) {
        this.list.add(new SingleResponseObject(certID, certStatus, new Date(), nextUpdate, singleExtensions));
    }

    public void addResponse(CertificateID certID, CertificateStatus certStatus, Date thisUpdate, Date nextUpdate, Extensions singleExtensions) {
        this.list.add(new SingleResponseObject(certID, certStatus, thisUpdate, nextUpdate, singleExtensions));
    }

    public void setResponseExtensions(Extensions responseExtensions) {
        this.responseExtensions = responseExtensions;
    }
}

