/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.bc.cryptlib.pem;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.bouncycastle.util.encoders.Base64;

public class PEMConverter
extends BufferedReader {
    public PEMConverter(Reader reader) {
        super(reader);
    }

    public byte[] readObject() throws Exception {
        try {
            String line;
            while ((line = this.readLine()) != null) {
                if (line.indexOf("-----BEGIN CERTIFICATE REQUEST") != -1) {
                    return this.readCertificateRequest("-----END CERTIFICATE REQUEST");
                }
                if (line.indexOf("-----BEGIN NEW CERTIFICATE REQUEST") != -1) {
                    return this.readCertificateRequest("-----END NEW CERTIFICATE REQUEST");
                }
                if (line.indexOf("-----BEGIN CERTIFICATE") == -1) continue;
                return this.readCertificateRequest("-----END CERTIFICATE");
            }
        }
        catch (IOException e) {
            throw new Exception("IO exception occured reading from stream: " + e.getMessage());
        }
        return null;
    }

    private byte[] readBytes(String endMarker) throws IOException {
        String line;
        StringBuffer buf = new StringBuffer();
        while ((line = this.readLine()) != null && line.indexOf(endMarker) == -1) {
            buf.append(line.trim());
        }
        if (line == null) {
            throw new IOException(endMarker + " not found");
        }
        return Base64.decode((byte[])buf.toString().getBytes("UTF-8"));
    }

    private byte[] readCertificateRequest(String endMarker) throws Exception {
        try {
            return this.readBytes(endMarker);
        }
        catch (IOException e) {
            throw new Exception("Problem parsing cert: " + e.getMessage());
        }
    }
}

