/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.bc.cryptlib.pem;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.util.encoders.Base64;

public class PEMWriter
extends BufferedWriter {
    public PEMWriter(Writer out) {
        super(out);
    }

    private void writeEncoded(byte[] bytes) throws Exception {
        char[] buf = new char[64];
        bytes = Base64.encode((byte[])bytes);
        for (int i = 0; i < bytes.length; i += buf.length) {
            int index;
            for (index = 0; index != buf.length && i + index < bytes.length; ++index) {
                buf[index] = (char)bytes[i + index];
            }
            try {
                this.write(buf, 0, index);
                this.newLine();
                continue;
            }
            catch (IOException e) {
                throw new Exception("IO exception occured: " + e.getMessage());
            }
        }
    }

    public void writeObject(Object o) throws Exception {
        String type;
        byte[] encoding = null;
        if (o instanceof X509Certificate) {
            type = "CERTIFICATE";
            try {
                encoding = ((X509Certificate)o).getEncoded();
            }
            catch (CertificateEncodingException e) {
                throw new Exception("Cannot encode object: " + e.getMessage());
            }
        } else if (o instanceof X509CRL) {
            type = "X509 CRL";
            try {
                encoding = ((X509CRL)o).getEncoded();
            }
            catch (CRLException e) {
                throw new Exception("Cannot encode object: " + e.getMessage());
            }
        } else {
            if (o instanceof KeyPair) {
                this.writeObject(((KeyPair)o).getPrivate());
                return;
            }
            if (o instanceof PublicKey) {
                type = "PUBLIC KEY";
                encoding = ((PublicKey)o).getEncoded();
            } else if (o instanceof ContentInfo) {
                type = "PKCS7";
                try {
                    encoding = ((ContentInfo)o).getEncoded("DER");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                throw new Exception("unknown object passed - can't encode.");
            }
        }
        this.writeHeader(type);
        this.writeEncoded(encoding);
        this.writeFooter(type);
    }

    private void writeHeader(String type) throws Exception {
        try {
            this.write("-----BEGIN " + type + "-----");
            this.newLine();
        }
        catch (IOException e) {
            throw new Exception("IO exception occured: " + e.getMessage());
        }
    }

    private void writeFooter(String type) throws Exception {
        try {
            this.write("-----END " + type + "-----");
            this.newLine();
        }
        catch (IOException e) {
            throw new Exception("IO exception occured: " + e.getMessage());
        }
    }
}

