/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.bc.cryptlib.pkcs10;

import java.security.KeyPair;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import no.bbs.tt.bc.cryptlib.util.BCCryptoLoader;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1UTCTime;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERGeneralString;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.PKCS10CertificationRequestBuilder;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;

public class PKCS10Builder {
    private X500Name subjectDN;
    private KeyPair signerPair = null;
    private String signHashAlgo = "SHA256withRSA";
    private final Map<ASN1ObjectIdentifier, ASN1Primitive> certributes = new HashMap<ASN1ObjectIdentifier, ASN1Primitive>();

    public PKCS10Builder() {
        BCCryptoLoader.registerBCProvider();
    }

    public PKCS10Builder setSubjectDN(X500Name subjectDN) {
        this.subjectDN = subjectDN;
        return this;
    }

    public PKCS10Builder setKeypair(KeyPair signerPair) {
        this.signerPair = signerPair;
        return this;
    }

    public PKCS10Builder setSignHashAlgorithm(String hashAlgName) {
        this.signHashAlgo = hashAlgName;
        return this;
    }

    public PKCS10Builder addAttribute(ASN1ObjectIdentifier oid, String value) {
        this.certributes.put(oid, (ASN1Primitive)new DERGeneralString(value));
        return this;
    }

    public PKCS10Builder addAttribute(ASN1ObjectIdentifier oid, byte[] value) {
        this.certributes.put(oid, (ASN1Primitive)new DERBitString(value));
        return this;
    }

    public PKCS10Builder addAttribute(ASN1ObjectIdentifier oid, Date value) {
        this.certributes.put(oid, (ASN1Primitive)new ASN1UTCTime(value));
        return this;
    }

    public PKCS10Builder addAttribute(ASN1ObjectIdentifier oid, long value) {
        this.certributes.put(oid, (ASN1Primitive)new ASN1Integer(value));
        return this;
    }

    public PKCS10CertificationRequest build() throws IllegalArgumentException, OperatorCreationException {
        if (null == this.subjectDN) {
            throw new IllegalArgumentException("Subject DN missing");
        }
        if (null == this.signerPair) {
            throw new IllegalArgumentException("Signer key pair missing");
        }
        JcaPKCS10CertificationRequestBuilder p10Builder = new JcaPKCS10CertificationRequestBuilder(this.subjectDN, this.signerPair.getPublic());
        this.certributes.forEach((arg_0, arg_1) -> PKCS10Builder.lambda$build$0((PKCS10CertificationRequestBuilder)p10Builder, arg_0, arg_1));
        ContentSigner signer = new JcaContentSignerBuilder(this.signHashAlgo).build(this.signerPair.getPrivate());
        return p10Builder.build(signer);
    }

    private static /* synthetic */ void lambda$build$0(PKCS10CertificationRequestBuilder p10Builder, ASN1ObjectIdentifier k, ASN1Primitive v) {
        p10Builder.addAttribute(k, (ASN1Encodable)v);
    }
}

