/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.bc.cryptlib.pkcs7;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import no.bbs.tt.bc.cryptlib.pkcs7.PKCS7VerifierException;
import no.bbs.tt.bc.cryptlib.util.BCCryptoLoader;
import no.bbs.tt.bc.cryptlib.util.HashUtil;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.util.Selector;

public class PKCS7Verifier {
    public PKCS7Verifier() {
        BCCryptoLoader.registerBCProvider();
    }

    public void verify(byte[] data, byte[] signature) throws PKCS7VerifierException {
        CMSSignedData cmsSignedData = null;
        try {
            cmsSignedData = new CMSSignedData((CMSProcessable)new CMSProcessableByteArray(data), signature);
        }
        catch (CMSException ce) {
            throw new PKCS7VerifierException("Cannot recreate PKCS7 from input. Reason: " + ce.getMessage());
        }
        this.validate(cmsSignedData);
    }

    public void verify(String hashAlg, byte[] hash, byte[] signature) throws PKCS7VerifierException {
        if (null == hashAlg) {
            throw new PKCS7VerifierException("HashAlgorithm (DigestMethod) cannot be null");
        }
        if (null == hash || hash.length == 0) {
            throw new PKCS7VerifierException("Hash/digest cannot be null or empty");
        }
        if (null == signature || signature.length == 0) {
            throw new PKCS7VerifierException("Cannot verify empty or null signature");
        }
        HashMap<String, byte[]> mHash = new HashMap<String, byte[]>();
        hashAlg = HashUtil.mapHashAlgorithm(hashAlg);
        mHash.put(hashAlg, hash);
        CMSSignedData cmsSignedData = null;
        try {
            cmsSignedData = new CMSSignedData(mHash, signature);
        }
        catch (CMSException ce) {
            throw new PKCS7VerifierException("Cannot recreate CMS signed data from input. Reason: " + ce.getMessage());
        }
        this.validate(cmsSignedData);
    }

    private void validate(CMSSignedData cmsSignedData) throws PKCS7VerifierException {
        SignerInformationStore signers = cmsSignedData.getSignerInfos();
        ArrayList<String> issuerNames = new ArrayList<String>();
        HashMap<BigInteger, X509Certificate> certBySerialNumber = new HashMap<BigInteger, X509Certificate>();
        try {
            JcaX509CertificateConverter x509CertificateConverter = new JcaX509CertificateConverter().setProvider("BC");
            for (SignerInformation si : signers) {
                Collection certList = cmsSignedData.getCertificates().getMatches((Selector)si.getSID());
                for (X509CertificateHolder x509CertificateHolder : certList) {
                    X509Certificate certInSet = x509CertificateConverter.getCertificate(x509CertificateHolder);
                    certBySerialNumber.put(certInSet.getSerialNumber(), certInSet);
                    issuerNames.add(certInSet.getIssuerDN().getName());
                }
            }
        }
        catch (CertificateException x509CertificateConverter) {
        }
        catch (Exception x509CertificateConverter) {
            // empty catch block
        }
        if (certBySerialNumber.isEmpty()) {
            throw new PKCS7VerifierException("Cannot verify P7 without Signer Certificate collection");
        }
        Collection signerCollection = signers.getSigners();
        for (SignerInformation signerInformation : signerCollection) {
            IssuerAndSerialNumber iasn;
            SignerInfo signerInfo = signerInformation.toASN1Structure();
            SignerIdentifier sid = signerInfo.getSID();
            if (sid == null || !certBySerialNumber.containsKey((iasn = IssuerAndSerialNumber.getInstance((Object)sid.toASN1Primitive())).getSerialNumber().getValue())) continue;
            X509Certificate signerCert = (X509Certificate)certBySerialNumber.get(iasn.getSerialNumber().getValue());
            if (!iasn.getSerialNumber().getValue().equals(signerCert.getSerialNumber())) {
                throw new PKCS7VerifierException("SignerInfo SerialNumber [" + iasn.getSerialNumber() + "] differs from Certificate SerialNumber [" + signerCert.getSerialNumber() + "]");
            }
            if (!issuerNames.contains(iasn.getName().toString())) {
                throw new PKCS7VerifierException("SignerInfo IssuerName [" + iasn.getName().toString() + "] differs from Certificate IssuerDN [" + signerCert.getIssuerDN().getName() + "]");
            }
            try {
                Attribute otherSigCert;
                AttributeTable signedAttributes = signerInformation.getSignedAttributes();
                if (null != signedAttributes && (otherSigCert = signedAttributes.get(PKCSObjectIdentifiers.id_aa_ets_otherSigCert)) != null && !this.verifyOtherSigCertSignedAttribute(otherSigCert, signerCert)) {
                    throw new PKCS7VerifierException("Signer Certificate hash differ from the one in the signed attributes.");
                }
                try {
                    SignerInformationVerifier signerInformationVerifier = new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build(signerCert.getPublicKey());
                    if (signerInformation.verify(signerInformationVerifier)) continue;
                    throw new PKCS7VerifierException("Signature does not verify. Associated certificate does not match signature");
                }
                catch (OperatorCreationException e) {
                    throw new PKCS7VerifierException("Signature does not verify. Associated certificate does not match signature");
                }
            }
            catch (NoSuchAlgorithmException ex) {
                throw new PKCS7VerifierException("Unknown algorithm, " + ex.getMessage());
            }
            catch (NoSuchProviderException ex) {
                throw new PKCS7VerifierException("Inknown crypto provider, " + ex.getMessage());
            }
            catch (CertificateEncodingException ex) {
                throw new PKCS7VerifierException("Cannot parse signer certificate. Reason: " + ex.getMessage());
            }
            catch (CMSException ex) {
                throw new PKCS7VerifierException("SignerInformation and signer certificate public key mismatch, " + ex.getMessage());
            }
        }
    }

    private boolean verifyOtherSigCertSignedAttribute(Attribute otherSigCert, X509Certificate certificate) throws NoSuchAlgorithmException, NoSuchProviderException, CertificateEncodingException {
        ASN1Sequence sequence = (ASN1Sequence)otherSigCert.getAttrValues().getObjectAt(0).toASN1Primitive();
        Enumeration content = sequence.getObjects();
        while (content.hasMoreElements()) {
            Object o = content.nextElement();
            if (!(o instanceof ASN1Sequence)) continue;
            ASN1Sequence dataSeq = (ASN1Sequence)o;
            try {
                o = dataSeq.getObjectAt(1);
            }
            catch (Exception e) {
                o = dataSeq.getObjectAt(0);
                content = ((ASN1Sequence)o).getObjects();
                continue;
            }
            ASN1OctetString oct = (ASN1OctetString)o;
            byte[] p7SignSertSHA256Hash = oct.getOctets();
            MessageDigest md = MessageDigest.getInstance(NISTObjectIdentifiers.id_sha256.getId(), "BC");
            md.update(certificate.getEncoded());
            byte[] digestBytes = md.digest();
            if (Arrays.equals(p7SignSertSHA256Hash, digestBytes)) continue;
            return false;
        }
        return true;
    }
}

