/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.bc.cryptlib.pkcs7;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import no.bbs.tt.bc.cryptlib.pkcs7.CMSSignedHelper;
import no.bbs.tt.bc.cryptlib.pkcs7.DigOutputStream;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;

public class SignerInformation {
    PrivateKey key;
    X509Certificate cert;
    String digestOID;
    String encOID;
    CMSAttributeTableGenerator sAttr;
    CMSAttributeTableGenerator unsAttr;
    AttributeTable baseSignedTable;
    byte[] digest = null;

    SignerInformation(PrivateKey key, X509Certificate cert, String digestOID, String encOID) {
        this.key = key;
        this.cert = cert;
        this.digestOID = digestOID;
        this.encOID = encOID;
    }

    SignerInformation(PrivateKey key, X509Certificate cert, String digestOID, String encOID, CMSAttributeTableGenerator sAttr, CMSAttributeTableGenerator unsAttr, AttributeTable baseSigneTable) {
        this.key = key;
        this.cert = cert;
        this.digestOID = digestOID;
        this.encOID = encOID;
        this.sAttr = sAttr;
        this.unsAttr = unsAttr;
        this.baseSignedTable = baseSigneTable;
    }

    PrivateKey getKey() {
        return this.key;
    }

    X509Certificate getCertificate() {
        return this.cert;
    }

    String getDigestAlgOID() {
        return this.digestOID;
    }

    byte[] getDigestAlgParams() {
        return null;
    }

    String getEncryptionAlgOID() {
        return this.encOID;
    }

    CMSAttributeTableGenerator getSignedAttributes() {
        return this.sAttr;
    }

    CMSAttributeTableGenerator getUnsignedAttributes() {
        return this.unsAttr;
    }

    protected AlgorithmIdentifier getEncAlgorithmIdentifier(String encOid) {
        return new AlgorithmIdentifier(new ASN1ObjectIdentifier(encOid));
    }

    SignerInfo toSignerInfo(ASN1ObjectIdentifier contentType, CMSProcessable content, String sigProvider, boolean addDefaultAttributes) throws IOException, SignatureException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException, CertificateEncodingException, CMSException {
        AlgorithmIdentifier digAlgId = new AlgorithmIdentifier(new ASN1ObjectIdentifier(this.getDigestAlgOID()), (ASN1Encodable)new DERNull());
        AlgorithmIdentifier encAlgId = this.getEncAlgorithmIdentifier(this.getEncryptionAlgOID());
        String digestName = CMSSignedHelper.INSTANCE.getDigestAlgName(this.digestOID);
        String signatureName = digestName + "with" + CMSSignedHelper.INSTANCE.getEncryptionAlgName(this.encOID);
        Signature sig = CMSSignedHelper.INSTANCE.getSignatureInstance(signatureName, sigProvider);
        MessageDigest dig = CMSSignedHelper.INSTANCE.getDigestInstance(digestName, sigProvider);
        byte[] hash = null;
        if (content != null) {
            content.write((OutputStream)new DigOutputStream(dig));
            hash = dig.digest();
            this.digest = (byte[])hash.clone();
        }
        AttributeTable signed = this.baseSignedTable;
        ASN1Set signedAttr = this.getAttributeSet(signed);
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        if (signedAttr != null) {
            DEROutputStream dOut = new DEROutputStream((OutputStream)bOut);
            dOut.writeObject((ASN1Encodable)signedAttr);
        } else {
            content.write((OutputStream)bOut);
        }
        sig.initSign(this.key);
        sig.update(bOut.toByteArray());
        DEROctetString encDigest = new DEROctetString(sig.sign());
        Map parameters = this.getBaseParameters(contentType, digAlgId, hash);
        parameters.put("encryptedDigest", encDigest.getOctets().clone());
        AttributeTable unsigned = this.unsAttr != null ? this.unsAttr.getAttributes(Collections.unmodifiableMap(parameters)) : null;
        ASN1Set unsignedAttr = this.getAttributeSet(unsigned);
        X509Certificate cert = this.getCertificate();
        ByteArrayInputStream bIn = new ByteArrayInputStream(cert.getTBSCertificate());
        ASN1InputStream aIn = new ASN1InputStream((InputStream)bIn);
        TBSCertificateStructure tbs = TBSCertificateStructure.getInstance((Object)aIn.readObject());
        IssuerAndSerialNumber encSid = new IssuerAndSerialNumber(tbs.getIssuer(), tbs.getSerialNumber().getValue());
        return new SignerInfo(new SignerIdentifier(encSid), digAlgId, signedAttr, encAlgId, (ASN1OctetString)encDigest, unsignedAttr);
    }

    protected Map getBaseParameters(ASN1ObjectIdentifier contentType, AlgorithmIdentifier digAlgId, byte[] hash) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("contentType", contentType);
        param.put("digestAlgID", digAlgId);
        if (hash != null) {
            param.put("digest", hash.clone());
        }
        return param;
    }

    protected ASN1Set getAttributeSet(AttributeTable attr) {
        if (attr != null) {
            return new DERSet(attr.toASN1EncodableVector());
        }
        return null;
    }
}

