/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.bc.cryptlib.util;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import no.bbs.tt.bc.cryptlib.util.StringParseException;

public final class StringCodec {
    public static final String LINE_SEPARATOR_CRLF = "\r\n";
    public static final String LINE_SEPARATOR_CR = "\r";
    public static final String LINE_SEPARATOR_LF = "\n";
    private static final Charset UTF_8;
    private static final Charset LATIN_1;
    private static final char[] BASE_64_ALPHABET;
    private static final char BASE_64_PAD = '=';
    private static final boolean[] VALID_B_CHARACTER;
    private static final int[] BASE_64_VALUE;
    private static final boolean[] VALID_Q_CHARS;

    private StringCodec() {
    }

    public static String encodeAsEncodedWord(String str) {
        int length = str.length();
        int nonAscii = 0;
        int nonLatin1 = 0;
        for (int idx = 0; idx < length; ++idx) {
            char c = str.charAt(idx);
            if (c < ' ' || c > '~' || c == '\"') {
                ++nonAscii;
            }
            if (c <= '\u00ff') continue;
            ++nonLatin1;
        }
        if (nonAscii == 0) {
            return str;
        }
        Charset charset = nonLatin1 > 0 ? UTF_8 : LATIN_1;
        boolean base64 = nonAscii > length / 4;
        return StringCodec.encodeAsEncodedWord(str, charset, base64);
    }

    public static String encodeAsEncodedWord(String str, Charset charset, boolean base64) {
        byte[] bytes = StringCodec.getBytes(str, charset);
        StringBuffer sb = new StringBuffer();
        sb.append("=?");
        sb.append(charset.name());
        sb.append('?');
        sb.append(base64 ? (char)'B' : 'Q');
        sb.append('?');
        if (base64) {
            StringCodec.encodeB(sb, bytes, null);
        } else {
            StringCodec.encodeQ(sb, bytes);
        }
        sb.append("?=");
        return sb.toString();
    }

    public static String encodeB(byte[] bytes, String lineSeparator) {
        if (bytes.length == 0) {
            return "";
        }
        int count = (bytes.length + 2) / 3 * 4;
        if (lineSeparator != null) {
            count += (count + 75) / 76 * lineSeparator.length();
        }
        StringBuffer sb = new StringBuffer(count);
        StringCodec.encodeB(sb, bytes, lineSeparator);
        return sb.toString();
    }

    public static void encodeB(StringBuffer sb, byte[] bytes, String lineSeparator) {
        int i;
        if (bytes.length == 0) {
            return;
        }
        int length = bytes.length / 3 * 3;
        int idx = 0;
        int blocksWritten = 0;
        while (idx < length) {
            if (blocksWritten == 19) {
                blocksWritten = 0;
                sb.append(lineSeparator);
            }
            int b1 = bytes[idx++] & 0xFF;
            int b2 = bytes[idx++] & 0xFF;
            int b3 = bytes[idx++] & 0xFF;
            i = b1 << 16 | b2 << 8 | b3;
            sb.append(BASE_64_ALPHABET[i >> 18]);
            sb.append(BASE_64_ALPHABET[i >> 12 & 0x3F]);
            sb.append(BASE_64_ALPHABET[i >> 6 & 0x3F]);
            sb.append(BASE_64_ALPHABET[i & 0x3F]);
            if (lineSeparator == null) continue;
            ++blocksWritten;
        }
        int remainder = bytes.length - idx;
        if (remainder == 0) {
            return;
        }
        if (blocksWritten == 19) {
            blocksWritten = 0;
            sb.append(lineSeparator);
        }
        if (remainder == 2) {
            int b1 = bytes[idx++] & 0xFF;
            int b2 = bytes[idx++] & 0xFF;
            i = b1 << 16 | b2 << 8;
            sb.append(BASE_64_ALPHABET[i >> 18]);
            sb.append(BASE_64_ALPHABET[i >> 12 & 0x3F]);
            sb.append(BASE_64_ALPHABET[i >> 6 & 0x3F]);
            sb.append('=');
            return;
        }
        int i2 = (bytes[idx++] & 0xFF) << 16;
        sb.append(BASE_64_ALPHABET[i2 >> 18]);
        sb.append(BASE_64_ALPHABET[i2 >> 12 & 0x3F]);
        sb.append('=');
        sb.append('=');
    }

    public static String encodeQ(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        StringCodec.encodeQ(sb, bytes);
        return sb.toString();
    }

    public static void encodeQ(StringBuffer sb, byte[] bytes) {
        for (int idx = 0; idx < bytes.length; ++idx) {
            char b = (char)(bytes[idx] & 0xFF);
            if (b == ' ') {
                sb.append('_');
                continue;
            }
            if (b < VALID_Q_CHARS.length && VALID_Q_CHARS[b]) {
                sb.append(b);
                continue;
            }
            sb.append('=');
            sb.append(StringCodec.hexDigit(b >> 4));
            sb.append(StringCodec.hexDigit(b & 0xF));
        }
    }

    public static String tryDecodeEncodedWord(String str) {
        if (str == null) {
            throw new IllegalArgumentException();
        }
        if (!str.startsWith("=?") || !str.endsWith("?=")) {
            return str;
        }
        try {
            return StringCodec.decodeEncodedWord(str);
        }
        catch (StringParseException e) {
            return str;
        }
    }

    public static String decodeEncodedWord(String str) throws StringParseException {
        if (str == null) {
            throw new IllegalArgumentException();
        }
        if (!str.startsWith("=?") || !str.endsWith("?=")) {
            throw new StringParseException("Not an encoded word");
        }
        String x = str.substring(2, str.length() - 2);
        String[] parts = x.split("\\?", -1);
        if (parts.length != 3) {
            throw new StringParseException("Not an encoded word (" + parts.length + " parts)");
        }
        String charsetName = parts[0];
        int asteriskIdx = charsetName.indexOf(42);
        if (asteriskIdx != -1) {
            charsetName = charsetName.substring(0, asteriskIdx);
        }
        Charset charset = StringCodec.getCharset(charsetName);
        byte[] decoded = null;
        if (parts[1].equalsIgnoreCase("q")) {
            decoded = StringCodec.decodeQ(parts[2]);
        } else if (parts[1].equalsIgnoreCase("b")) {
            decoded = StringCodec.decodeB(parts[2]);
        } else {
            throw new StringParseException("Invalid encoding: " + parts[2]);
        }
        try {
            CharsetDecoder decoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
            return decoder.decode(ByteBuffer.wrap(decoded)).toString();
        }
        catch (CharacterCodingException e) {
            throw new StringParseException("Could not decode encoded word", e);
        }
    }

    public static byte[] decodeB(String str) throws StringParseException {
        if (str == null) {
            throw new IllegalArgumentException();
        }
        int len = str.length();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(len / 4 * 3);
        char[] ch = new char[4];
        int idx = 0;
        while (true) {
            int x;
            for (x = 0; x < 4; ++x) {
                do {
                    if (idx == len) {
                        if (x == 0) {
                            return baos.toByteArray();
                        }
                        throw new StringParseException("premature end of string");
                    }
                    ch[x] = str.charAt(idx++);
                } while (ch[x] > VALID_B_CHARACTER.length || !VALID_B_CHARACTER[ch[x]]);
            }
            if (ch[3] == '=') {
                if (ch[2] == '=') {
                    x = BASE_64_VALUE[ch[0]] << 18 | BASE_64_VALUE[ch[1]] << 12;
                    baos.write(x >> 16 & 0xFF);
                } else {
                    x = BASE_64_VALUE[ch[0]] << 18 | BASE_64_VALUE[ch[1]] << 12 | BASE_64_VALUE[ch[2]] << 6;
                    baos.write(x >> 16 & 0xFF);
                    baos.write(x >> 8 & 0xFF);
                }
                return baos.toByteArray();
            }
            x = BASE_64_VALUE[ch[0]] << 18 | BASE_64_VALUE[ch[1]] << 12 | BASE_64_VALUE[ch[2]] << 6 | BASE_64_VALUE[ch[3]];
            baos.write(x >> 16 & 0xFF);
            baos.write(x >> 8 & 0xFF);
            baos.write(x & 0xFF);
        }
    }

    public static byte[] decodeQ(String str) throws StringParseException {
        if (str == null) {
            throw new IllegalArgumentException();
        }
        int len = str.length();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(len);
        block4: for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c > '\u007f') {
                throw new StringParseException("Invalid char: " + c + " (" + c + ")");
            }
            switch (c) {
                case '=': {
                    if (i > len - 3) {
                        throw new StringParseException("Unterminated hex-sequence");
                    }
                    char h1 = str.charAt(++i);
                    char h2 = str.charAt(++i);
                    baos.write(StringCodec.fromHex(h1, h2));
                    continue block4;
                }
                case '_': {
                    baos.write(32);
                    continue block4;
                }
                default: {
                    baos.write(c);
                }
            }
        }
        return baos.toByteArray();
    }

    private static int fromHex(char h1, char h2) throws StringParseException {
        return StringCodec.fromHex(h1) << 4 | StringCodec.fromHex(h2);
    }

    private static int fromHex(char h) throws StringParseException {
        if (h >= '0' && h <= '9') {
            return h - 48;
        }
        if (h >= 'A' && h <= 'F') {
            return h - 65 + 10;
        }
        if (h >= 'a' && h <= 'f') {
            return h - 97 + 10;
        }
        throw new StringParseException("Invalid hex digit: " + h + " (" + h + ")");
    }

    private static Charset getCharset(String charsetName) throws StringParseException {
        try {
            return Charset.forName(charsetName);
        }
        catch (IllegalCharsetNameException e) {
            throw new StringParseException("Illegal charset: " + charsetName, e);
        }
        catch (UnsupportedCharsetException e) {
            throw new StringParseException("Unsupported charset: " + charsetName, e);
        }
    }

    private static byte[] getBytes(String str, Charset charset) {
        try {
            return str.getBytes(charset.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Invalid charset: " + charset);
        }
    }

    private static char hexDigit(int x) {
        return (char)((x &= 0xF) < 10 ? 48 + x : 65 + x - 10);
    }

    static {
        int i;
        UTF_8 = Charset.forName("UTF-8");
        LATIN_1 = Charset.forName("ISO-8859-1");
        BASE_64_ALPHABET = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        VALID_B_CHARACTER = new boolean[128];
        for (i = 0; i < VALID_B_CHARACTER.length; ++i) {
            StringCodec.VALID_B_CHARACTER[i] = false;
        }
        for (i = 0; i < BASE_64_ALPHABET.length; ++i) {
            StringCodec.VALID_B_CHARACTER[StringCodec.BASE_64_ALPHABET[i]] = true;
        }
        StringCodec.VALID_B_CHARACTER[61] = true;
        BASE_64_VALUE = new int[128];
        for (i = 0; i < BASE_64_ALPHABET.length; ++i) {
            StringCodec.BASE_64_VALUE[StringCodec.BASE_64_ALPHABET[i]] = i;
        }
        VALID_Q_CHARS = new boolean[128];
        for (i = 0; i < VALID_Q_CHARS.length; ++i) {
            StringCodec.VALID_Q_CHARS[i] = true;
        }
        for (i = 0; i <= 31; ++i) {
            StringCodec.VALID_Q_CHARS[i] = false;
        }
        StringCodec.VALID_Q_CHARS[127] = false;
        StringCodec.VALID_Q_CHARS[32] = false;
        StringCodec.VALID_Q_CHARS[61] = false;
        StringCodec.VALID_Q_CHARS[63] = false;
        StringCodec.VALID_Q_CHARS[95] = false;
        StringCodec.VALID_Q_CHARS[40] = false;
        StringCodec.VALID_Q_CHARS[41] = false;
        StringCodec.VALID_Q_CHARS[34] = false;
    }
}

