/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.bc.cryptlib.x509;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import no.bbs.tt.bc.cryptlib.util.ASN1Util;
import no.bbs.tt.bc.cryptlib.util.HashUtil;
import no.bbs.tt.bc.cryptlib.x509.X509ParserException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.TBSCertificate;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;

public class X509Parser {
    private X509Certificate cert = null;
    private Certificate bcX509 = null;
    protected static final String CERTIFICATE_POLICIES = Extension.certificatePolicies.getId();
    protected static final String BASIC_CONSTRAINTS = Extension.basicConstraints.getId();
    protected static final String POLICY_MAPPINGS = Extension.policyMappings.getId();
    protected static final String SUBJECT_ALTERNATIVE_NAME = Extension.subjectAlternativeName.getId();
    protected static final String NAME_CONSTRAINTS = Extension.nameConstraints.getId();
    protected static final String KEY_USAGE = Extension.keyUsage.getId();
    protected static final String INHIBIT_ANY_POLICY = Extension.inhibitAnyPolicy.getId();
    protected static final String ISSUING_DISTRIBUTION_POINT = Extension.issuingDistributionPoint.getId();
    protected static final String DELTA_CRL_INDICATOR = Extension.deltaCRLIndicator.getId();
    protected static final String POLICY_CONSTRAINTS = Extension.policyConstraints.getId();
    protected static final String FRESHEST_CRL = Extension.freshestCRL.getId();
    protected static final String CRL_DISTRIBUTION_POINTS = Extension.cRLDistributionPoints.getId();
    protected static final String AUTHORITY_KEY_IDENTIFIER = Extension.authorityKeyIdentifier.getId();
    public static final String KEYUSAGE_DIGITALSIGNATURE = "digitalsignature";
    public static final String KEYUSAGE_NONREPUDIATION = "nonrepudiation";
    public static final String KEYUSAGE_KEYENCIPHERMENT = "keyencipherment";
    public static final String KEYUSAGE_DATAENCIPHERMENT = "dataencipherment";
    public static final String KEYUSAGE_KEYAGREEMENT = "keyagreement";
    public static final String KEYUSAGE_KEYCERTSIGN = "keycertsign";
    public static final String KEYUSAGE_CRLSIGN = "crlsign";
    public static final String KEYUSAGE_ENCIPHERONLY = "encipheronly";
    public static final String KEYUSAGE_DECIPHERONLY = "decipheronly";
    public static final String EXT_KEYUSAGE_SERVERAUTH = "serverauth";
    public static final String EXT_KEYUSAGE_CLIENTAUTH = "clientauth";
    public static final String EXT_KEYUSAGE_CODESIGNING = "codesigning";
    public static final String EXT_KEYUSAGE_EMAILPROTECTION = "emailprotection";
    public static final String EXT_KEYUSAGE_MSSGC = "mssgc";
    public static final String EXT_KEYUSAGE_NSSGC = "nssgc";
    public static final String EXT_KEYUSAGE_OCSPSIGNING = "ocspsigning";
    public static final String EXT_KEYUSAGE_TIMESTAMPING = "timestamping";
    public static final ASN1ObjectIdentifier SERIAL_NUMBER = BCStyle.SN;
    public static final ASN1ObjectIdentifier COMMON_NAME = BCStyle.CN;
    public static final ASN1ObjectIdentifier ORGANISATIONAL_UNIT = BCStyle.OU;
    public static final String OCSP_RESPONSE_SIGNING = "1.3.6.1.5.5.7.3.9";

    public X509Parser(X509Certificate certificate) throws InstantiationException {
        if (null == certificate) {
            throw new InstantiationException("Failed to contruct no.bbs.tt.bc.crypto.x509.X509Parser. Input X509Certificate is null");
        }
        this.cert = certificate;
        try {
            this.bcX509 = Certificate.getInstance((Object)ASN1Util.byteArrayToDer(certificate.getEncoded()));
        }
        catch (Exception ioe) {
            throw new InstantiationException("Failed to contruct no.bbs.tt.bc.crypto.x509.X509Parser. Reason: " + ioe.getMessage());
        }
    }

    public String doFingerprint(String algorithm) throws Exception {
        byte[] certificateBytes = this.cert.getEncoded();
        StringBuffer buffer = new StringBuffer();
        MessageDigest md = MessageDigest.getInstance(algorithm);
        md.update(certificateBytes);
        byte[] digest = md.digest();
        for (int i = 0; i < digest.length; ++i) {
            int b;
            String hex;
            if (i != 0) {
                buffer.append(":");
            }
            if ((hex = Integer.toHexString(b = digest[i] & 0xFF)).length() == 1) {
                buffer.append("0");
            }
            buffer.append(hex);
        }
        return buffer.toString();
    }

    public String getNemIDPid() {
        return this.removePidColonFromPid();
    }

    public String getNemIDRid() {
        return this.removeRidColonFromPid();
    }

    private String removePidColonFromPid() {
        String serialNumber = this.extractSerialNumber();
        if (null != serialNumber && serialNumber.startsWith("PID:")) {
            return this.extractSerialNumber().substring("PID:".length());
        }
        return null;
    }

    private String removeRidColonFromPid() {
        String serialNumber = this.extractSerialNumber();
        if (null != serialNumber && serialNumber.indexOf("RID:") > -1) {
            return this.extractSerialNumber().substring(serialNumber.indexOf("RID:") + "RID:".length());
        }
        return null;
    }

    private String extractSerialNumber() {
        return this.getElementInX500Name(SERIAL_NUMBER);
    }

    public String getSubjectCommonName() {
        return this.getElementInX500Name(COMMON_NAME);
    }

    public boolean isNemIDYouthCertificate() {
        String ou = this.getOrganizationUnit();
        if (null == ou) {
            return false;
        }
        return ou.startsWith("Ung mellem 15 og 18");
    }

    public String getOrganizationUnit() {
        return this.getElementInX500Name(ORGANISATIONAL_UNIT);
    }

    public String getElementInX500Name(ASN1ObjectIdentifier element) {
        X500Name name = new X500Name(BCStyle.INSTANCE, this.cert.getSubjectDN().getName());
        ASN1Encodable elementValue = this.searchRDNFromArray(name.getRDNs(), element);
        if (elementValue == null) {
            return null;
        }
        return IETFUtils.valueToString((ASN1Encodable)elementValue);
    }

    public boolean hasNemIDPseudonym() {
        return "Pseudonym".equals(this.getSubjectCommonName());
    }

    public String getEmailAddress() {
        String email;
        block3: {
            email = null;
            try {
                Collection<List<?>> sans = this.cert.getSubjectAlternativeNames();
                if (sans == null) break block3;
                for (List<?> san : sans) {
                    if (san.size() != 2 || (Integer)san.get(0) != 1) continue;
                    email = (String)san.get(1);
                    break;
                }
            }
            catch (CertificateParsingException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return email;
    }

    public boolean[] getKeyUsage() {
        return this.cert.getKeyUsage();
    }

    public String getFingerPrint() {
        return null;
    }

    public String[] getKeyUsageNames() {
        ArrayList<String> b = new ArrayList<String>();
        boolean[] ku = this.getKeyUsage();
        if (ku[0]) {
            b.add(KEYUSAGE_DIGITALSIGNATURE);
        }
        if (ku[1]) {
            b.add(KEYUSAGE_NONREPUDIATION);
        }
        if (ku[2]) {
            b.add(KEYUSAGE_KEYENCIPHERMENT);
        }
        if (ku[3]) {
            b.add(KEYUSAGE_DATAENCIPHERMENT);
        }
        if (ku[4]) {
            b.add(KEYUSAGE_KEYAGREEMENT);
        }
        if (ku[5]) {
            b.add(KEYUSAGE_KEYCERTSIGN);
        }
        if (ku[6]) {
            b.add(KEYUSAGE_CRLSIGN);
        }
        if (ku[7]) {
            b.add(KEYUSAGE_ENCIPHERONLY);
        }
        if (ku[8]) {
            b.add(KEYUSAGE_DECIPHERONLY);
        }
        if (b.isEmpty()) {
            return null;
        }
        Object[] t = b.toArray();
        String[] res = new String[t.length];
        System.arraycopy(t, 0, res, 0, t.length);
        return res;
    }

    public String getCommonName() throws X509ParserException {
        try {
            TBSCertificate tbs = this.bcX509.getTBSCertificate();
            ASN1Encodable commonName = this.searchRDNFromArray(tbs.getSubject().getRDNs(), BCStyle.CN);
            if (commonName == null) {
                return null;
            }
            return IETFUtils.valueToString((ASN1Encodable)commonName);
        }
        catch (Exception ioe) {
            throw new X509ParserException("Failed to extract CommonName (CN) from X509Certificate. Reason: " + ioe.getMessage());
        }
    }

    public String getOrganizationName() throws X509ParserException {
        try {
            TBSCertificate tbs = this.bcX509.getTBSCertificate();
            ASN1Encodable orgName = this.searchRDNFromArray(tbs.getIssuer().getRDNs(), BCStyle.O);
            if (orgName == null) {
                return null;
            }
            return IETFUtils.valueToString((ASN1Encodable)orgName);
        }
        catch (Exception ioe) {
            throw new X509ParserException("Failed to extract OrganizationName from X509Certificate. Reason: " + ioe.getMessage());
        }
    }

    public String getCountry() throws X509ParserException {
        try {
            TBSCertificate tbs = this.bcX509.getTBSCertificate();
            if (null == tbs.getSubject()) {
                return null;
            }
            ASN1Encodable country = this.searchRDNFromArray(tbs.getSubject().getRDNs(), BCStyle.C);
            if (country == null) {
                return null;
            }
            return IETFUtils.valueToString((ASN1Encodable)country);
        }
        catch (Exception ioe) {
            throw new X509ParserException("Failed to extract Country (C) from X509Certificate IssuerDN. Reason: " + ioe.getMessage());
        }
    }

    public String getSubjectSerial() throws X509ParserException {
        try {
            TBSCertificate tbs = this.bcX509.getTBSCertificate();
            if (null == tbs) {
                return "NA";
            }
            ASN1Encodable subjectSerialNumber = this.searchRDNFromArray(tbs.getSubject().getRDNs(), BCStyle.SN);
            if (subjectSerialNumber == null) {
                return "NA";
            }
            return IETFUtils.valueToString((ASN1Encodable)subjectSerialNumber);
        }
        catch (Exception ioe) {
            throw new X509ParserException("Failed to extract SubjectSerial (SERIALNUMBER) from X509Certificate. Reason: " + ioe.getMessage());
        }
    }

    public String getRSAPublicKeySize() throws X509ParserException {
        PublicKey pub = this.cert.getPublicKey();
        if (pub.getAlgorithm().equalsIgnoreCase("RSA")) {
            if (null == ((RSAPublicKey)pub).getModulus()) {
                return null;
            }
            return "" + ((RSAPublicKey)pub).getModulus().bitLength();
        }
        throw new X509ParserException("Failed to extract RSAPublicKeySize from X509Certificate. Invalid PublicKey Algorithm (" + pub.getAlgorithm() + ")");
    }

    public String[] getPolicyIdentifiers() throws X509ParserException {
        ASN1Sequence certPolicies = (ASN1Sequence)X509Parser.getExtensionValue(this.cert, CERTIFICATE_POLICIES);
        if (certPolicies != null) {
            Enumeration e = certPolicies.getObjects();
            ArrayList<String> tmp = new ArrayList<String>();
            while (e.hasMoreElements()) {
                PolicyInformation pInfo = PolicyInformation.getInstance(e.nextElement());
                ASN1ObjectIdentifier pOid = pInfo.getPolicyIdentifier();
                tmp.add(pOid.getId());
            }
            if (tmp.isEmpty()) {
                return null;
            }
            Object[] t = tmp.toArray();
            String[] res = new String[t.length];
            System.arraycopy(t, 0, res, 0, t.length);
            return res;
        }
        return null;
    }

    protected static ASN1Primitive getExtensionValue(X509Extension ext, String oid) throws X509ParserException {
        byte[] bytes = ext.getExtensionValue(oid);
        if (bytes == null) {
            return null;
        }
        return X509Parser.getObject(oid, bytes);
    }

    private static ASN1Primitive getObject(String oid, byte[] ext) throws X509ParserException {
        try {
            ASN1InputStream aIn = new ASN1InputStream(ext);
            ASN1OctetString octs = (ASN1OctetString)aIn.readObject();
            aIn = new ASN1InputStream(octs.getOctets());
            return aIn.readObject();
        }
        catch (IOException e) {
            throw new X509ParserException("Exception processing extension " + oid + ": " + e.getMessage());
        }
    }

    public String getSubjectName() {
        return this.cert.getSubjectDN().getName();
    }

    public String getIssuerName() {
        return this.cert.getIssuerDN().getName();
    }

    public byte[] getAuthoriyKeyIdentifier() throws X509ParserException {
        Extension ext;
        Extensions exts = this.bcX509.getTBSCertificate().getExtensions();
        if (null != exts && (ext = exts.getExtension(Extension.authorityKeyIdentifier)) != null) {
            ASN1Sequence seq = null;
            try {
                seq = (ASN1Sequence)ASN1Util.byteArrayToDer(ext.getExtnValue().getOctets());
            }
            catch (IOException ioe) {
                throw new X509ParserException("Failed to extract AuthorityKeyIdentifier from X509Certificate. Invalid AuthorityKeyIdentifier Extension bytes in X509: " + ioe.getMessage());
            }
            AuthorityKeyIdentifier aki = AuthorityKeyIdentifier.getInstance((Object)seq);
            return aki.getKeyIdentifier();
        }
        return null;
    }

    public String[] getOCSPResponderURIs() throws X509ParserException {
        Extensions exts = this.bcX509.getTBSCertificate().getExtensions();
        if (null != exts) {
            Extension ext = exts.getExtension(Extension.authorityInfoAccess);
            if (ext != null) {
                ASN1Sequence seq = null;
                try {
                    seq = (ASN1Sequence)ASN1Util.byteArrayToDer(ext.getExtnValue().getOctets());
                }
                catch (IOException ioe) {
                    throw new X509ParserException("Failed to extract OCSPResponderURIs from X509Certificate. Invalid AuthorityInfoAccess Extension bytes in X509: " + ioe.getMessage());
                }
                AuthorityInformationAccess aia = AuthorityInformationAccess.getInstance((Object)seq);
                AccessDescription[] descs = aia.getAccessDescriptions();
                String[] responderURLS = new String[descs.length];
                for (int i = 0; i < descs.length; ++i) {
                    String m_txtUrl;
                    if (!descs[i].getAccessMethod().equals((Object)X509ObjectIdentifiers.ocspAccessMethod) || descs[i].getAccessLocation().getTagNo() != 6) continue;
                    DERIA5String ia5Str = (DERIA5String)descs[i].getAccessLocation().getName();
                    responderURLS[i] = m_txtUrl = ia5Str.getString();
                }
                return responderURLS;
            }
            return null;
        }
        return null;
    }

    public String getSerialNumberAsString() {
        return this.bcX509.getSerialNumber().getValue().toString(10);
    }

    public BigInteger getSerial() {
        String sserial = this.getSerialNumberAsString();
        int radix = 10;
        if (sserial.startsWith("0x")) {
            sserial = sserial.substring(2);
            radix = 16;
        }
        BigInteger serial = new BigInteger(sserial, radix);
        return serial;
    }

    public byte[] getIssuerNamehash() throws X509ParserException {
        try {
            byte[] nameHash = HashUtil.hash(ASN1Util.derToByteArray(this.bcX509.getIssuer().toASN1Primitive()), "SHA1");
            return nameHash;
        }
        catch (IOException ioe) {
            throw new X509ParserException("Failed to create IssuerNamehash from X509Certificate. Invalid Issuer X509Name bytes in X509: " + ioe.getMessage());
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new X509ParserException("Failed to create IssuerNamehash from X509Certificate. Failed to hash Issuer X509Name: " + nsae.getMessage());
        }
        catch (Throwable nsae) {
            throw new X509ParserException("Failed to create IssuerNamehash from X509Certificate. Failed to hash Issuer X509Name: " + nsae.getMessage());
        }
    }

    public Date getNotBefore() {
        return this.cert.getNotBefore();
    }

    public Date getNotAfter() {
        return this.cert.getNotAfter();
    }

    public String getUniqueId() {
        if (null == this.cert) {
            return null;
        }
        TBSCertificate tbs = this.bcX509.getTBSCertificate();
        if (null == tbs) {
            return null;
        }
        return tbs.getSerialNumber().getValue().toString();
    }

    public String extractFullCrlDistributionPoint() {
        CRLDistPoint distributionPointsExtension = this.extractCrlDistributionPointsExtension();
        if (null == distributionPointsExtension) {
            return null;
        }
        String fullCrlDistributionPoint = this.extractFullCrlDistributionPoint(distributionPointsExtension);
        return fullCrlDistributionPoint;
    }

    public String extractPartitionedCRLDistributionPoint() {
        CRLDistPoint distributionPointsExtension = this.extractCrlDistributionPointsExtension();
        if (null == distributionPointsExtension) {
            return null;
        }
        String partitionedCRLDistributionPoint = this.extractPartitionedCrlDistributionPoint(distributionPointsExtension);
        return partitionedCRLDistributionPoint;
    }

    private CRLDistPoint extractCrlDistributionPointsExtension() {
        Extensions extensions = this.extractExtensions();
        if (null == extensions) {
            return null;
        }
        Enumeration extensionOids = extensions.oids();
        while (extensionOids.hasMoreElements()) {
            ASN1ObjectIdentifier extensionOid = (ASN1ObjectIdentifier)extensionOids.nextElement();
            if (!extensionOid.equals((Object)Extension.cRLDistributionPoints)) continue;
            return this.convertToCRLDistPoint(extensions, extensionOid);
        }
        return null;
    }

    private String extractFullCrlDistributionPoint(CRLDistPoint distributionPointsExtension) {
        if (null == distributionPointsExtension) {
            return null;
        }
        DERIA5String crlDistributionPointGeneralName = (DERIA5String)this.extractGeneralName(distributionPointsExtension, 6);
        return crlDistributionPointGeneralName != null ? crlDistributionPointGeneralName.getString() : null;
    }

    private String extractPartitionedCrlDistributionPoint(CRLDistPoint distributionPointsExtension) {
        if (null == distributionPointsExtension) {
            return null;
        }
        ASN1Encodable directoryNames = this.extractGeneralName(distributionPointsExtension, 4);
        return this.extractPartitionedCrlDistributionPoint(directoryNames);
    }

    private String extractPartitionedCrlDistributionPoint(ASN1Encodable directoryNames) {
        if (null == directoryNames) {
            return null;
        }
        DERSequence ds = (DERSequence)directoryNames;
        Enumeration enumerator = ds.getObjects();
        String partitionedCrlDistributionPoint = "";
        while (enumerator.hasMoreElements()) {
            DERSet dset = (DERSet)enumerator.nextElement();
            partitionedCrlDistributionPoint = this.buildPartitionedCrlDistributionPoint(partitionedCrlDistributionPoint, dset);
        }
        return partitionedCrlDistributionPoint;
    }

    private String buildPartitionedCrlDistributionPoint(String partitionedCrlDistributionPoint, DERSet dset) {
        Enumeration dnComponents = dset.getObjects();
        while (dnComponents.hasMoreElements()) {
            DERSequence relativeDn = (DERSequence)dnComponents.nextElement();
            String relativeDnOid = ((ASN1ObjectIdentifier)relativeDn.getObjectAt(0)).getId();
            String relativeDnName = BCStyle.INSTANCE.oidToDisplayName(new ASN1ObjectIdentifier(relativeDnOid));
            String relativeDnValue = ((ASN1String)relativeDn.getObjectAt(1)).getString();
            String comma = partitionedCrlDistributionPoint.length() > 0 ? "," : "";
            partitionedCrlDistributionPoint = relativeDnName + "=" + relativeDnValue + comma + partitionedCrlDistributionPoint;
        }
        return partitionedCrlDistributionPoint;
    }

    private Extensions extractExtensions() {
        ASN1Sequence certificateAsAsn1 = this.toAsn1(this.cert);
        return this.extractExtensions(certificateAsAsn1);
    }

    private CRLDistPoint convertToCRLDistPoint(Extensions extensions, ASN1ObjectIdentifier extensionOid) {
        try {
            Extension extension = extensions.getExtension(extensionOid);
            ASN1OctetString asOctetString = extension.getExtnValue();
            ASN1InputStream asInputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(asOctetString.getOctets()));
            CRLDistPoint cdp = CRLDistPoint.getInstance((Object)asInputStream.readObject());
            return cdp;
        }
        catch (IOException e) {
            throw new IllegalStateException("IO error while extracting CRL Distribution points", e);
        }
    }

    private ASN1Sequence toAsn1(X509Certificate certificate) {
        try {
            ASN1InputStream inputStream = new ASN1InputStream(certificate.getEncoded());
            ASN1Primitive certificateAsAsn1 = inputStream.readObject();
            return (ASN1Sequence)certificateAsAsn1;
        }
        catch (IOException e) {
            throw new IllegalStateException("IO error while extracting CRL Distribution points", e);
        }
        catch (CertificateEncodingException e) {
            throw new IllegalStateException("Error while extracting CRL Distribution points", e);
        }
    }

    private Extensions extractExtensions(ASN1Sequence certificateAsAsn1) {
        Certificate certificateStructure = Certificate.getInstance((Object)certificateAsAsn1);
        return certificateStructure.getTBSCertificate().getExtensions();
    }

    private ASN1Encodable extractGeneralName(CRLDistPoint distributionPointsExtension, int uniformResourceIdentifier) {
        for (DistributionPoint distributionPoint : distributionPointsExtension.getDistributionPoints()) {
            DistributionPointName distributionPointName = distributionPoint.getDistributionPoint();
            if (distributionPointName.getType() != 0) continue;
            for (GeneralName generalName : GeneralNames.getInstance((Object)distributionPointName.getName()).getNames()) {
                if (generalName.getTagNo() != uniformResourceIdentifier) continue;
                return generalName.getName();
            }
        }
        return null;
    }

    private ASN1Encodable searchRDNFromArray(RDN[] array, ASN1ObjectIdentifier searchField) {
        if (array == null || array.length == 0 || searchField == null) {
            return null;
        }
        for (RDN rdn : array) {
            AttributeTypeAndValue[] typesAndValues = rdn.getTypesAndValues();
            if (typesAndValues == null || typesAndValues.length <= 0) continue;
            for (AttributeTypeAndValue typesAndValue : typesAndValues) {
                if (typesAndValue.getType() == null || !typesAndValue.getType().getId().equals(searchField.getId())) continue;
                return typesAndValue.getValue();
            }
        }
        return null;
    }
}

