/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.bc.cryptlib.x509;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import no.bbs.tt.bc.cryptlib.x509.X509Parser;
import no.bbs.tt.bc.cryptlib.x509.X509ParserException;

public class X509Util {
    private static final String OID_NO_BID_MOD_PERSONAL = "2.16.578.1.16.1.12.2.1";
    private static final ArrayList<String> OIDS_NOVERIFY_SIGN_ATTRS = new ArrayList();

    public static boolean hasVerifiableSignAttrs(X509Certificate certificate) throws InstantiationException, X509ParserException {
        X509Parser xp = new X509Parser(certificate);
        String[] oids = xp.getPolicyIdentifiers();
        if (null != oids) {
            for (String oid : oids) {
                if (!OIDS_NOVERIFY_SIGN_ATTRS.contains(oid)) continue;
                return false;
            }
        }
        return true;
    }

    public static X509Certificate[] arrangeCertificateChain(X509Certificate[] x509certificates, boolean bool) {
        if (null != x509certificates && x509certificates.length > 0 && null != x509certificates[0]) {
            ArrayList<X509Certificate> vector_28_ = new ArrayList<X509Certificate>();
            ArrayList<X509Certificate> x509s = new ArrayList<X509Certificate>();
            x509s.add(x509certificates[0]);
            for (int i = 1; i < x509certificates.length; ++i) {
                vector_28_.add(x509certificates[i]);
            }
            boolean bool_29_ = false;
            boolean bool_30_ = false;
            while (!(vector_28_.size() <= 0 || bool_30_ && bool_29_)) {
                String name;
                X509Certificate x509certificate;
                int i;
                boolean bool_31_ = false;
                for (i = 0; i < vector_28_.size() && !bool_31_ && !bool_29_; ++i) {
                    x509certificate = (X509Certificate)x509s.get(x509s.size() - 1);
                    X509Certificate x509certificate_32_ = (X509Certificate)vector_28_.get(i);
                    name = x509certificate.getSubjectDN().getName();
                    String name_33_ = x509certificate_32_.getIssuerDN().getName();
                    if (name == null) break;
                    if (!name_33_.equals(name)) continue;
                    try {
                        x509certificate_32_.verify(x509certificate.getPublicKey());
                        bool_31_ = true;
                        vector_28_.remove(i);
                        x509s.add(x509certificate_32_);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!bool_31_) {
                    bool_29_ = true;
                }
                bool_31_ = false;
                for (i = 0; i < vector_28_.size() && !bool_31_ && !bool_30_; ++i) {
                    x509certificate = (X509Certificate)vector_28_.get(i);
                    X509Certificate x509certificate_34_ = (X509Certificate)x509s.get(0);
                    name = x509certificate.getSubjectDN().getName();
                    String name_35_ = x509certificate_34_.getIssuerDN().getName();
                    if (!name_35_.equals(name)) continue;
                    try {
                        x509certificate_34_.verify(x509certificate.getPublicKey());
                        bool_31_ = true;
                        vector_28_.remove(i);
                        x509s.add(0, x509certificate);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (bool_31_) continue;
                bool_30_ = true;
            }
            if (vector_28_.isEmpty()) {
                X509Certificate[] x509certificates_36_ = new X509Certificate[x509s.size()];
                for (int i = 0; i < x509certificates_36_.length; ++i) {
                    x509certificates_36_[i] = bool ? (X509Certificate)x509s.get(i) : (X509Certificate)x509s.get(x509s.size() - 1 - i);
                }
                return x509certificates_36_;
            }
            return null;
        }
        return null;
    }

    static {
        OIDS_NOVERIFY_SIGN_ATTRS.add(OID_NO_BID_MOD_PERSONAL);
    }
}

