/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.keyutil.labours;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAPublicKey;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import no.bbs.tt.keyutil.exception.KeyUtilException;
import no.bbs.tt.keyutil.labours.KeyGenerator;
import no.bbs.tt.keyutil.util.CertificateUtil;
import no.bbs.tt.keyutil.util.FileUtil;
import no.bbs.tt.keyutil.util.FormatUtil;
import org.bouncycastle.jce.PKCS10CertificationRequest;

public class SoftKeyGenerator
implements KeyGenerator {
    @Override
    public void generateKeyPairAndCreateP10(File p10OutFile, File keyFile, String pw, int keysize, String dn) throws KeyUtilException {
        FileOutputStream fos;
        KeyPairGenerator keyPairGenerator;
        SecureRandom random;
        KeyStore pkcs12KeyStore = null;
        try {
            pkcs12KeyStore = KeyStore.getInstance("PKCS12", "BC");
        }
        catch (NoSuchProviderException nspe) {
            throw new KeyUtilException("Provider not present: ", nspe);
        }
        catch (KeyStoreException kse) {
            throw new KeyUtilException("Unable to create keystore: ", kse);
        }
        try {
            random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new KeyUtilException("SHA1PRNG algorithm not found: ", nsae);
        }
        try {
            keyPairGenerator = KeyPairGenerator.getInstance("RSA", "BC");
        }
        catch (NoSuchProviderException nspe) {
            throw new KeyUtilException("Provider not present: ", nspe);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new KeyUtilException("Unable to create BC keystore: ", nsae);
        }
        keyPairGenerator.initialize(keysize, random);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        byte[] p10Bytes = null;
        try {
            X500Principal principal = null;
            try {
                principal = new X500Principal(dn);
            }
            catch (IllegalArgumentException e) {
                throw new KeyUtilException("Invalid distinguished name: " + e.getMessage(), e);
            }
            PKCS10CertificationRequest p10 = new PKCS10CertificationRequest("SHA1withRSA", principal, keyPair.getPublic(), null, keyPair.getPrivate(), "BC");
            p10Bytes = p10.getEncoded();
            PKCS10CertificationRequest cr2 = new PKCS10CertificationRequest(p10Bytes);
            if (!cr2.verify("BC")) {
                throw new KeyUtilException("Unable to verify PKCS#10!");
            }
        }
        catch (InvalidKeyException e) {
            throw new KeyUtilException("Unable to create PKCS#10 request: " + e.getMessage(), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyUtilException("Unable to create PKCS#10 request: " + e.getMessage(), e);
        }
        catch (NoSuchProviderException e) {
            throw new KeyUtilException("Unable to create PKCS#10 request: " + e.getMessage(), e);
        }
        catch (SignatureException e) {
            throw new KeyUtilException("Unable to create PKCS#10 request: " + e.getMessage(), e);
        }
        String p10PemString = CertificateUtil.p10BytesToPem(p10Bytes);
        byte[] p10PemBytes = p10PemString.getBytes();
        String pubKeyDigestString = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1", "BC");
            RSAPublicKey k = (RSAPublicKey)keyPair.getPublic();
            byte[] pubKeyDigest = md.digest(k.getModulus().toByteArray());
            pubKeyDigestString = FormatUtil.toHexString(pubKeyDigest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyUtilException(e);
        }
        catch (NoSuchProviderException nspe) {
            throw new KeyUtilException("Provider not present: ", nspe);
        }
        try {
            pkcs12KeyStore.load(null);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new KeyUtilException(nsae);
        }
        catch (CertificateException ce) {
            throw new KeyUtilException(ce);
        }
        catch (IOException ie) {
            throw new KeyUtilException(ie);
        }
        List<Certificate> c = null;
        try {
            c = CertificateUtil.getCertificatesFromBytes("MIIB0DCCAXoCAQAwDQYJKoZIhvcNAQEEBQAwczELMAkGA1UEBhMCTk8xDjAMBgNVBAgTBWR1bW15MQ4wDAYDVQQHEwVkdW1teTEOMAwGA1UEChMFZHVtbXkxDjAMBgNVBAsTBWR1bW15MQ4wDAYDVQQDEwVkdW1teTEUMBIGCSqGSIb3DQEJARYFZHVtbXkwHhcNMDkxMDA1MTAzNDQ4WhcNMTkxMDAzMTAzNDQ4WjBzMQswCQYDVQQGEwJOTzEOMAwGA1UECBMFZHVtbXkxDjAMBgNVBAcTBWR1bW15MQ4wDAYDVQQKEwVkdW1teTEOMAwGA1UECxMFZHVtbXkxDjAMBgNVBAMTBWR1bW15MRQwEgYJKoZIhvcNAQkBFgVkdW1teTBcMA0GCSqGSIb3DQEBAQUAA0sAMEgCQQCv+OjCwy7Jqt6//AppEgHXMlOorDvGI7gd4/qzqg12sY297aRk3xzc9keXX9sTa5eYJm/Ew6zefZJkBb8hJs7VAgMBAAEwDQYJKoZIhvcNAQEEBQADQQAVu6q9gJmbA/gKrrKopwsm5QnHrR8tkyCbpSiN6QkR+TvtStO/GkHnuMIBy6SIgj39KknuAfCegyhu9VVAuL76".getBytes("ASCII7"));
        }
        catch (UnsupportedEncodingException uce) {
            throw new KeyUtilException(uce);
        }
        Certificate[] cs = new Certificate[c.size()];
        int count = 0;
        for (Certificate cert : c) {
            cs[count++] = cert;
        }
        try {
            pkcs12KeyStore.setKeyEntry(pubKeyDigestString, keyPair.getPrivate(), pw.toCharArray(), cs);
        }
        catch (KeyStoreException kse) {
            throw new KeyUtilException(kse);
        }
        try {
            fos = new FileOutputStream(keyFile);
        }
        catch (FileNotFoundException fnfe) {
            throw new KeyUtilException(fnfe);
        }
        try {
            pkcs12KeyStore.store(fos, pw.toCharArray());
        }
        catch (KeyStoreException kse) {
            throw new KeyUtilException(kse);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new KeyUtilException(nsae);
        }
        catch (CertificateException ce) {
            throw new KeyUtilException(ce);
        }
        catch (IOException ie) {
            throw new KeyUtilException(ie);
        }
        finally {
            if (fos != null) {
                try {
                    fos.flush();
                    fos.close();
                }
                catch (IOException ioe) {
                    throw new KeyUtilException("Unable to close keystore file.", ioe);
                }
            }
        }
        try {
            FileUtil.writeToFile(p10OutFile, p10PemBytes);
        }
        catch (IOException e) {
            throw new KeyUtilException("Unable to write PKCS#10 to file: " + e.getMessage(), e);
        }
        System.out.println("RSA key pair successfully generated");
        System.out.println("PKCS#10 certificate request written to " + p10OutFile);
        System.out.println("Key file written to " + keyFile);
    }
}

