/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.bc.cryptlib.ds;

import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import no.bbs.tt.bc.cryptlib.ds.BCCryptoKeySelectorResult;

public class BCCryptoKeySelector
extends KeySelector {
    private X509Certificate signerCert = null;
    private List<X509Certificate> certificates = null;
    private boolean rootPresentInX509Data = false;
    private boolean validateIfX509IsExpired = true;

    public BCCryptoKeySelector(boolean isValidatingX509Expiry) {
        this.validateIfX509IsExpired = isValidatingX509Expiry;
    }

    @Override
    public BCCryptoKeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod method, XMLCryptoContext context) throws KeySelectorException {
        if (null == keyInfo) {
            return null;
        }
        if (null == keyInfo.getContent()) {
            return null;
        }
        boolean foundCertificate = false;
        Object[] keyInfoContent = keyInfo.getContent().toArray();
        this.certificates = new ArrayList<X509Certificate>();
        for (int i = 0; i < keyInfoContent.length; ++i) {
            XMLStructure kiType = (XMLStructure)keyInfoContent[i];
            if (!(kiType instanceof X509Data)) continue;
            X509Data x500Data = (X509Data)kiType;
            Object[] x500DataContent = x500Data.getContent().toArray();
            for (int j = 0; j < x500DataContent.length; ++j) {
                Object o = x500DataContent[j];
                if (!(o instanceof X509Certificate)) continue;
                X509Certificate tmpCert = (X509Certificate)o;
                this.certificates.add(tmpCert);
                if (tmpCert.getSubjectDN().getName().equals(tmpCert.getIssuerDN().getName())) {
                    this.rootPresentInX509Data = true;
                }
                if (tmpCert.getBasicConstraints() > -1) continue;
                this.signerCert = (X509Certificate)o;
                foundCertificate = true;
            }
        }
        if (null == this.signerCert) {
            throw new KeySelectorException("BCCryptoKeySelector failed to locate signer X509Certificate");
        }
        if (null != this.signerCert) {
            if (this.validateIfX509IsExpired) {
                try {
                    this.signerCert.checkValidity();
                }
                catch (CertificateExpiredException e) {
                    throw new KeySelectorException("BCCryptoKeySelector failed. Signer certificate has expired [ExceptionMessage=" + e.getMessage() + "]");
                }
                catch (CertificateNotYetValidException e) {
                    throw new KeySelectorException("BCCryptoKeySelector failed. Signer certificate not yet valid [ExceptionMessage=" + e.getMessage() + "]");
                }
            }
            return new BCCryptoKeySelectorResult(this.signerCert.getPublicKey());
        }
        return null;
    }

    public X509Certificate getSignerCertificate() {
        return this.signerCert;
    }

    public List<X509Certificate> getCertificates() {
        return this.certificates;
    }

    public boolean isRootPresentInX509Data() {
        return this.rootPresentInX509Data;
    }
}

