/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.bc.cryptlib.pkcs7;

import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.Time;
import org.bouncycastle.cms.CMSAttributeTableGenerationException;
import org.bouncycastle.cms.CMSAttributeTableGenerator;

public class TSCMSAttributeTableGenerator
implements CMSAttributeTableGenerator {
    private final Hashtable table;

    public TSCMSAttributeTableGenerator() {
        this.table = new Hashtable();
    }

    public TSCMSAttributeTableGenerator(AttributeTable attributeTable) {
        this.table = attributeTable != null ? attributeTable.toHashtable() : new Hashtable();
    }

    public AttributeTable getAttributes(Map parameters) throws CMSAttributeTableGenerationException {
        return new AttributeTable(this.createStandardAttributeTable(parameters));
    }

    protected Hashtable createStandardAttributeTable(Map parameters) {
        Attribute attr;
        Hashtable std = (Hashtable)this.table.clone();
        if (this.table.containsKey(CMSAttributes.contentType)) {
            std.put(CMSAttributes.contentType, this.table.get(CMSAttributes.contentType));
        } else {
            attr = new Attribute(CMSAttributes.contentType, (ASN1Set)new DERSet((ASN1Encodable)((ASN1ObjectIdentifier)parameters.get("contentType"))));
            std.put(attr.getAttrType(), attr);
        }
        if (this.table.containsKey(CMSAttributes.signingTime)) {
            std.put(CMSAttributes.signingTime, this.table.get(CMSAttributes.signingTime));
        } else {
            attr = new Attribute(CMSAttributes.signingTime, (ASN1Set)new DERSet((ASN1Encodable)new Time(new Date())));
            std.put(attr.getAttrType(), attr);
        }
        if (this.table.containsKey(CMSAttributes.messageDigest)) {
            std.put(CMSAttributes.messageDigest, this.table.get(CMSAttributes.messageDigest));
        } else {
            byte[] hash = (byte[])parameters.get("digest");
            Attribute attr2 = hash != null ? new Attribute(CMSAttributes.messageDigest, (ASN1Set)new DERSet((ASN1Encodable)new DEROctetString(hash))) : new Attribute(CMSAttributes.messageDigest, (ASN1Set)new DERSet((ASN1Encodable)new DERNull()));
            std.put(attr2.getAttrType(), attr2);
        }
        return std;
    }
}

