/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.bc.cryptlib.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;

public class FileUtil {
    public void storeFile(String file, String data) throws IOException {
        BufferedWriter out = new BufferedWriter(new FileWriter(file.toString()));
        out.write(data);
        out.close();
    }

    public boolean fileExists(String filepath) {
        File file = new File(filepath);
        return file.exists();
    }

    public String readFileNewLine(String fileName) throws FileNotFoundException, IOException {
        BufferedReader in = null;
        StringBuffer read = new StringBuffer(400);
        in = new BufferedReader(new FileReader(fileName));
        String line = null;
        while ((line = in.readLine()) != null) {
            read.append(line + "\n");
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return read.toString();
    }

    public long getFileAge(String fileName) {
        File file = new File(fileName);
        long lastModified = file.lastModified();
        return System.currentTimeMillis() - lastModified;
    }

    public static InputStream getResourceFromStream(String file) throws Exception {
        InputStream in = FileUtil.class.getClassLoader().getResourceAsStream(file);
        if (in == null) {
            in = ClassLoader.getSystemResourceAsStream(file);
        }
        if (null == in) {
            try {
                in = new FileInputStream(new File(file));
            }
            catch (FileNotFoundException fnfe) {
                String errmsg = "Failed to load resource. Resource [" + file + "] is missing or is not in classpath.";
                throw new Exception(errmsg);
            }
        }
        return in;
    }

    public static byte[] readFile(String path) {
        File file = new File(path);
        if (!file.exists()) {
            System.err.println("The file " + path + " does not exist. Exiting");
            return null;
        }
        long fileLength = file.length();
        byte[] fileBytes = new byte[(int)fileLength];
        try {
            RandomAccessFile raf = new RandomAccessFile(file, "r");
            raf.readFully(fileBytes, 0, (int)fileLength);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return fileBytes;
    }

    public String getFileFromStream(String fileName) throws Exception {
        InputStream is;
        URL url = this.getClass().getResource("/" + fileName);
        if (null == url && null == (url = this.getClass().getClassLoader().getResource("/" + fileName)) && null == (is = this.getClass().getResourceAsStream("/" + fileName))) {
            return null;
        }
        return url.getFile();
    }
}

