/*
 * Decompiled with CFR 0.152.
 */
package no.bbs.tt.bc.cryptlib.util;

import java.security.SecureRandom;
import java.util.Random;
import no.bbs.tt.bc.cryptlib.util.Hexer;

public class RandomUtil {
    private static Random rn = new Random();
    private static SecureRandom rng = new SecureRandom();

    private RandomUtil() {
    }

    public static byte[] getSecureRandomBytes(int length) {
        byte[] res = new byte[length];
        rng.nextBytes(res);
        return res;
    }

    public static String getSecureRandomString() {
        try {
            byte[] res = new byte[20];
            rng.nextBytes(res);
            return RandomUtil.removeCRLF(new String(Hexer.encode(res)));
        }
        catch (Exception e) {
            return RandomUtil.randomstring(25, 30);
        }
    }

    private static int rand(int lo, int hi) {
        int n = hi - lo + 1;
        int i = rn.nextInt() % n;
        if (i < 0) {
            i = -i;
        }
        return lo + i;
    }

    private static String randomstring(int lo, int hi) {
        int n = RandomUtil.rand(lo, hi);
        byte[] b = new byte[n];
        for (int i = 0; i < n; ++i) {
            b[i] = (byte)RandomUtil.rand(97, 122);
        }
        return new String(b);
    }

    private static String removeCRLF(String text) {
        StringBuffer temp = new StringBuffer(text.length());
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '\r' || text.charAt(i) == '\n') continue;
            temp.append(text.charAt(i));
        }
        return temp.toString();
    }

    static {
        rng.generateSeed(20);
        byte[] res = new byte[20];
        rng.nextBytes(res);
    }
}

